/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.argument.ArgumentType;
import org.firebirdsql.gds.impl.argument.TypedArgument;

public final class SingleItem
extends TypedArgument {
    private static final long serialVersionUID = -8732644692849743977L;

    public SingleItem(int item, ArgumentType argumentType) {
        super(item, argumentType);
        if (argumentType != ArgumentType.Wide && argumentType != ArgumentType.TraditionalDpb && argumentType != ArgumentType.SingleTpb) {
            throw new IllegalArgumentException("Invalid argument type: " + argumentType);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.argumentType.writeLength(0, outputStream);
    }

    @Override
    public int getLength() {
        return 1 + this.argumentType.getLengthSize();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SingleItem)) {
            return false;
        }
        SingleItem otherSingleItem = (SingleItem)other;
        return this.getType() == otherSingleItem.getType();
    }

    public int hashCode() {
        return this.getType();
    }

    @Override
    public void copyTo(ParameterBuffer buffer, Encoding encoding) {
        buffer.addArgument(this.getType());
    }
}

