/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.security;

import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.ui.storage.PasswordRecoveryDialog;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class EnterPasswordDialog
extends BaseDialog {
    private static final Log log = Log.getLog(EnterPasswordDialog.class);
    private static final String DIALOG_ID = "DBeaver.EnterPasswordDialog";
    private String message;
    private Text passwordText;
    private String password;
    private Button showPasswordCheckbox;
    private Runnable recoveryHandler;
    private boolean recoverPassword;

    public EnterPasswordDialog(Shell parentShell, String title, String message, Runnable recoveryHandler) {
        super(parentShell, title, null);
        if (parentShell == null) {
            this.setShellStyle(96);
        }
        this.message = message;
        this.recoveryHandler = recoveryHandler;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Group credGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)this.message, (int)2, (int)768, (int)0);
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Font)credGroup.getFont()) * 20;
        this.passwordText = UIUtils.createLabelText((Composite)credGroup, (String)"Password", (String)"", (int)0x400800, (Object)gd);
        this.passwordText.addModifyListener(e -> this.getButton(0).setEnabled(!this.passwordText.getText().isEmpty()));
        if (this.password != null) {
            this.passwordText.setText(this.password);
        }
        this.showPasswordCheckbox = UIUtils.createCheckbox((Composite)credGroup, (String)"Show password", (String)"Show password text on screen", (boolean)false, (int)2);
        this.showPasswordCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int style = this.showPasswordCheckbox.getSelection() ? 2048 : 0x400800;
            this.passwordText = UIUtils.recreateTextControl((Text)this.passwordText, (int)style);
        }));
        if (this.recoveryHandler != null) {
            UIUtils.createLink((Composite)dialogArea, (String)"<a>Recover password</a>", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EnterPasswordDialog.this.recoverPassword = true;
                    EnterPasswordDialog.this.cancelPressed();
                }
            });
        }
        UIUtils.centerShell((Shell)this.getParentShell(), (Shell)this.getShell());
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.password = this.passwordText.getText();
        super.okPressed();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static String askPassword(Shell shell, String title, String message, String password) {
        EnterPasswordDialog dialog = new EnterPasswordDialog(shell, title, message, EnterPasswordDialog::recoverPassword);
        int dialogStyle = 0;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null || workbench.getActiveWorkbenchWindow() == null || !workbench.getActiveWorkbenchWindow().getShell().isVisible()) {
            dialogStyle |= 0x24000;
        }
        dialog.setShellStyle(dialog.getShellStyle() | dialogStyle);
        dialog.setPassword(password);
        if (dialog.open() == 0) {
            return dialog.password;
        }
        if (dialog.recoverPassword) {
            return EnterPasswordDialog.recoverPassword();
        }
        return null;
    }

    public static String recoverPassword() {
        ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
        String curModuleId = null;
        try {
            IPreferencesContainer container = (IPreferencesContainer)BeanUtils.invokeObjectMethod((Object)rootNode, (String)"getContainer");
            curModuleId = CommonUtils.toString((Object)container.getOption((Object)"org.eclipse.equinox.security.storage.requiredID"), null);
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        if (curModuleId == null) {
            curModuleId = "com.dbeaver.app.advanced.dbeaverpasswordprovider";
        }
        Shell shell = UIUtils.getActiveWorkbenchShell();
        String[] questions = InternalExchangeUtils.getPasswordRecoveryQuestions((ISecurePreferences)rootNode, (String)curModuleId);
        if (questions.length == 0) {
            UIUtils.showMessageBox((Shell)shell, (String)"No recovery questions", (String)"No password recovery questions were specified", (int)1);
            return null;
        }
        ProjectPasswordRecoveryDialog dialog = new ProjectPasswordRecoveryDialog(questions, shell, curModuleId);
        if (dialog.open() == 0) {
            return dialog.getPassword();
        }
        return null;
    }

    private static class ProjectPasswordRecoveryDialog
    extends PasswordRecoveryDialog {
        ProjectPasswordRecoveryDialog(String[] questions, Shell shell, String curModuleId) {
            super(questions, shell, curModuleId);
        }

        public String getPassword() {
            return InternalExchangeUtils.recoverPassword((String[])this.answersText, (ISecurePreferences)SecurePreferencesFactory.getDefault(), (String)this.moduleID);
        }
    }
}

