/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.resultset.document;

import com.dbeaver.ee.runtime.internal.ui.resultset.ResultsetMessages;
import com.dbeaver.ee.runtime.ui.resultset.document.DocumentFindReplaceTarget;
import com.dbeaver.ee.runtime.ui.resultset.document.DocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentRenderer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContext;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPasteSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class AbstractDocumentPresentation
extends AbstractPresentation
implements IResultSetEditor,
IAdaptable {
    private Canvas canvas;
    private List<DocumentFrame> frames = new ArrayList<DocumentFrame>();
    private DocumentFrame topFrame = null;
    private DocumentFrame selectedFrame;
    private int verticalOffset = 0;
    private int horizontalOffset = 0;
    private GC sizingGC;
    private ScrollBar vScroll;
    private ScrollBar hScroll;
    private Color colorShadow;
    private Color colorForeground;
    private Color editBorderColor;
    private Font normalFont;
    private Font largeFont;
    private Font smallFont;
    private Color backgroundAdded;
    private Color backgroundDeleted;
    private Color backgroundModified;
    private Color backgroundNormal;
    private final DocumentFindReplaceTarget findReplaceTarget = new DocumentFindReplaceTarget(this);

    protected AbstractDocumentPresentation() {
    }

    Color getColorShadow() {
        return this.colorShadow;
    }

    Color getColorForeground() {
        return this.colorForeground;
    }

    Color getEditBorderColor() {
        return this.editBorderColor;
    }

    Font getLargeFont() {
        return this.largeFont;
    }

    Font getSmallFont() {
        return this.smallFont;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(this.findReplaceTarget);
        }
        return null;
    }

    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        UIUtils.createHorizontalLine((Composite)parent);
        this.canvas = new Canvas(parent, 0x20000300);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.sizingGC = new GC((Drawable)this.canvas);
        this.colorShadow = this.canvas.getDisplay().getSystemColor(18);
        this.colorForeground = controller.getDefaultForeground();
        this.editBorderColor = this.canvas.getDisplay().getSystemColor(3);
        this.computeFonts();
        this.vScroll = this.canvas.getVerticalBar();
        this.vScroll.setVisible(true);
        this.hScroll = this.canvas.getHorizontalBar();
        this.hScroll.setVisible(true);
        this.canvas.addPaintListener(this::onPaint);
        this.canvas.addMouseMoveListener(this::onMouseMove);
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                AbstractDocumentPresentation.this.onMouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                AbstractDocumentPresentation.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                AbstractDocumentPresentation.this.onMouseUp(e);
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                AbstractDocumentPresentation.this.onKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
                AbstractDocumentPresentation.this.onKeyReleased(e);
            }
        });
        this.vScroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDocumentPresentation.this.onVerticalScroll();
            }
        });
        this.hScroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDocumentPresentation.this.onHorizontalScroll();
            }
        });
        this.canvas.addListener(11, event -> {
            this.updateMeasures(true);
            this.canvas.redraw();
        });
        this.canvas.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AbstractDocumentPresentation.this.onFocusGain(e);
            }
        });
        this.registerContextMenu();
        this.trackPresentationControl();
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)controller.getSite(), (Control)this.canvas);
        this.canvas.addDisposeListener(e -> {
            UIUtils.dispose((Resource)this.largeFont);
            UIUtils.dispose((Resource)this.smallFont);
            UIUtils.dispose((Resource)this.normalFont);
        });
        this.applyCurrentThemeSettings();
    }

    private void computeFonts() {
        UIUtils.dispose((Resource)this.largeFont);
        UIUtils.dispose((Resource)this.smallFont);
        UIUtils.dispose((Resource)this.normalFont);
        ITheme currentTheme = this.getController().getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme();
        Font rsFont = currentTheme != null ? currentTheme.getFontRegistry().get("org.jkiss.dbeaver.sql.resultset.font") : this.canvas.getFont();
        Font monospaceFont = UIUtils.getMonospaceFont();
        FontData[] fontData = monospaceFont.getFontData();
        fontData[0].setHeight(rsFont.getFontData()[0].getHeight());
        this.normalFont = new Font(monospaceFont.getDevice(), fontData[0]);
        fontData = this.normalFont.getFontData();
        fontData[0].setStyle(fontData[0].getStyle() | 1);
        fontData[0].setHeight(fontData[0].getHeight() + 4);
        this.largeFont = new Font(this.normalFont.getDevice(), fontData[0]);
        fontData = this.normalFont.getFontData();
        fontData[0].setHeight(fontData[0].getHeight() - 1);
        this.smallFont = new Font(this.normalFont.getDevice(), fontData[0]);
        this.canvas.setFont(this.normalFont);
    }

    protected void applyThemeSettings(ITheme currentTheme) {
        this.backgroundAdded = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.new.background");
        this.backgroundDeleted = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.deleted.background");
        this.backgroundModified = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.modified.background");
        this.backgroundNormal = this.controller.getDefaultBackground();
        this.computeFonts();
        this.updateMeasures(true);
    }

    private void onKeyPressed(KeyEvent e) {
        switch (e.keyCode) {
            case 0x1000004: {
                break;
            }
            case 0x1000003: {
                break;
            }
            case 0x1000001: {
                this.vScroll.setSelection(Math.max(0, this.vScroll.getSelection() - this.vScroll.getIncrement()));
                this.onVerticalScroll();
                break;
            }
            case 0x1000002: {
                this.vScroll.setSelection(Math.min(this.vScroll.getMaximum(), this.vScroll.getSelection() + this.vScroll.getIncrement()));
                this.onVerticalScroll();
                break;
            }
            case 0x1000005: {
                this.vScroll.setSelection(Math.max(0, this.vScroll.getSelection() - this.vScroll.getPageIncrement()));
                this.onVerticalScroll();
                break;
            }
            case 0x1000006: {
                this.vScroll.setSelection(Math.min(this.vScroll.getMaximum(), this.vScroll.getSelection() + this.vScroll.getPageIncrement()));
                this.onVerticalScroll();
                break;
            }
            case 0x1000007: {
                this.vScroll.setSelection(0);
                this.onVerticalScroll();
                break;
            }
            case 0x1000008: {
                this.vScroll.setSelection(this.vScroll.getMaximum());
                this.onVerticalScroll();
                break;
            }
            case 97: {
                if (this.selectedFrame == null || (e.stateMask & 0x40000) == 0) break;
                this.selectedFrame.selectAll();
                this.canvas.redraw();
                break;
            }
        }
    }

    private void onKeyReleased(KeyEvent e) {
    }

    private void onVerticalScroll() {
        if (this.verticalOffset == this.vScroll.getSelection()) {
            return;
        }
        this.verticalOffset = this.vScroll.getSelection();
        if (this.selectedFrame != null) {
            this.selectedFrame.updateEditorBounds();
        }
        this.canvas.redraw();
    }

    private void onHorizontalScroll() {
        if (this.horizontalOffset == this.hScroll.getSelection()) {
            return;
        }
        this.horizontalOffset = this.hScroll.getSelection();
        if (this.selectedFrame != null) {
            this.selectedFrame.updateEditorBounds();
        }
        this.canvas.redraw();
    }

    private void onPaint(PaintEvent e) {
        Rectangle clientArea = this.canvas.getClientArea();
        int pageHeight = clientArea.height;
        e.gc.setFont(this.canvas.getFont());
        this.topFrame = null;
        for (DocumentFrame frame : this.frames) {
            if (frame.getTopOffset() + frame.getSize().y < this.verticalOffset) continue;
            if (frame.getTopOffset() - this.verticalOffset > pageHeight) break;
            if (this.topFrame == null) {
                this.topFrame = frame;
            }
            Rectangle bounds = frame.getBounds(clientArea);
            frame.paintFrame(e.gc, this.canvas, bounds);
        }
    }

    private void onMouseMove(MouseEvent e) {
        DocumentFrame frame = this.getFrameAt(e.x, e.y);
        if (frame != null) {
            frame.onMouseMove(e);
        }
    }

    private void onMouseDown(MouseEvent e) {
        DocumentFrame newSelection;
        if ((this.canvas.getStyle() & 0x80000) != 524288) {
            this.canvas.forceFocus();
        }
        if ((newSelection = this.getFrameAt(e.x, e.y)) != this.selectedFrame) {
            this.closeEditor();
        }
        this.selectedFrame = newSelection;
        if (this.selectedFrame != null) {
            if (this.controller.getCurrentRow() != this.selectedFrame.getRow()) {
                this.controller.setCurrentRow(this.selectedFrame.getRow());
                this.controller.updateEditControls();
                this.canvas.redraw();
            }
            this.selectedFrame.onMouseDown(e);
        }
    }

    private void onMouseUp(MouseEvent e) {
        if (this.selectedFrame != null) {
            this.selectedFrame.onMouseUp(e);
        }
    }

    private void onMouseDoubleClick(MouseEvent e) {
        if (this.selectedFrame != null && this.selectedFrame.handleDoubleClick(e)) {
            return;
        }
        this.showEditor();
    }

    private void onFocusGain(FocusEvent e) {
    }

    Color getBackgroundNormal() {
        return this.backgroundNormal;
    }

    Color getBackgroundModified() {
        return this.backgroundModified;
    }

    Color getBackgroundDeleted() {
        return this.backgroundDeleted;
    }

    Color getBackgroundAdded() {
        return this.backgroundAdded;
    }

    private void showFrame(@NotNull DocumentFrame frame, int frameRow) {
        int vOffset = frame.getTopOffset() + frame.getRowOffset(frameRow);
        if (vOffset < this.verticalOffset || vOffset > this.verticalOffset + this.canvas.getClientArea().height) {
            this.vScroll.setSelection(frame.getTopOffset() + frame.getSize().y - this.canvas.getClientArea().height);
            this.onVerticalScroll();
        }
    }

    @Nullable
    private DocumentFrame findSelectedFrame() {
        ResultSetRow currentRow = this.controller.getCurrentRow();
        if (currentRow == null) {
            return null;
        }
        for (DocumentFrame frame : this.frames) {
            if (frame.getRow() != currentRow) continue;
            return frame;
        }
        return null;
    }

    @Nullable
    private DocumentFrame getFrameAt(int x, int y) {
        if (this.topFrame == null) {
            return null;
        }
        int posY = this.verticalOffset + y;
        int i = this.topFrame.getFrameNumber();
        while (i < this.frames.size()) {
            DocumentFrame frame = this.frames.get(i);
            if (frame.isInPosition(x, posY)) {
                return frame;
            }
            ++i;
        }
        return null;
    }

    int getVerticalOffset() {
        return this.verticalOffset;
    }

    int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    private void initFrames(boolean append) {
        if (this.controller.isRecordMode()) {
            this.clearFrames();
            this.clearMetaData();
            if (this.controller.getCurrentRow() != null) {
                DocumentFrame frame = new DocumentFrame(this, 0);
                frame.setRow(this.getDocumentAttribute(), this.controller.getCurrentRow());
                this.frames.add(frame);
            }
        } else {
            int firstRow = 0;
            if (!append) {
                this.clearFrames();
            } else {
                firstRow = this.frames.size();
            }
            ResultSetModel model = this.controller.getModel();
            int frameCount = model.getRowCount();
            int i = firstRow;
            while (i < frameCount) {
                DocumentFrame frame = new DocumentFrame(this, i);
                frame.setRow(this.getDocumentAttribute(), model.getRow(i));
                this.frames.add(frame);
                ++i;
            }
        }
        this.updateMeasures(true);
    }

    void updateMeasures(boolean refresh) {
        Rectangle clientArea = this.canvas.getClientArea();
        int pageHeight = clientArea.height;
        int pageWidth = clientArea.width;
        int totalHeight = 0;
        int maxWidth = 0;
        for (DocumentFrame frame : this.frames) {
            frame.setTopOffset(totalHeight);
            if (refresh) {
                frame.updateSizes(this.sizingGC, false);
            }
            Point frameSize = frame.getSize();
            totalHeight += frameSize.y;
            maxWidth = Math.max(maxWidth, frameSize.x);
        }
        if (refresh) {
            this.vScroll.setValues(0, 0, totalHeight, pageHeight, 32, pageHeight);
            this.hScroll.setValues(0, 0, maxWidth, pageWidth, 32, pageWidth);
            this.hScroll.setVisible(maxWidth > pageWidth);
            this.onHorizontalScroll();
            this.onVerticalScroll();
        }
    }

    private void clearFrames() {
        for (DocumentFrame frame : this.frames) {
            frame.dispose();
        }
        this.frames.clear();
        this.selectedFrame = null;
    }

    public Canvas getControl() {
        return this.canvas;
    }

    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        this.canvas.setRedraw(false);
        try {
            this.initFrames(append);
        }
        finally {
            this.canvas.setRedraw(true);
        }
    }

    public void formatData(boolean refreshData) {
    }

    public void clearMetaData() {
        this.topFrame = null;
        this.verticalOffset = 0;
        this.horizontalOffset = 0;
    }

    public void updateValueView() {
    }

    public void changeMode(boolean recordMode) {
    }

    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        this.closeEditor();
        super.scrollToRow(position);
        this.selectedFrame = this.findSelectedFrame();
        if (this.selectedFrame != null) {
            this.showFrame(this.selectedFrame, 0);
        }
    }

    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.getDocumentAttribute();
    }

    @NotNull
    public Map<Transfer, Object> copySelection(ResultSetCopySettings settings) {
        if (this.selectedFrame != null) {
            return Collections.singletonMap(TextTransfer.getInstance(), this.selectedFrame.convertToString(settings.isCopyHeader(), settings.getFormat()));
        }
        return Collections.emptyMap();
    }

    @Nullable
    private DBDAttributeBinding getDocumentAttribute() {
        DBDAttributeBinding documentAttribute = this.controller.getModel().getDocumentAttribute();
        if (documentAttribute != null) {
            return documentAttribute;
        }
        IResultSetContext context = (IResultSetContext)GeneralUtils.adapt((Object)this.controller, IResultSetContext.class);
        if (context != null) {
            return context.getDocumentAttribute();
        }
        return null;
    }

    IEditorPart createEditor(Composite frame, DBDDocument document, boolean readOnly) throws DBException {
        SubEditorSite site = new SubEditorSite(this.controller.getSite());
        IEditorInput input = this.createEditorInput(document, readOnly);
        IEditorPart editor = this.createEditorPart();
        try {
            editor.init((IEditorSite)site, input);
        }
        catch (PartInitException e) {
            editor.dispose();
            throw new DBException(ResultsetMessages.AbstractDocumentPresentation_e_cannot_init_document, (Throwable)e);
        }
        editor.createPartControl(frame);
        if (editor instanceof BaseTextEditor) {
            StyledText textWidget = ((BaseTextEditor)editor).getTextViewer().getTextWidget();
            TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.controller.getSite(), (Control)textWidget);
            textWidget.setAlwaysShowScrollBars(false);
            textWidget.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 27: {
                            AbstractDocumentPresentation.this.closeEditor();
                        }
                    }
                }
            });
        }
        frame.layout();
        editor.setFocus();
        return editor;
    }

    private void showEditor() {
        if (this.getController().isReadOnly()) {
            return;
        }
        if (this.selectedFrame != null) {
            try {
                this.selectedFrame.updateSizes(this.sizingGC, true);
                Rectangle clientArea = this.getControl().getClientArea();
                if (this.selectedFrame.getTopOffset() < this.verticalOffset || this.selectedFrame.getTopOffset() + this.selectedFrame.getSize().y > this.verticalOffset + clientArea.height) {
                    this.verticalOffset = this.selectedFrame.getTopOffset();
                    this.vScroll.setSelection(this.verticalOffset);
                }
                this.selectedFrame.showEditor();
            }
            catch (DBException ex) {
                DBWorkbench.getPlatformUI().showError(ResultsetMessages.AbstractDocumentPresentation_e_editor_open_title, ResultsetMessages.AbstractDocumentPresentation_e_editor_open_message, (Throwable)ex);
            }
        }
    }

    public void applyChanges() {
        if (this.selectedFrame != null && this.selectedFrame.getEditor() != null) {
            this.selectedFrame.saveEditorChanges();
            this.closeEditor();
        }
        super.applyChanges();
    }

    public void rejectChanges() {
        if (this.selectedFrame != null) {
            this.selectedFrame.closeEditor();
        }
    }

    void closeEditor() {
        if (this.selectedFrame != null) {
            this.selectedFrame.closeEditor();
            this.selectedFrame.updateSizes(this.sizingGC, false);
            this.canvas.redraw();
        }
        this.controller.updateDirtyFlag();
    }

    public boolean isDirty() {
        return this.selectedFrame != null && this.selectedFrame.isEditMode();
    }

    protected byte[] convertDocumentToData(DBDDocument document) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            document.serializeDocument((DBRProgressMonitor)new VoidProgressMonitor(), (OutputStream)baos, StandardCharsets.UTF_8);
            return baos.toByteArray();
        }
        catch (Exception e) {
            StringWriter buf = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)buf, true));
            return ("Error transforming document: " + buf.toString()).getBytes();
        }
    }

    @Nullable
    public Control openValueEditor(boolean inline) {
        if (this.selectedFrame != null) {
            this.showEditor();
            return this.selectedFrame.getEditorFrame();
        }
        return null;
    }

    public void pasteFromClipboard(@Nullable ResultSetPasteSettings settings) {
    }

    public ISelection getSelection() {
        if (this.selectedFrame == null) {
            return new StructuredSelection();
        }
        return new DocumentSelection();
    }

    public void setSelection(ISelection selection) {
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof DocumentFrame) {
            this.selectedFrame = (DocumentFrame)firstElement;
        }
    }

    Point getTextSelection() {
        return this.selectedFrame == null ? new Point(0, 0) : this.selectedFrame.getSelection();
    }

    void setTextSelection(int offset, int length) {
        if (this.selectedFrame != null) {
            this.selectedFrame.setSelection(offset, length);
        }
    }

    String getSelectionText() {
        if (this.selectedFrame != null) {
            Point selectionStart = this.selectedFrame.getSelectionStart();
            Point selectionEnd = this.selectedFrame.getSelectionEnd();
            if (selectionStart != null && selectionEnd != null && !selectionStart.equals((Object)selectionEnd)) {
                return this.selectedFrame.convertToString(false, DBDDisplayFormat.UI);
            }
        }
        return "";
    }

    int findText(int offset, boolean searchForward, Pattern findPattern) {
        block5: {
            if (this.selectedFrame == null && !this.frames.isEmpty()) {
                this.selectedFrame = this.frames.get(0);
            }
            if (this.selectedFrame != null) {
                Point nextOffset = this.selectedFrame.findText(offset, searchForward, findPattern);
                if (nextOffset != null) {
                    return this.showFoundText(nextOffset);
                }
                this.selectedFrame.setSelection(0, 0);
            }
            if (this.selectedFrame != null && !this.frames.isEmpty()) {
                int nextFrameNum;
                Point nextOffset;
                offset = 0;
                DocumentFrame nextFrame = this.selectedFrame;
                do {
                    if ((nextFrameNum = nextFrame.getFrameNumber() + 1) < this.frames.size()) continue;
                    this.selectedFrame = this.frames.get(0);
                    this.getController().setCurrentRow(this.selectedFrame.getRow());
                    break block5;
                } while ((nextOffset = (nextFrame = this.frames.get(nextFrameNum)).findText(offset, searchForward, findPattern)) == null);
                this.selectedFrame = nextFrame;
                this.getController().setCurrentRow(nextFrame.getRow());
                return this.showFoundText(nextOffset);
            }
        }
        return -1;
    }

    private int showFoundText(Point nextOffset) {
        int rowNumber = nextOffset.x / this.selectedFrame.getSize().x;
        if (rowNumber > 0) {
            --rowNumber;
        }
        this.setTextSelection(nextOffset.x, nextOffset.y);
        this.showFrame(this.selectedFrame, rowNumber);
        this.canvas.redraw();
        return nextOffset.x;
    }

    void redraw() {
        this.canvas.redraw();
    }

    @NotNull
    protected abstract IDocumentRenderer createRenderer(@NotNull IDocumentFrame var1);

    @NotNull
    protected abstract IEditorInput createEditorInput(@NotNull DBDDocument var1, boolean var2);

    @NotNull
    protected abstract IEditorPart createEditorPart() throws DBException;

    @NotNull
    public abstract DBDDocument createDocumentFromContent(@NotNull DBDContent var1);

    @NotNull
    protected abstract DBDDocument createNewDocument() throws DBException;

    private class DocumentSelection
    extends StructuredSelection
    implements IResultSetSelection {
        DocumentSelection() {
            super((Object)AbstractDocumentPresentation.this.selectedFrame);
        }

        @NotNull
        public IResultSetController getController() {
            return AbstractDocumentPresentation.this.controller;
        }

        @NotNull
        public List<DBDAttributeBinding> getSelectedAttributes() {
            DBDAttributeBinding currentAttribute = AbstractDocumentPresentation.this.getCurrentAttribute();
            return currentAttribute == null ? Collections.emptyList() : Collections.singletonList(currentAttribute);
        }

        @NotNull
        public List<ResultSetRow> getSelectedRows() {
            return Collections.singletonList(AbstractDocumentPresentation.this.selectedFrame.getRow());
        }

        public DBDAttributeBinding getElementAttribute(Object element) {
            return AbstractDocumentPresentation.this.getCurrentAttribute();
        }

        public ResultSetRow getElementRow(Object element) {
            return AbstractDocumentPresentation.this.selectedFrame.getRow();
        }
    }
}

