/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.connections.k8s;

import com.dbeaver.ee.runtime.ui.connections.k8s.K8SServiceListDialog;
import com.dbeaver.net.k8s.K8SContextInfo;
import com.dbeaver.net.k8s.K8SNamespaceInfo;
import com.dbeaver.net.k8s.K8SServiceInfo;
import com.dbeaver.net.k8s.K8STunnelImpl;
import com.dbeaver.net.k8s.KubeCtrlExecutor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRInvoker;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.AbstractTrackingJob;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ConfigurationFileSelector;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class K8STunnelConfiguratorUI
implements IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> {
    private static final Log log = Log.getLog(K8STunnelConfiguratorUI.class);
    private DBWHandlerConfiguration savedConfiguration;
    private ConfigurationFileSelector configPath;
    private Combo contextCombo;
    private Combo namespaceCombo;
    private Text resourceName;
    private Text remotePort;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        UIUtils.createInfoLabel((Composite)composite, (String)"Configure Kubernetes port forwarding by using kubectl");
        Group configGroup = UIUtils.createControlGroup((Composite)composite, (String)"Tunnel configuration", (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)configGroup, (String)"Configuration");
        this.configPath = new ConfigurationFileSelector((Composite)configGroup, "Kubectl configuration path", new String[]{"*"});
        this.configPath.getTextControl().setMessage("~/.kube/config");
        this.configPath.setLayoutData((Object)new GridData(768));
        this.configPath.getTextControl().addModifyListener(e -> propertyChangeListener.run());
        GridData textGD = new GridData(768);
        UIUtils.createControlLabel((Composite)configGroup, (String)"Context");
        Composite resPanel = UIUtils.createComposite((Composite)configGroup, (int)2);
        resPanel.setLayoutData((Object)new GridData(768));
        this.contextCombo = new Combo(resPanel, 2052);
        this.contextCombo.setLayoutData((Object)textGD);
        this.createToolButton(resPanel, "Load contexts", (DBPImage)UIIcon.REFRESH, this::loadContexts);
        UIUtils.createControlLabel((Composite)configGroup, (String)"Namespace");
        resPanel = UIUtils.createComposite((Composite)configGroup, (int)2);
        resPanel.setLayoutData((Object)new GridData(768));
        this.namespaceCombo = new Combo(resPanel, 2052);
        this.namespaceCombo.setLayoutData((Object)textGD);
        this.createToolButton(resPanel, "Load namespaces", (DBPImage)UIIcon.REFRESH, this::loadNamespaces);
        UIUtils.createControlLabel((Composite)configGroup, (String)"Resource");
        resPanel = UIUtils.createComposite((Composite)configGroup, (int)2);
        resPanel.setLayoutData((Object)new GridData(768));
        this.resourceName = new Text(resPanel, 2048);
        this.resourceName.setMessage("ID of pod, deployment or service");
        this.resourceName.setLayoutData((Object)textGD);
        this.createToolButton(resPanel, "Find resource", (DBPImage)UIIcon.DROP_DOWN, this::browseNamespaceServices);
        this.resourceName.addModifyListener(e -> propertyChangeListener.run());
        this.remotePort = UIUtils.createLabelText((Composite)configGroup, (String)"Port", null);
        this.remotePort.setLayoutData((Object)textGD);
        this.remotePort.addModifyListener(e -> propertyChangeListener.run());
        UIUtils.createLink((Composite)composite, (String)"You have to have <a>kubectl</a> tool installed on your local machine.\nAlso you need Kubernetes <a>configuration file</a> (use the local one or ask your administrator).", (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
            String link = "kubectl".equals(e.text) ? "https://kubernetes.io/docs/tasks/tools/" : "https://kubernetes.io/docs/concepts/configuration/organize-cluster-access-kubeconfig/";
            UIUtils.openWebBrowser((String)link);
        }));
        Composite buttonsPanel = UIUtils.createComposite((Composite)composite, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)" Test port forwarding ", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                K8STunnelConfiguratorUI.this.testTunnelConnection();
            }
        });
        UIUtils.createEmptyLabel((Composite)buttonsPanel, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)" Configuration ", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.showPreferencesFor((Shell)composite.getShell(), null, (String[])new String[]{"com.dbeaver.ee.runtime.ui.preferencePages.page.k8s"});
            }
        });
    }

    private void createToolButton(Composite panel, String title, DBPImage image, final DBRInvoker<?> action) {
        ToolBar toolBar = new ToolBar(panel, 256);
        UIUtils.createToolItem((ToolBar)toolBar, (String)title, (DBPImage)image, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    action.invoke();
                }
                catch (Exception ex) {
                    DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex));
                }
            }
        });
    }

    public void loadSettings(@NotNull DBWHandlerConfiguration configuration) {
        this.configPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("config")));
        this.contextCombo.setText(CommonUtils.toString((Object)configuration.getStringProperty("context"), (String)"default"));
        this.namespaceCombo.setText(CommonUtils.toString((Object)configuration.getStringProperty("namespace"), (String)"default"));
        this.resourceName.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("resource")));
        this.remotePort.setMessage("Database port in K8S service (default is " + K8STunnelImpl.getDefaultRemotePort((DBWHandlerConfiguration)configuration) + ")");
        this.remotePort.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("remotePort")));
        this.savedConfiguration = new DBWHandlerConfiguration(configuration);
    }

    private <T> T runKubectlCommand(final String actionTitle, final CommandExecutor<T> action) throws Throwable {
        ArrayList result;
        block2: {
            final DBWHandlerConfiguration configuration = new DBWHandlerConfiguration(this.savedConfiguration);
            configuration.setProperties(Collections.emptyMap());
            this.saveSettings(configuration);
            result = new ArrayList(1);
            AbstractTrackingJob job = new AbstractTrackingJob(actionTitle){

                protected void execute(@NotNull DBRProgressMonitor monitor) throws Throwable {
                    monitor.beginTask(actionTitle, 1);
                    try {
                        monitor.subTask(actionTitle);
                        result.add(action.executeCommand(monitor, configuration));
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                AbstractTrackingJob.executeInProgressMonitor((AbstractTrackingJob)job);
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block2;
                throw ex.getTargetException();
            }
        }
        return (T)result.get(0);
    }

    private boolean loadContexts() {
        try {
            K8SContextInfo contexts = this.runKubectlCommand("Load contexts", K8SContextInfo::getContextInfo);
            String oldValue = this.contextCombo.getText();
            this.contextCombo.removeAll();
            for (String ctxName : contexts.getContexts()) {
                this.contextCombo.add(ctxName);
            }
            this.contextCombo.setText(oldValue);
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Error loading contexts", null, GeneralUtils.makeExceptionStatus((Throwable)e));
            return false;
        }
        return true;
    }

    private boolean loadNamespaces() {
        try {
            K8SNamespaceInfo contexts = this.runKubectlCommand("Load namespaces", K8SNamespaceInfo::getNamespaceInfo);
            String oldValue = this.namespaceCombo.getText();
            this.namespaceCombo.removeAll();
            for (String ctxName : contexts.getNamespaces()) {
                this.namespaceCombo.add(ctxName);
            }
            this.namespaceCombo.setText(oldValue);
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Error loading namespaces", null, GeneralUtils.makeExceptionStatus((Throwable)e));
            return false;
        }
        return true;
    }

    private boolean browseNamespaceServices() {
        try {
            K8SServiceInfo services = this.runKubectlCommand("Load namespaces", K8SServiceInfo::getServiceInfo);
            K8SServiceListDialog dialog = new K8SServiceListDialog(this.resourceName.getShell(), services);
            if (dialog.open() == 0 && dialog.getSelectedResource() != null) {
                this.resourceName.setText("service/" + dialog.getSelectedResource());
                if (dialog.getSelectedPort() > 0) {
                    this.remotePort.setText(String.valueOf(dialog.getSelectedPort()));
                }
            }
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Error loading namespaces", null, GeneralUtils.makeExceptionStatus((Throwable)e));
            return false;
        }
        return true;
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration configuration) {
        configuration.setProperty("config", (Object)this.configPath.getText());
        configuration.setProperty("context", (Object)this.contextCombo.getText());
        configuration.setProperty("namespace", (Object)this.namespaceCombo.getText());
        configuration.setProperty("resource", (Object)this.resourceName.getText());
        configuration.setProperty("remotePort", (Object)this.remotePort.getText());
    }

    public void resetSettings(@NotNull DBWHandlerConfiguration configuration) {
    }

    public boolean isComplete() {
        return !this.resourceName.getText().isEmpty();
    }

    private void testTunnelConnection() {
        block5: {
            if (CommonUtils.isEmpty((String)this.resourceName.getText())) {
                UIUtils.showMessageBox((Shell)this.resourceName.getShell(), (String)"Missing resource name", (String)"You must specify Kubernetes resource name", (int)1);
                return;
            }
            final DBWHandlerConfiguration configuration = new DBWHandlerConfiguration(this.savedConfiguration);
            configuration.setProperties(Collections.emptyMap());
            this.saveSettings(configuration);
            DBPDataSourceContainer dataSource = configuration.getDataSource();
            if (dataSource != null) {
                configuration.resolveDynamicVariables((IVariableResolver)new DataSourceVariableResolver(dataSource, dataSource.getConnectionConfiguration()));
            } else {
                configuration.resolveDynamicVariables((IVariableResolver)SystemVariablesResolver.INSTANCE);
            }
            final String[] versionText = new String[1];
            AbstractTrackingJob job = new AbstractTrackingJob("Test kubectl connection"){
                private K8STunnelImpl tunnel;

                protected void execute(@NotNull DBRProgressMonitor monitor) throws Throwable {
                    monitor.beginTask("Instantiate Kubernetes tunnel", 2);
                    this.tunnel = new K8STunnelImpl();
                    DBPConnectionConfiguration connectionConfig = new DBPConnectionConfiguration();
                    try {
                        monitor.subTask("Initialize kubectl");
                        this.tunnel.initializeHandler(monitor, configuration, connectionConfig);
                        try {
                            monitor.worked(1);
                            versionText[0] = KubeCtrlExecutor.executeCommand((DBRProgressMonitor)monitor, (DBWHandlerConfiguration)configuration, (boolean)false, (String[])new String[]{"version", "--output=yaml"});
                        }
                        finally {
                            monitor.subTask("Close tunnel");
                            this.tunnel.closeTunnel(monitor);
                        }
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }

                protected void canceling() {
                    super.canceling();
                    if (this.tunnel != null) {
                        try {
                            this.tunnel.closeTunnel((DBRProgressMonitor)new VoidProgressMonitor());
                        }
                        catch (Exception exception) {
                            log.debug((Object)"Error closing k8s tunnel");
                        }
                    }
                }
            };
            try {
                AbstractTrackingJob.executeInProgressMonitor((AbstractTrackingJob)job);
                EditTextDialog dialog = new EditTextDialog(this.resourceName.getShell(), ModelMessages.dialog_connection_wizard_start_connection_monitor_success, versionText[0], true);
                dialog.setAutoSize(true);
                dialog.open();
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block5;
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex.getTargetException()));
            }
        }
    }

    static interface CommandExecutor<T> {
        public T executeCommand(DBRProgressMonitor var1, DBWHandlerConfiguration var2) throws DBException;
    }
}

