/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.connections.k8s;

import com.dbeaver.net.k8s.K8SResourceType;
import com.dbeaver.net.k8s.K8SServiceInfo;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

class K8SServiceListDialog
extends BaseDialog {
    private K8SResourceType resourceType;
    private final K8SServiceInfo serviceInfo;
    private Map.Entry<String, K8SServiceInfo.ServicePortInfo> selectedService = null;

    public K8SServiceListDialog(Shell parentShell, K8SServiceInfo serviceInfo) {
        super(parentShell, "Services", null);
        this.serviceInfo = serviceInfo;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite mainGroup = UIUtils.createComposite((Composite)composite, (int)1);
        mainGroup.setLayoutData((Object)new GridData(1808));
        UIUtils.createInfoLabel((Composite)mainGroup, (String)"Services");
        Table svcTable = new Table(mainGroup, 2052);
        svcTable.setLayoutData((Object)new GridData(1808));
        svcTable.setHeaderVisible(true);
        UIUtils.createTableColumn((Table)svcTable, (int)16384, (String)"Service");
        UIUtils.createTableColumn((Table)svcTable, (int)16384, (String)"Port");
        for (Map.Entry svcE : this.serviceInfo.getServiceMap().entrySet()) {
            TableItem item = new TableItem(svcTable, 0);
            item.setText(0, (String)svcE.getKey());
            item.setText(1, String.valueOf(((K8SServiceInfo.ServicePortInfo)svcE.getValue()).getPort()));
            item.setData(svcE);
        }
        svcTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button okButton = K8SServiceListDialog.this.getButton(0);
                if (okButton != null) {
                    K8SServiceListDialog.this.selectedService = e.item != null ? (Map.Entry)e.item.getData() : null;
                    okButton.setEnabled(K8SServiceListDialog.this.selectedService != null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
                K8SServiceListDialog.this.okPressed();
            }
        });
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)svcTable, (boolean)true));
        return composite;
    }

    @NotNull
    private Button createResourceTypeItem(Composite typeGroup, K8SResourceType type) {
        return UIUtils.createRadioButton((Composite)typeGroup, (String)type.getTitle(), (Object)type, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
            }
        });
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent, int alignment) {
        super.createButtonsForButtonBar(parent, alignment);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }

    public K8SResourceType getResourceType() {
        return this.resourceType;
    }

    public String getSelectedResource() {
        return this.selectedService == null ? null : this.selectedService.getKey();
    }

    public int getSelectedPort() {
        return this.selectedService == null ? 0 : this.selectedService.getValue().getPort();
    }
}

