/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.json;

import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.TextRenderer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public class JSONRenderer
extends TextRenderer {
    private Color colorDefault;
    private Color colorKey;
    private Color colorString;
    private Color colorValue;
    private DecimalFormat decimalFormat = new DecimalFormat("0");

    public JSONRenderer(IDocumentFrame documentFrame) {
        super(documentFrame);
        this.decimalFormat.setMaximumFractionDigits(340);
        DBPPreferenceStore store = documentFrame.getController().getPreferenceStore();
        int maxObjectMembers = store.getInt("resultset.json.maxObjectMembers");
        int maxArrayElements = store.getInt("resultset.json.maxArrayElements");
        int maxElementNesting = store.getInt("resultset.json.maxElementNesting");
        this.forEachNode(documentFrame.getDocument().getRootNode(), (node, level) -> {
            if (level == 0) {
                return;
            }
            if (maxElementNesting > 0 && level >= maxElementNesting) {
                this.setNodeState(node, TextRenderer.NodeState.collapsed);
            } else if (maxObjectMembers > 0 && node instanceof Map && ((Map)node).size() > maxObjectMembers) {
                this.setNodeState(node, TextRenderer.NodeState.collapsed);
            } else if (maxArrayElements > 0 && node instanceof Collection && ((Collection)node).size() > maxArrayElements) {
                this.setNodeState(node, TextRenderer.NodeState.collapsed);
            }
        });
    }

    @Override
    public void paintDocument(@NotNull GC gc, @NotNull Canvas canvas, @NotNull Rectangle bounds) {
        ColorRegistry colorRegistry = this.documentFrame.getController().getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorKey = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
        this.colorString = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.string.foreground");
        this.colorValue = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.number.foreground");
        this.colorDefault = canvas.getForeground();
        super.paintDocument(gc, canvas, bounds);
    }

    @Override
    protected void renderNode(TextRenderer.TextProcessor textProcessor, Object node, int x, int y) {
        this.renderJsonNode(textProcessor, null, node, x, y, 0, false);
    }

    private int renderJsonNode(@NotNull TextRenderer.TextProcessor processor, @Nullable String key, @Nullable Object node, int textX, int textY, int depth, boolean hasNext) {
        if (processor.isOutOfRange(textY)) {
            return 0;
        }
        ArrayList<TextRenderer.TextSegment> segments = new ArrayList<TextRenderer.TextSegment>();
        int lines = 1;
        if (key != null) {
            segments.add(new TextRenderer.TextSegment(String.valueOf(key) + ": ", this.colorKey));
        }
        if (node instanceof DBDComposite) {
            node = ((DBDComposite)node).getRawValue();
        }
        if (node instanceof Map || node instanceof Collection) {
            boolean isMap = node instanceof Map;
            boolean isEmpty = isMap ? ((Map)node).isEmpty() : ((Collection)node).isEmpty();
            boolean isCollapsed = this.isNodeCollapsed(node);
            if (depth > 0 && !isEmpty) {
                processor.drawState(node, isCollapsed ? TextRenderer.NodeState.collapsed : TextRenderer.NodeState.expanded, textX - 2, textY);
            }
            segments.add(new TextRenderer.TextSegment(isMap ? "{" : "[", this.colorDefault));
            if (!isEmpty) {
                if (!isCollapsed) {
                    processor.drawText(textX, textY, segments);
                    segments.clear();
                    if (isMap) {
                        it = ((Map)node).entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = (Map.Entry)it.next();
                            lines += this.renderJsonNode(processor, (String)entry.getKey(), entry.getValue(), textX + 4, textY + lines, depth + 1, it.hasNext());
                        }
                    } else {
                        it = ((Collection)node).iterator();
                        while (it.hasNext()) {
                            Object element = it.next();
                            lines += this.renderJsonNode(processor, null, element, textX + 4, textY + lines, depth + 1, it.hasNext());
                        }
                    }
                    ++lines;
                } else {
                    segments.add(new TextRenderer.TextSegment(" ... ", this.colorDefault));
                }
            }
            segments.add(new TextRenderer.TextSegment(isMap ? "}" : "]", this.colorDefault));
        } else if (node instanceof Float || node instanceof Double) {
            segments.add(new TextRenderer.TextSegment(this.decimalFormat.format(node), this.colorValue));
        } else if (node instanceof Date) {
            segments.add(new TextRenderer.TextSegment(JSONUtils.formatISODate((Date)((Date)node)), this.colorValue));
        } else if (node instanceof CharSequence) {
            segments.add(new TextRenderer.TextSegment(String.valueOf('\"') + CommonUtils.escapeJavaString((String)String.valueOf(node)) + '\"', this.colorString));
        } else if (node instanceof UUID) {
            segments.add(new TextRenderer.TextSegment("UUID(", this.colorValue));
            segments.add(new TextRenderer.TextSegment("\"" + String.valueOf(node) + "\"", this.colorString));
            segments.add(new TextRenderer.TextSegment(")", this.colorValue));
        } else {
            segments.add(new TextRenderer.TextSegment(String.valueOf(node), this.colorValue));
        }
        if (hasNext) {
            segments.add(new TextRenderer.TextSegment(",", this.colorDefault));
        }
        if (!segments.isEmpty()) {
            processor.drawText(textX, textY + lines - 1, segments);
        }
        return lines;
    }

    private void forEachNode(@NotNull Object node, @NotNull BiConsumer<Object, Integer> callback) {
        this.forEachNode(node, callback, 0);
    }

    private void forEachNode(@NotNull Object node, @NotNull BiConsumer<Object, Integer> callback, int level) {
        Collection children;
        if (node instanceof DBDComposite) {
            node = ((DBDComposite)node).getRawValue();
        }
        callback.accept(node, level);
        if (node instanceof Collection) {
            children = (Collection)node;
        } else if (node instanceof Map) {
            children = ((Map)node).values();
        } else {
            return;
        }
        for (Object element : children) {
            this.forEachNode(element, callback, level + 1);
        }
    }
}

