/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.preferences;

import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageResultSetPresentationJSON
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset.json";
    private Button collapseObjectsCheckbox;
    private Spinner collapseObjectsSpinner;
    private Button collapseArraysCheckbox;
    private Spinner collapseArraysSpinner;
    private Button collapseNestedElementsCheckbox;
    private Spinner collapseNestedElementsSpinner;

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)UiMessages.pref_page_resultset_presentation_json_group, (int)2, (int)2, (int)0);
        this.collapseObjectsCheckbox = UIUtils.createCheckbox((Composite)group, (String)UiMessages.pref_page_resultset_presentation_json_collapse_objects_label, (String)UiMessages.pref_page_resultset_presentation_json_collapse_objects_tip, (boolean)false, (int)1);
        this.collapseObjectsSpinner = UIUtils.createSpinner((Composite)group, null, (int)200, (int)1, (int)Integer.MAX_VALUE);
        this.collapseArraysCheckbox = UIUtils.createCheckbox((Composite)group, (String)UiMessages.pref_page_resultset_presentation_json_collapse_arrays_label, (String)UiMessages.pref_page_resultset_presentation_json_collapse_arrays_tip, (boolean)false, (int)1);
        this.collapseArraysSpinner = UIUtils.createSpinner((Composite)group, null, (int)200, (int)1, (int)Integer.MAX_VALUE);
        this.collapseNestedElementsCheckbox = UIUtils.createCheckbox((Composite)group, (String)UiMessages.pref_page_resultset_presentation_json_collapse_nested_objects_label, (String)UiMessages.pref_page_resultset_presentation_json_collapse_nested_objects_tip, (boolean)false, (int)0);
        this.collapseNestedElementsSpinner = UIUtils.createSpinner((Composite)group, null, (int)4, (int)1, (int)Integer.MAX_VALUE);
        this.collapseObjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageResultSetPresentationJSON.this.collapseObjectsSpinner.setEnabled(PrefPageResultSetPresentationJSON.this.collapseObjectsCheckbox.getSelection());
            }
        });
        this.collapseArraysCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageResultSetPresentationJSON.this.collapseArraysSpinner.setEnabled(PrefPageResultSetPresentationJSON.this.collapseArraysCheckbox.getSelection());
            }
        });
        this.collapseNestedElementsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageResultSetPresentationJSON.this.collapseNestedElementsSpinner.setEnabled(PrefPageResultSetPresentationJSON.this.collapseNestedElementsCheckbox.getSelection());
            }
        });
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        int maxObjectMembers = store.getInt("resultset.json.maxObjectMembers");
        int maxArrayElements = store.getInt("resultset.json.maxArrayElements");
        int maxElementNesting = store.getInt("resultset.json.maxElementNesting");
        this.collapseObjectsCheckbox.setSelection(maxObjectMembers > 0);
        this.collapseObjectsSpinner.setEnabled(maxObjectMembers > 0);
        this.collapseObjectsSpinner.setSelection(maxObjectMembers > 0 ? maxObjectMembers : 200);
        this.collapseArraysCheckbox.setSelection(maxArrayElements > 0);
        this.collapseArraysSpinner.setEnabled(maxArrayElements > 0);
        this.collapseArraysSpinner.setSelection(maxArrayElements > 0 ? maxArrayElements : 200);
        this.collapseNestedElementsCheckbox.setSelection(maxElementNesting > 0);
        this.collapseNestedElementsSpinner.setEnabled(maxElementNesting > 0);
        this.collapseNestedElementsSpinner.setSelection(maxElementNesting > 0 ? maxElementNesting : 4);
    }

    protected void savePreferences(DBPPreferenceStore store) {
        if (this.collapseObjectsCheckbox.getSelection()) {
            store.setValue("resultset.json.maxObjectMembers", this.collapseObjectsSpinner.getSelection());
        } else {
            store.setToDefault("resultset.json.maxObjectMembers");
        }
        if (this.collapseArraysCheckbox.getSelection()) {
            store.setValue("resultset.json.maxArrayElements", this.collapseArraysSpinner.getSelection());
        } else {
            store.setToDefault("resultset.json.maxArrayElements");
        }
        if (this.collapseNestedElementsCheckbox.getSelection()) {
            store.setValue("resultset.json.maxElementNesting", this.collapseNestedElementsSpinner.getSelection());
        } else {
            store.setToDefault("resultset.json.maxElementNesting");
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.json.maxObjectMembers");
        store.setToDefault("resultset.json.maxArrayElements");
        store.setToDefault("resultset.json.maxElementNesting");
    }

    protected void performDefaults() {
        DBPPreferenceStore store = this.getTargetPreferenceStore();
        this.clearPreferences(store);
        this.loadPreferences(store);
        super.performDefaults();
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer container) {
        DBPPreferenceStore store = container.getPreferenceStore();
        return store.contains("resultset.json.maxObjectMembers") || store.contains("resultset.json.maxArrayElements") || store.contains("resultset.json.maxElementNesting");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

