/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.ui.views;

import com.dbeaver.db.couchbase3.ui.CouchbaseUIActivator;
import com.dbeaver.db.couchbase3.ui.CouchbaseUIMessages;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class CouchBaseConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static ImageDescriptor logoImage = CouchbaseUIActivator.getImageDescriptor("icons/couchbase_logo.png");
    private Composite settingsGroup;
    private boolean activated;
    private Text nodeAddressText;
    private Text nodePortText;
    private Button useTLC;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        this.createGeneralTab(group);
        this.createAuthPanel(group, 1);
        this.createDriverPanel(group);
        this.setControl((Control)group);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = UIUtils.createComposite((Composite)parent, (int)1);
        GridData gd = new GridData(768);
        this.settingsGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)CouchbaseUIMessages.connection_page_control_group_server, (int)4, (int)768, (int)-1);
        this.nodeAddressText = UIUtils.createLabelText((Composite)serverGroup, (String)CouchbaseUIMessages.connection_page_control_text_node, (String)"", (int)2048);
        this.nodeAddressText.setLayoutData((Object)new GridData(768));
        this.nodeAddressText.addModifyListener(textListener);
        this.nodeAddressText.setText("localhost");
        this.nodePortText = UIUtils.createLabelText((Composite)serverGroup, (String)CouchbaseUIMessages.connection_page_control_text_port, (String)"");
        this.nodePortText.setToolTipText(CouchbaseUIMessages.connection_page_control_text_port_tooltip);
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Font)this.nodePortText.getFont()) * 10;
        this.nodePortText.setLayoutData((Object)gd);
        this.nodePortText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.nodePortText.addModifyListener(textListener);
        this.useTLC = UIUtils.createCheckbox((Composite)serverGroup, (boolean)false);
        this.useTLC.setText(CouchbaseUIMessages.connection_page_control_checkbox_ssl);
        this.useTLC.setToolTipText(CouchbaseUIMessages.connection_page_control_checkbox_ssl_tooltip);
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Font)this.useTLC.getFont()) * 10;
        this.useTLC.setLayoutData((Object)gd);
        return this.settingsGroup;
    }

    public boolean isComplete() {
        return super.isComplete() && !this.nodeAddressText.getText().isEmpty() && !this.nodePortText.getText().isEmpty();
    }

    public void loadSettings() {
        String portNumber;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        if (CommonUtils.isEmpty((String)hostName)) {
            hostName = "localhost";
        }
        if (CommonUtils.isEmpty((String)(portNumber = connectionInfo.getHostPort()))) {
            portNumber = String.valueOf(8091);
        }
        this.nodeAddressText.setText(hostName);
        this.nodePortText.setText(portNumber);
        if (connectionInfo.hasProperty("couchbase.sslEnabled")) {
            this.useTLC.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProperty("couchbase.sslEnabled")));
        }
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setHostName(this.nodeAddressText.getText().trim());
        connectionInfo.setHostPort(this.nodePortText.getText().trim());
        connectionInfo.setProperty("couchbase.sslEnabled", CommonUtils.toString((Object)this.useTLC.getSelection()));
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

