/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.ViewServiceException;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.transaction.util.TriFunction;
import com.couchbase.client.core.util.CbCollections;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
public class ConsistencyUtil {
    public static final String CLUSTER_VERSION_MB_50101 = "7.1.0";
    private static final ObjectMapper mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final Logger logger = LoggerFactory.getLogger(ConsistencyUtil.class);

    public static CoreHttpPath pathForUser(String domain, String name) {
        return CoreHttpPath.path("/settings/rbac/users/{domain}/{name}", CbCollections.mapOf("domain", domain, "name", name));
    }

    public static CoreHttpPath pathForGroup(String name) {
        return CoreHttpPath.path("/settings/rbac/groups/{name}", CbCollections.mapOf("name", name));
    }

    public static CoreHttpPath pathForBucket(String name) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}", CbCollections.mapOf("bucketName", name));
    }

    private static CoreHttpPath pathForScopes(String bucketName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}/scopes", CbCollections.mapOf("bucketName", bucketName));
    }

    public static CoreHttpPath pathForView(String bucketName, String designDocument, String viewName) {
        return CoreHttpPath.path("/{bucketName}/_design/{designDocument}/_view/{viewName}", CbCollections.mapOf("bucketName", bucketName, "designDocument", designDocument, "viewName", viewName));
    }

    public static CoreHttpPath pathForDesignDocument(String bucketName, String designDocument) {
        return CoreHttpPath.path("/{bucketName}/_design/{designDocument}", CbCollections.mapOf("bucketName", bucketName, "designDocument", designDocument));
    }

    public static CoreHttpPath pathForSearchIndex(String indexName) {
        return CoreHttpPath.path("/api/index/{indexName}", CbCollections.mapOf("indexName", indexName));
    }

    private static RequestTarget defaultManagerTarget(NodeIdentifier node) {
        return new RequestTarget(ServiceType.MANAGER, node, null);
    }

    private static CoreHttpRequest defaultManagerRequest(Core core, CoreHttpPath path, NodeIdentifier node) {
        RequestTarget target = ConsistencyUtil.defaultManagerTarget(node);
        return CoreHttpRequest.builder(CoreCommonOptions.DEFAULT, core.context(), HttpMethod.GET, path, target).build();
    }

    public static void waitUntilUserPresent(Core core, String domain, String name) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatus(core, ConsistencyUtil.pathForUser(domain, name), 200);
    }

    public static void waitUntilUserDropped(Core core, String domain, String name) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatus(core, ConsistencyUtil.pathForUser(domain, name), 404);
    }

    public static void waitUntilGroupPresent(Core core, String name) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatus(core, ConsistencyUtil.pathForGroup(name), 200);
    }

    public static void waitUntilGroupDropped(Core core, String name) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatus(core, ConsistencyUtil.pathForGroup(name), 404);
    }

    public static void waitUntilBucketPresent(Core core, String name) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatus(core, ConsistencyUtil.pathForBucket(name), 200);
    }

    public static void waitUntilBucketDropped(Core core, String name) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatus(core, ConsistencyUtil.pathForBucket(name), 404);
    }

    public static void waitUntilDesignDocumentPresent(Core core, String bucketName, String designDocument) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatusViews(core, ConsistencyUtil.pathForDesignDocument(bucketName, designDocument), 200, bucketName);
    }

    public static void waitUntilDesignDocumentDropped(Core core, String bucketName, String designDocument) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatusViews(core, ConsistencyUtil.pathForDesignDocument(bucketName, designDocument), 404, bucketName);
    }

    public static void waitUntilViewPresent(Core core, String bucketName, String designDocument, String viewName) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatusViews(core, ConsistencyUtil.pathForView(bucketName, designDocument, viewName), 200, bucketName);
    }

    public static void waitUntilViewDropped(Core core, String bucketName, String designDocument, String viewName) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatusViews(core, ConsistencyUtil.pathForView(bucketName, designDocument, viewName), 404, bucketName);
    }

    private static ScopesResponse convertScopesResponse(CoreHttpResponse response) {
        try {
            return mapper.reader().readValue(response.content(), ScopesResponse.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitUntilScopePresent(Core core, String bucketName, String scopeName) {
        CoreHttpPath path = ConsistencyUtil.pathForScopes(bucketName);
        ConsistencyUtil.waitUntilAllNodesMatchPredicate(core, (statusCode, response, err) -> {
            if (err != null) {
                throw err;
            }
            if (statusCode != 200) {
                return false;
            }
            return ConsistencyUtil.convertScopesResponse((CoreHttpResponse)response).scopes.stream().anyMatch(v -> v.name.equals(scopeName));
        }, "scope " + scopeName + " present", node -> ConsistencyUtil.defaultManagerRequest(core, path, node));
    }

    public static void waitUntilScopeDropped(Core core, String bucketName, String scopeName) {
        CoreHttpPath path = ConsistencyUtil.pathForScopes(bucketName);
        ConsistencyUtil.waitUntilAllNodesMatchPredicate(core, (statusCode, response, err) -> {
            if (err != null) {
                throw err;
            }
            if (statusCode != 200) {
                return false;
            }
            return ConsistencyUtil.convertScopesResponse((CoreHttpResponse)response).scopes.stream().noneMatch(v -> v.name.equals(scopeName));
        }, "scope " + scopeName + " dropped", node -> ConsistencyUtil.defaultManagerRequest(core, path, node));
    }

    public static void waitUntilCollectionPresent(Core core, String bucketName, String scopeName, String collectionName) {
        CoreHttpPath path = ConsistencyUtil.pathForScopes(bucketName);
        ConsistencyUtil.waitUntilAllNodesMatchPredicate(core, (statusCode, response, err) -> {
            if (err != null) {
                throw err;
            }
            if (statusCode != 200) {
                return false;
            }
            return ConsistencyUtil.convertScopesResponse((CoreHttpResponse)response).scopes.stream().anyMatch(v -> v.name.equals(scopeName) && v.collections.stream().anyMatch(coll -> coll.name.equals(collectionName)));
        }, "collection " + scopeName + "." + collectionName + " exists", node -> ConsistencyUtil.defaultManagerRequest(core, path, node));
    }

    public static void waitUntilCollectionDropped(Core core, String bucketName, String scopeName, String collectionName) {
        CoreHttpPath path = ConsistencyUtil.pathForScopes(bucketName);
        ConsistencyUtil.waitUntilAllNodesMatchPredicate(core, (statusCode, response, err) -> {
            if (err != null) {
                throw err;
            }
            if (statusCode != 200) {
                return false;
            }
            boolean anyMatch = ConsistencyUtil.convertScopesResponse((CoreHttpResponse)response).scopes.stream().anyMatch(v -> v.name.equals(scopeName) && v.collections.stream().anyMatch(coll -> coll.name.equals(collectionName)));
            return !anyMatch;
        }, "collection " + scopeName + "." + collectionName + " dropped", node -> ConsistencyUtil.defaultManagerRequest(core, path, node));
    }

    public static void waitUntilSearchIndexPresent(Core core, String indexName) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatusSearch(core, ConsistencyUtil.pathForSearchIndex(indexName), 200);
    }

    public static void waitUntilSearchIndexDropped(Core core, String indexName) {
        ConsistencyUtil.waitUntilAllNodesHaveSameStatusSearch(core, ConsistencyUtil.pathForSearchIndex(indexName), 404);
    }

    private static void waitUntilAllNodesHaveSameStatus(Core core, CoreHttpPath path, int requiredHttpStatus) {
        ConsistencyUtil.waitUntilAllNodesMatchPredicate(core, (statusCode, response, err) -> {
            if (err != null) {
                throw err;
            }
            return statusCode == requiredHttpStatus;
        }, "status == " + requiredHttpStatus, node -> ConsistencyUtil.defaultManagerRequest(core, path, node));
    }

    private static void waitUntilAllNodesHaveSameStatusSearch(Core core, CoreHttpPath path, int requiredHttpStatus) {
    }

    private static void waitUntilAllNodesHaveSameStatusViews(Core core, CoreHttpPath path, int requiredHttpStatus, String bucketName) {
        ConsistencyUtil.waitUntilAllNodesMatchPredicate(core, (statusCode, response, err) -> {
            if (err instanceof ViewServiceException) {
                if (err.getMessage().contains("\"error\":\"not_found\"")) {
                    return requiredHttpStatus == 404;
                }
                throw err;
            }
            if (err != null) {
                throw err;
            }
            return statusCode == requiredHttpStatus;
        }, String.format("view %s == %d", path.format(), requiredHttpStatus), node -> {
            RequestTarget target = new RequestTarget(ServiceType.VIEWS, (NodeIdentifier)node, bucketName);
            return CoreHttpRequest.builder(CoreCommonOptions.DEFAULT, core.context(), HttpMethod.GET, path, target).build();
        });
    }

    private static Set<NodeIdentifier> getConfig(Core core) {
        List nodes;
        HashSet<NodeIdentifier> ret = new HashSet<NodeIdentifier>();
        if (core.clusterConfig().globalConfig() != null) {
            nodes = core.clusterConfig().globalConfig().portInfos().stream().map(PortInfo::identifier).collect(Collectors.toList());
            logger.info("Adding nodes from global config: {}", nodes);
            ret.addAll(nodes);
        }
        if (core.clusterConfig().bucketConfigs() != null) {
            nodes = core.clusterConfig().bucketConfigs().entrySet().stream().flatMap(v -> ((BucketConfig)v.getValue()).nodes().stream().map(x -> x.identifier())).collect(Collectors.toList());
            logger.info("Adding nodes from bucket configs: {}", nodes);
            ret.addAll(nodes);
        }
        return ret;
    }

    private static Set<NodeIdentifier> waitForConfig(Core core) {
        logger.info("Waiting for config");
        long start = System.nanoTime();
        do {
            try {
                Set<NodeIdentifier> config = ConsistencyUtil.getConfig(core);
                if (!config.isEmpty()) {
                    return config;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (RuntimeException err) {
                logger.info("Ignoring error {} while getting config", (Object)err.toString());
            }
        } while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) <= 30L);
        throw new RuntimeException("Timeout waiting for config");
    }

    private static void waitUntilAllNodesMatchPredicate(Core core, TriFunction<Integer, CoreHttpResponse, RuntimeException, Boolean> onResult, String predicateDesc, Function<NodeIdentifier, CoreHttpRequest> createRequest) {
        Set<NodeIdentifier> portInfos = ConsistencyUtil.waitForConfig(core);
        long start = System.nanoTime();
        for (NodeIdentifier node : portInfos) {
            boolean done = false;
            while (!done) {
                String debug;
                block13: {
                    debug = String.format("%s:%d waiting for %s", node.address(), node.managerPort(), predicateDesc);
                    CoreHttpRequest request = createRequest.apply(node);
                    logger.debug("Querying {} running", (Object)debug);
                    try {
                        CoreHttpResponse response = request.exec(core).get();
                        done = onResult.apply(response.httpStatus(), response, null);
                        logger.debug("Querying {}: {} {} {}", new Object[]{debug, response.httpStatus(), response, done});
                    }
                    catch (ExecutionException e) {
                        logger.debug("Querying {}: {}", (Object)debug, (Object)e.toString());
                        if (e.getCause() instanceof RequestCanceledException) {
                            if (((RequestCanceledException)e.getCause()).reason() != CancellationReason.TARGET_NODE_REMOVED) break block13;
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException ex) {
                                throw new RuntimeException(ex);
                            }
                            ConsistencyUtil.waitUntilAllNodesMatchPredicate(core, onResult, predicateDesc, createRequest);
                            return;
                        }
                        if (e.getCause() instanceof HttpStatusCodeException) {
                            int statusCode = ((HttpStatusCodeException)e.getCause()).httpStatusCode();
                            logger.debug("Querying {}: {}", (Object)debug, (Object)statusCode);
                            done = onResult.apply(statusCode, null, null);
                        }
                        if (e.getCause() instanceof RuntimeException) {
                            done = onResult.apply(null, null, (RuntimeException)e.getCause());
                        }
                        throw new RuntimeException(e.getCause());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!done) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) <= 30L) continue;
                throw new RuntimeException(debug + " timeout");
            }
        }
    }

    static class ScopesResponse {
        public List<Scope> scopes;

        ScopesResponse() {
        }
    }

    static class Scope {
        public String name;
        public List<Collection> collections;

        Scope() {
        }
    }

    static class Collection {
        public String name;

        Collection() {
        }
    }
}

