/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.CompositeByteBuf;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.SubDocumentErrorContext;
import com.couchbase.client.core.error.subdoc.DocumentNotJsonException;
import com.couchbase.client.core.error.subdoc.DocumentTooDeepException;
import com.couchbase.client.core.error.subdoc.XattrInvalidKeyComboException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class SubdocGetRequest
extends BaseKeyValueRequest<SubdocGetResponse> {
    private static final byte SUBDOC_FLAG_XATTR_PATH = 4;
    private final byte flags;
    private final List<Command> commands;
    private final String origKey;

    public SubdocGetRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, byte flags, List<Command> commands, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.flags = flags;
        this.commands = commands;
        this.origKey = key;
        if (span != null) {
            span.attribute("db.operation", "lookup_in");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf extras = null;
        ByteBuf body = null;
        try {
            if (!ctx.vattrEnabled()) {
                for (Command c : this.commands) {
                    if (!c.xattr() || c.path.length() <= 0 || c.path.charAt(0) != '$' || c.path.startsWith("$document") || c.path.startsWith("$XTOC")) continue;
                    throw MemcacheProtocol.mapSubDocumentError(this, SubDocumentOpResponseStatus.XATTR_UNKNOWN_VATTR, c.path, c.originalIndex(), null);
                }
            }
            key = this.encodedKeyWithCollection(alloc, ctx);
            if (this.flags != 0) {
                extras = alloc.buffer(1).writeByte(this.flags);
            }
            if (this.commands.size() == 1) {
                body = this.commands.get(0).encode(alloc);
            } else {
                body = alloc.compositeBuffer(this.commands.size());
                for (Command command : this.commands) {
                    ByteBuf commandBuffer = command.encode(alloc);
                    try {
                        ((CompositeByteBuf)body).addComponent(commandBuffer);
                        body.writerIndex(body.writerIndex() + commandBuffer.readableBytes());
                    }
                    catch (Exception ex) {
                        ReferenceCountUtil.release(commandBuffer);
                        throw ex;
                    }
                }
            }
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.SUBDOC_MULTI_LOOKUP, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), extras == null ? MemcacheProtocol.noExtras() : extras, key, body);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(body);
            ReferenceCountUtil.release(extras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(body);
        ReferenceCountUtil.release(extras);
        return byteBuf;
    }

    @Override
    public SubdocGetResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        SubDocumentErrorContext e;
        SubDocumentField[] values;
        Optional<ByteBuf> maybeBody = MemcacheProtocol.body(response);
        ArrayList<CouchbaseException> errors = null;
        MemcacheProtocol.FlexibleExtras flexibleExtras = MemcacheProtocol.flexibleExtras(response);
        if (maybeBody.isPresent()) {
            ByteBuf body = maybeBody.get();
            values = new SubDocumentField[this.commands.size()];
            for (Command command : this.commands) {
                SubDocumentField op;
                short statusRaw = body.readShort();
                SubDocumentOpResponseStatus status = MemcacheProtocol.decodeSubDocumentStatus(statusRaw);
                Optional<CouchbaseException> error = Optional.empty();
                if (status != SubDocumentOpResponseStatus.SUCCESS) {
                    if (errors == null) {
                        errors = new ArrayList<CouchbaseException>();
                    }
                    CouchbaseException err = MemcacheProtocol.mapSubDocumentError(this, status, command.path, command.originalIndex(), flexibleExtras);
                    errors.add(err);
                    error = Optional.of(err);
                }
                int valueLength = body.readInt();
                byte[] value = new byte[valueLength];
                body.readBytes(value, 0, valueLength);
                values[((Command)command).originalIndex] = op = new SubDocumentField(status, error, value, command.path, command.type);
            }
        } else {
            values = new SubDocumentField[]{};
        }
        short rawStatus = MemcacheProtocol.status(response);
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        boolean isDeleted = rawStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status() || rawStatus == MemcacheProtocol.Status.SUBDOC_SUCCESS_DELETED_DOCUMENT.status();
        Optional<Object> error = Optional.empty();
        if (rawStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE.status() || rawStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status()) {
            if (this.commands.size() == 1 && this.commands.get(0).type == SubdocCommandType.EXISTS) {
                status = ResponseStatus.SUCCESS;
            } else if (this.commands.size() == 1 && errors != null && errors.size() == 1) {
                error = Optional.of((CouchbaseException)errors.get(0));
            } else {
                status = ResponseStatus.SUCCESS;
            }
        }
        if (rawStatus == MemcacheProtocol.Status.SUBDOC_DOC_NOT_JSON.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.DOC_NOT_JSON, flexibleExtras);
            error = Optional.of(new DocumentNotJsonException(e));
        } else if (rawStatus == MemcacheProtocol.Status.SUBDOC_DOC_TOO_DEEP.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.DOC_TOO_DEEP, flexibleExtras);
            error = Optional.of(new DocumentTooDeepException(e));
        } else if (rawStatus == MemcacheProtocol.Status.SUBDOC_XATTR_INVALID_KEY_COMBO.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.XATTR_INVALID_KEY_COMBO, flexibleExtras);
            error = Optional.of(new XattrInvalidKeyComboException(e));
        }
        return new SubdocGetResponse(status, error, values, MemcacheProtocol.cas(response), isDeleted, flexibleExtras);
    }

    private SubDocumentErrorContext createSubDocumentExceptionContext(SubDocumentOpResponseStatus status, @Nullable MemcacheProtocol.FlexibleExtras flexibleExtras) {
        return new SubDocumentErrorContext(KeyValueErrorContext.completedRequest(this, ResponseStatus.SUBDOC_FAILURE, flexibleExtras), 0, null, status);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public String name() {
        return "lookup_in";
    }

    public static class Command {
        private final SubdocCommandType type;
        private final String path;
        private final boolean xattr;
        private final int originalIndex;

        public Command(SubdocCommandType type, String path, boolean xattr, int originalIndex) {
            this.type = type;
            this.path = path;
            this.xattr = xattr;
            this.originalIndex = originalIndex;
        }

        public ByteBuf encode(ByteBufAllocator alloc) {
            byte[] path = this.path.getBytes(StandardCharsets.UTF_8);
            int pathLength = path.length;
            ByteBuf buffer = alloc.buffer(4 + pathLength);
            buffer.writeByte(this.type.opcode());
            if (this.xattr) {
                buffer.writeByte(4);
            } else {
                buffer.writeByte(0);
            }
            buffer.writeShort(pathLength);
            buffer.writeBytes(path);
            return buffer;
        }

        public int originalIndex() {
            return this.originalIndex;
        }

        public boolean xattr() {
            return this.xattr;
        }
    }
}

