/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class TimeoutConfig {
    public static final Duration DEFAULT_KV_TIMEOUT = Duration.ofMillis(2500L);
    public static final Duration DEFAULT_KV_DURABLE_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_KV_SCAN_TIMEOUT = Duration.ofSeconds(75L);
    public static final Duration DEFAULT_MANAGEMENT_TIMEOUT = Duration.ofSeconds(75L);
    public static final Duration DEFAULT_QUERY_TIMEOUT = Duration.ofSeconds(75L);
    public static final Duration DEFAULT_VIEW_TIMEOUT = Duration.ofSeconds(75L);
    public static final Duration DEFAULT_SEARCH_TIMEOUT = Duration.ofSeconds(75L);
    public static final Duration DEFAULT_ANALYTICS_TIMEOUT = Duration.ofSeconds(75L);
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_DISCONNECT_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_EVENTING_TIMEOUT = Duration.ofSeconds(75L);
    @Stability.Volatile
    public static final Duration DEFAULT_BACKUP_TIMEOUT = Duration.ofSeconds(75L);
    private final Duration kvTimeout;
    private final Duration kvDurableTimeout;
    private final Duration kvScanTimeout;
    private final Duration managementTimeout;
    private final Duration queryTimeout;
    private final Duration viewTimeout;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final Duration connectTimeout;
    private final Duration disconnectTimeout;
    private final Duration eventingTimeout;
    private final Duration backupTimeout;

    private TimeoutConfig(Builder builder) {
        this.kvTimeout = Optional.ofNullable(builder.kvTimeout).orElse(DEFAULT_KV_TIMEOUT);
        this.kvDurableTimeout = Optional.ofNullable(builder.kvDurableTimeout).orElse(DEFAULT_KV_DURABLE_TIMEOUT);
        this.kvScanTimeout = Optional.ofNullable(builder.kvScanTimeout).orElse(DEFAULT_KV_SCAN_TIMEOUT);
        this.managementTimeout = Optional.ofNullable(builder.managementTimeout).orElse(DEFAULT_MANAGEMENT_TIMEOUT);
        this.queryTimeout = Optional.ofNullable(builder.queryTimeout).orElse(DEFAULT_QUERY_TIMEOUT);
        this.viewTimeout = Optional.ofNullable(builder.viewTimeout).orElse(DEFAULT_VIEW_TIMEOUT);
        this.searchTimeout = Optional.ofNullable(builder.searchTimeout).orElse(DEFAULT_SEARCH_TIMEOUT);
        this.analyticsTimeout = Optional.ofNullable(builder.analyticsTimeout).orElse(DEFAULT_ANALYTICS_TIMEOUT);
        this.connectTimeout = Optional.ofNullable(builder.connectTimeout).orElse(DEFAULT_CONNECT_TIMEOUT);
        this.disconnectTimeout = Optional.ofNullable(builder.disconnectTimeout).orElse(DEFAULT_DISCONNECT_TIMEOUT);
        this.eventingTimeout = Optional.ofNullable(builder.eventingTimeout).orElse(DEFAULT_EVENTING_TIMEOUT);
        this.backupTimeout = Optional.ofNullable(builder.backupTimeout).orElse(DEFAULT_BACKUP_TIMEOUT);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TimeoutConfig create() {
        return TimeoutConfig.builder().build();
    }

    public static Builder kvTimeout(Duration kvTimeout) {
        return TimeoutConfig.builder().kvTimeout(kvTimeout);
    }

    @Stability.Volatile
    public static Builder kvDurableTimeout(Duration kvDurableTimeout) {
        return TimeoutConfig.builder().kvDurableTimeout(kvDurableTimeout);
    }

    @Stability.Volatile
    public static Builder kvScanTimeout(Duration kvScanTimeout) {
        return TimeoutConfig.builder().kvScanTimeout(kvScanTimeout);
    }

    public static Builder managementTimeout(Duration managementTimeout) {
        return TimeoutConfig.builder().managementTimeout(managementTimeout);
    }

    public static Builder queryTimeout(Duration queryTimeout) {
        return TimeoutConfig.builder().queryTimeout(queryTimeout);
    }

    public static Builder viewTimeout(Duration viewTimeout) {
        return TimeoutConfig.builder().viewTimeout(viewTimeout);
    }

    public static Builder searchTimeout(Duration searchTimeout) {
        return TimeoutConfig.builder().searchTimeout(searchTimeout);
    }

    public static Builder analyticsTimeout(Duration analyticsTimeout) {
        return TimeoutConfig.builder().analyticsTimeout(analyticsTimeout);
    }

    public static Builder connectTimeout(Duration connectTimeout) {
        return TimeoutConfig.builder().connectTimeout(connectTimeout);
    }

    public static Builder disconnectTimeout(Duration disconnectTimeout) {
        return TimeoutConfig.builder().disconnectTimeout(disconnectTimeout);
    }

    public static Builder eventingTimeout(Duration eventingTimeout) {
        return TimeoutConfig.builder().eventingTimeout(eventingTimeout);
    }

    @Stability.Volatile
    public static Builder backupTimeout(Duration backupTimeout) {
        return TimeoutConfig.builder().backupTimeout(backupTimeout);
    }

    public Duration kvTimeout() {
        return this.kvTimeout;
    }

    public Duration kvDurableTimeout() {
        return this.kvDurableTimeout;
    }

    @Stability.Volatile
    public Duration kvScanTimeout() {
        return this.kvScanTimeout;
    }

    public Duration managementTimeout() {
        return this.managementTimeout;
    }

    public Duration queryTimeout() {
        return this.queryTimeout;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public Duration disconnectTimeout() {
        return this.disconnectTimeout;
    }

    public Duration viewTimeout() {
        return this.viewTimeout;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public Duration eventingTimeout() {
        return this.eventingTimeout;
    }

    @Stability.Volatile
    public Duration backupTimeout() {
        return this.backupTimeout;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("kvMs", this.kvTimeout.toMillis());
        export.put("kvDurableMs", this.kvDurableTimeout.toMillis());
        export.put("kvScanMs", this.kvScanTimeout.toMillis());
        export.put("managementMs", this.managementTimeout.toMillis());
        export.put("queryMs", this.queryTimeout.toMillis());
        export.put("viewMs", this.viewTimeout.toMillis());
        export.put("searchMs", this.searchTimeout.toMillis());
        export.put("analyticsMs", this.analyticsTimeout.toMillis());
        export.put("connectMs", this.connectTimeout.toMillis());
        export.put("disconnectMs", this.disconnectTimeout.toMillis());
        export.put("eventingMs", this.eventingTimeout.toMillis());
        export.put("backupMs", this.backupTimeout.toMillis());
        return export;
    }

    public static class Builder {
        private Duration kvTimeout = null;
        private Duration kvDurableTimeout = null;
        private Duration kvScanTimeout = null;
        private Duration managementTimeout = null;
        private Duration queryTimeout = null;
        private Duration viewTimeout = null;
        private Duration searchTimeout = null;
        private Duration analyticsTimeout = null;
        private Duration connectTimeout = null;
        private Duration disconnectTimeout = null;
        private Duration eventingTimeout = null;
        private Duration backupTimeout = null;

        public TimeoutConfig build() {
            return new TimeoutConfig(this);
        }

        public Builder kvTimeout(Duration kvTimeout) {
            this.kvTimeout = kvTimeout;
            return this;
        }

        public Builder kvDurableTimeout(Duration kvDurableTimeout) {
            this.kvDurableTimeout = kvDurableTimeout;
            return this;
        }

        public Builder kvScanTimeout(Duration kvScanTimeout) {
            this.kvScanTimeout = kvScanTimeout;
            return this;
        }

        public Builder managementTimeout(Duration managementTimeout) {
            this.managementTimeout = managementTimeout;
            return this;
        }

        public Builder queryTimeout(Duration queryTimeout) {
            this.queryTimeout = queryTimeout;
            return this;
        }

        public Builder viewTimeout(Duration viewTimeout) {
            this.viewTimeout = viewTimeout;
            return this;
        }

        public Builder searchTimeout(Duration searchTimeout) {
            this.searchTimeout = searchTimeout;
            return this;
        }

        public Builder analyticsTimeout(Duration analyticsTimeout) {
            this.analyticsTimeout = analyticsTimeout;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder disconnectTimeout(Duration disconnectTimeout) {
            this.disconnectTimeout = disconnectTimeout;
            return this;
        }

        public Builder eventingTimeout(Duration eventingTimeout) {
            this.eventingTimeout = eventingTimeout;
            return this;
        }

        @Stability.Volatile
        public Builder backupTimeout(Duration backupTimeout) {
            this.backupTimeout = backupTimeout;
            return this;
        }
    }
}

