/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.diagnostics;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.diagnostics.EndpointPingReport;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.PingState;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.error.TimeoutException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.kv.KvPingRequest;
import com.couchbase.client.core.msg.kv.KvPingResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public class HealthPinger {
    @Stability.Internal
    public static Mono<PingResult> ping(Core core, Optional<Duration> timeout, RetryStrategy retryStrategy, Set<ServiceType> serviceTypes, Optional<String> reportId, Optional<String> bucketName) {
        return Mono.defer(() -> {
            Set<RequestTarget> targets = HealthPinger.extractPingTargets(core.clusterConfig(), bucketName);
            if (!CbCollections.isNullOrEmpty(serviceTypes)) {
                targets = targets.stream().filter(t -> serviceTypes.contains((Object)t.serviceType())).collect(Collectors.toSet());
            }
            return HealthPinger.pingTargets(core, targets, timeout, retryStrategy).collectList().map(reports -> new PingResult(reports.stream().collect(Collectors.groupingBy(EndpointPingReport::type)), core.context().environment().userAgent().formattedShort(), reportId.orElse(UUID.randomUUID().toString())));
        });
    }

    @Stability.Internal
    static Set<RequestTarget> extractPingTargets(ClusterConfig clusterConfig, Optional<String> bucketName) {
        HashSet<RequestTarget> targets;
        block10: {
            block9: {
                targets = new HashSet<RequestTarget>();
                if (bucketName.isPresent()) break block9;
                if (clusterConfig.globalConfig() != null) {
                    for (PortInfo portInfo : clusterConfig.globalConfig().portInfos()) {
                        for (ServiceType serviceType : portInfo.ports().keySet()) {
                            if (serviceType == ServiceType.KV || serviceType == ServiceType.VIEWS) continue;
                            targets.add(new RequestTarget(serviceType, portInfo.identifier(), null));
                        }
                    }
                }
                for (Map.Entry entry : clusterConfig.bucketConfigs().entrySet()) {
                    for (NodeInfo nodeInfo : ((BucketConfig)entry.getValue()).nodes()) {
                        for (ServiceType serviceType : nodeInfo.services().keySet()) {
                            if (serviceType == ServiceType.KV || serviceType == ServiceType.VIEWS) continue;
                            targets.add(new RequestTarget(serviceType, nodeInfo.identifier(), null));
                        }
                    }
                }
                break block10;
            }
            BucketConfig bucketConfig = clusterConfig.bucketConfig(bucketName.get());
            if (bucketConfig == null) break block10;
            for (NodeInfo nodeInfo : bucketConfig.nodes()) {
                for (ServiceType serviceType : nodeInfo.services().keySet()) {
                    if (serviceType != ServiceType.VIEWS && serviceType != ServiceType.KV) {
                        targets.add(new RequestTarget(serviceType, nodeInfo.identifier(), null));
                        continue;
                    }
                    targets.add(new RequestTarget(serviceType, nodeInfo.identifier(), bucketName.get()));
                }
            }
        }
        return targets;
    }

    private static Flux<EndpointPingReport> pingTargets(Core core, Set<RequestTarget> targets, Optional<Duration> timeout, RetryStrategy retryStrategy) {
        CoreCommonOptions options = CoreCommonOptions.of(timeout.orElse(null), retryStrategy, null);
        return Flux.fromIterable(targets).flatMap(target -> HealthPinger.pingTarget(core, target, options));
    }

    private static Mono<EndpointPingReport> pingTarget(Core core, RequestTarget target, CoreCommonOptions options) {
        switch (target.serviceType()) {
            case QUERY: {
                return HealthPinger.pingHttpEndpoint(core, target, options, "/admin/ping");
            }
            case KV: {
                return HealthPinger.pingKv(core, target, options);
            }
            case VIEWS: {
                return HealthPinger.pingHttpEndpoint(core, target, options, "/");
            }
            case SEARCH: {
                return HealthPinger.pingHttpEndpoint(core, target, options, "/api/ping");
            }
            case MANAGER: 
            case EVENTING: 
            case BACKUP: {
                return Mono.empty();
            }
            case ANALYTICS: {
                return HealthPinger.pingHttpEndpoint(core, target, options, "/admin/ping");
            }
        }
        return Mono.error((Throwable)new IllegalStateException("Unknown service to ping, this is a bug!"));
    }

    private static EndpointPingReport assembleSuccessReport(RequestContext context, String channelId, Optional<String> namespace) {
        String dispatchTo = null;
        String dispatchFrom = null;
        if (context.lastDispatchedTo() != null) {
            dispatchTo = context.lastDispatchedTo().toString();
        }
        if (context.lastDispatchedFrom() != null) {
            dispatchFrom = context.lastDispatchedFrom().toString();
        }
        return new EndpointPingReport(context.request().serviceType(), "0x" + channelId, dispatchFrom, dispatchTo, PingState.OK, namespace, Duration.ofNanos(context.logicalRequestLatency()), Optional.empty());
    }

    private static EndpointPingReport assembleFailureReport(Throwable throwable, RequestContext context, Optional<String> namespace) {
        String dispatchTo = null;
        String dispatchFrom = null;
        if (context.lastDispatchedTo() != null) {
            dispatchTo = context.lastDispatchedTo().toString();
        }
        if (context.lastDispatchedFrom() != null) {
            dispatchFrom = context.lastDispatchedFrom().toString();
        }
        PingState state = throwable instanceof TimeoutException ? PingState.TIMEOUT : PingState.ERROR;
        return new EndpointPingReport(context.request().serviceType(), null, dispatchFrom, dispatchTo, state, namespace, state == PingState.TIMEOUT ? context.request().timeout() : Duration.ofNanos(context.logicalRequestLatency()), Optional.empty());
    }

    private static Mono<EndpointPingReport> pingKv(Core core, RequestTarget target, CoreCommonOptions options) {
        return Mono.defer(() -> {
            Duration timeout = options.timeout().orElse(core.context().environment().timeoutConfig().kvTimeout());
            CollectionIdentifier collectionIdentifier = CollectionIdentifier.fromDefault(target.bucketName());
            KvPingRequest request = new KvPingRequest(timeout, core.context(), (RetryStrategy)options.retryStrategy().orElse(null), collectionIdentifier, target.nodeIdentifier());
            core.send(request);
            return Reactor.wrap(request, request.response(), true).map(response -> {
                request.context().logicallyComplete();
                return HealthPinger.assembleSuccessReport(request.context(), ((KvPingResponse)response).channelId(), Optional.ofNullable(target.bucketName()));
            }).onErrorResume(throwable -> {
                request.context().logicallyComplete((Throwable)throwable);
                return Mono.just((Object)HealthPinger.assembleFailureReport(throwable, request.context(), Optional.ofNullable(target.bucketName())));
            });
        });
    }

    private static Mono<EndpointPingReport> pingHttpEndpoint(Core core, RequestTarget target, CoreCommonOptions options, String path) {
        return Mono.defer(() -> {
            CoreHttpRequest request = core.httpClient(target).get(CoreHttpPath.path(path), options).build();
            core.send(request);
            return Reactor.wrap(request, request.response(), true).map(response -> {
                request.context().logicallyComplete();
                return HealthPinger.assembleSuccessReport(request.context(), response.channelId(), Optional.empty());
            }).onErrorResume(throwable -> {
                request.context().logicallyComplete((Throwable)throwable);
                return Mono.just((Object)HealthPinger.assembleFailureReport(throwable, request.context(), Optional.empty()));
            });
        });
    }
}

