/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.events.transaction.TransactionEvent;
import com.couchbase.client.core.transaction.cleanup.ClientRecordDetails;
import com.couchbase.client.core.transaction.cleanup.CoreTransactionsCleanup;
import java.time.Duration;
import java.util.Objects;

@Stability.Uncommitted
public class TransactionCleanupStartRunEvent
extends TransactionEvent {
    private final String bucketName;
    private final String scopeName;
    private final String collectionName;
    private final String clientId;
    private final ClientRecordDetails clientDetails;
    private final Duration cleanupWindow;
    private final int atrsToCheckInNextWindow;
    private final int totalAtrs;
    private final Duration checkAtrEvery;

    @Stability.Volatile
    public TransactionCleanupStartRunEvent(String bucketName, String scopeName, String collectionName, String clientUuid, ClientRecordDetails clientDetails, Duration cleanupWindow, int atrsToCheckInNextWindow, int totalAtrs, Duration checkAtrEvery) {
        super(Event.Severity.DEBUG, CoreTransactionsCleanup.CATEGORY_STATS);
        this.bucketName = Objects.requireNonNull(bucketName);
        this.scopeName = Objects.requireNonNull(scopeName);
        this.collectionName = Objects.requireNonNull(collectionName);
        this.clientId = Objects.requireNonNull(clientUuid);
        this.clientDetails = Objects.requireNonNull(clientDetails);
        this.cleanupWindow = Objects.requireNonNull(cleanupWindow);
        this.atrsToCheckInNextWindow = atrsToCheckInNextWindow;
        this.totalAtrs = totalAtrs;
        this.checkAtrEvery = Objects.requireNonNull(checkAtrEvery);
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.bucketName);
        sb.append('.');
        sb.append(this.scopeName);
        sb.append('.');
        sb.append(this.collectionName);
        sb.append("/clientId=");
        sb.append(this.clientId.substring(0, 5));
        sb.append(",index=");
        sb.append(this.clientDetails.indexOfThisClient());
        sb.append(",numClients=");
        sb.append(this.clientDetails.numActiveClients());
        sb.append(",ATRs={checking=");
        sb.append(this.atrsToCheckInNextWindow);
        sb.append(",total=");
        sb.append(this.totalAtrs);
        sb.append("},runLength=");
        sb.append(this.cleanupWindow.toMillis());
        sb.append("millis");
        return sb.toString();
    }
}

