/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.core;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;

public class WaitUntilReadyCompletedEvent
extends AbstractEvent {
    private final Reason reason;

    public WaitUntilReadyCompletedEvent(Context context, Reason reason) {
        super(reason.severity, Event.Category.CORE, Duration.ZERO, context);
        this.reason = reason;
    }

    @Override
    public String description() {
        if (this.reason == Reason.SUCCESS) {
            return "WaitUntilReady completed successfully.";
        }
        if (this.reason == Reason.CLUSTER_LEVEL_NOT_SUPPORTED) {
            return "Cluster-Level WaitUntilReady completed without action, because it was run against a Couchbase Server version which does not support it (only supported with 6.5 and later). Please execute WaitUntilReady at the bucket level and open at least one bucket to perform your operations.";
        }
        return "WaitUntilReady completed.";
    }

    public static enum Reason {
        CLUSTER_LEVEL_NOT_SUPPORTED(Event.Severity.INFO),
        SUCCESS(Event.Severity.DEBUG);

        private final Event.Severity severity;

        private Reason(Event.Severity severity) {
            this.severity = severity;
        }
    }
}

