/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.ui.resultset;

import com.dbeaver.ee.chart.model.ChartMeasurement;
import com.dbeaver.ee.chart.model.ChartType;
import com.dbeaver.ee.chart.model.ChartValue;
import com.dbeaver.ee.chart.ui.resultset.ResultsChartComposite;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.themes.ITheme;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PieLabelLinkStyle;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.TableOrder;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.AWTUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.charts.BaseChartDrawingSupplier;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

public class ResultsChartPresentation
extends AbstractPresentation {
    private static final Log log = Log.getLog(ResultsChartPresentation.class);
    private static ChartTheme CLASSIC_THEME = StandardChartTheme.createJFreeTheme();
    private static ChartTheme DARK_THEME = StandardChartTheme.createDarknessTheme();
    protected ResultsChartComposite canvas;
    protected JFreeChart chart;
    private List<ChartMeasurement> measurements = new ArrayList<ChartMeasurement>();
    private static final Map<String, List<ChartMeasurement>> measurementCache = new HashMap<String, List<ChartMeasurement>>();

    public List<ChartMeasurement> getMeasurements() {
        ArrayList<ChartMeasurement> mCopy = new ArrayList<ChartMeasurement>(this.measurements.size());
        for (ChartMeasurement m : this.measurements) {
            mCopy.add(new ChartMeasurement(m));
        }
        return mCopy;
    }

    public void setMeasurements(List<ChartMeasurement> measurements) {
        this.measurements.clear();
        this.measurements.addAll(measurements);
        this.saveMeasurementsInfo();
    }

    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        this.canvas = new ResultsChartComposite(this, parent, 0);
        this.canvas.setLayoutData(new GridData(1808));
        this.canvas.setFont(UIUtils.getMonospaceFont());
        this.canvas.addDisposeListener(e -> {});
        this.registerContextMenu();
        this.trackPresentationControl();
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)controller.getSite(), (Control)this.canvas);
        this.applyCurrentThemeSettings();
    }

    protected void applyThemeSettings(ITheme currentTheme) {
        boolean isDark = TextEditorUtils.isDarkThemeEnabled();
        ChartTheme newTheme = isDark || UIStyles.isDarkHighContrastTheme() ? DARK_THEME : CLASSIC_THEME;
        if (ChartFactory.getChartTheme() != newTheme) {
            ChartFactory.setChartTheme((ChartTheme)newTheme);
            if (this.canvas.getChart() != null) {
                this.refreshData(false, false, true);
            }
        }
    }

    public Composite getControl() {
        return this.canvas;
    }

    public void formatData(boolean refreshData) {
    }

    public void clearMetaData() {
    }

    public void updateValueView() {
    }

    public void changeMode(boolean recordMode) {
    }

    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        super.scrollToRow(position);
    }

    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.controller.getModel().getDocumentAttribute();
    }

    @NotNull
    public Map<Transfer, Object> copySelection(ResultSetCopySettings settings) {
        return Collections.emptyMap();
    }

    public ISelection getSelection() {
        return new StructuredSelection();
    }

    public void setSelection(ISelection selection) {
    }

    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        if (this.canvas == null || this.canvas.isDisposed()) {
            return;
        }
        if (this.measurements.isEmpty() || !keepState) {
            this.loadMeasurements();
        }
        this.canvas.setRedraw(false);
        try {
            ChartMeasurement measurement = this.measurements.isEmpty() ? null : this.measurements.get(0);
            switch (measurement != null ? measurement.getChartType() : ChartType.BAR) {
                case BAR: {
                    this.chart = ChartFactory.createBarChart((String)(measurement == null ? "Can not generate chart from data" : null), (String)(measurement == null ? "N/A" : measurement.getTitleX()), (String)(measurement == null ? "N/A" : measurement.getTitleY()), (CategoryDataset)this.createCategoryDataSet());
                    break;
                }
                case LINE: {
                    this.chart = ChartFactory.createLineChart(null, (String)measurement.getTitleX(), (String)measurement.getTitleY(), (CategoryDataset)this.createCategoryDataSet());
                    break;
                }
                case PIE: {
                    this.chart = ChartFactory.createPieChart(null, (PieDataset)new CategoryToPieDataset(this.createCategoryDataSet(), TableOrder.BY_ROW, 0));
                }
            }
            this.chart.removeLegend();
            Plot plot = this.chart.getPlot();
            plot.setBackgroundPaint((Paint)AWTUtils.makeAWTColor((Color)UIStyles.getDefaultTextBackground()));
            plot.setDrawingSupplier((DrawingSupplier)new BaseChartDrawingSupplier());
            if (plot instanceof PiePlot) {
                PiePlot piePlot = (PiePlot)plot;
                piePlot.setShadowGenerator(null);
                piePlot.setOutlineVisible(false);
                piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} - {1} ({2}) "));
                piePlot.setLabelLinkStyle(PieLabelLinkStyle.STANDARD);
            }
            if (plot instanceof CategoryPlot) {
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                categoryPlot.setShadowGenerator(null);
                ValueAxis rangeAxis = categoryPlot.getRangeAxis();
                rangeAxis.setUpperMargin(0.3);
                rangeAxis.setLabelInsets(new RectangleInsets(3.0, 3.0, 3.0, 10.0));
                CategoryAxis domainAxis = categoryPlot.getDomainAxis();
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
                domainAxis.setLowerMargin(0.01);
                domainAxis.setUpperMargin(0.01);
                Font font = domainAxis.getTickLabelFont();
                Font fixedFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                domainAxis.setTickLabelFont(fixedFont);
                categoryPlot.getRangeAxis().setTickLabelFont(fixedFont);
                CategoryItemRenderer renderer = categoryPlot.getRenderer();
                if (renderer instanceof BarRenderer) {
                    BarRenderer barRenderer = (BarRenderer)renderer;
                    barRenderer.setDrawBarOutline(false);
                    barRenderer.setBarPainter((BarPainter)new StandardBarPainter());
                }
                renderer.setSeriesItemLabelGenerator(0, (CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                renderer.setSeriesPositiveItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -1.5707963267948966));
                renderer.setSeriesItemLabelsVisible(1, true);
                renderer.setSeriesItemLabelFont(0, fixedFont);
                renderer.setBaseItemLabelsVisible(true);
                renderer.setBaseSeriesVisible(true);
            }
            this.canvas.setChart(this.chart);
            this.canvas.setDomainZoomable(false);
            this.canvas.setRangeZoomable(false);
        }
        finally {
            this.canvas.setRedraw(true);
        }
        if (!keepState && this.measurements.isEmpty()) {
            this.canvas.showChartConfigDialog();
        }
    }

    private void loadMeasurements() {
        this.measurements.clear();
        if (this.loadMeasurementsInfo()) {
            return;
        }
        ChartMeasurement measurement = this.collectChartInfo((DBRProgressMonitor)new VoidProgressMonitor());
        if (measurement != null) {
            this.measurements.add(measurement);
        }
        this.saveMeasurementsInfo();
    }

    private ChartMeasurement collectChartInfo(DBRProgressMonitor monitor) {
        DBDAttributeBinding titleAttr2;
        ResultSetModel model = this.getController().getModel();
        List allAttrs = model.getVisibleAttributes();
        ArrayList<DBDAttributeBinding> titleAttrs = new ArrayList<DBDAttributeBinding>();
        ArrayList<DBDAttributeBinding> valueAttrs = new ArrayList<DBDAttributeBinding>();
        DBDAttributeBinding autoKeyAttribute = null;
        for (DBDAttributeBinding attr : allAttrs) {
            DBSEntityAttribute entityAttribute = attr.getEntityAttribute();
            if (entityAttribute != null && entityAttribute.isAutoGenerated()) {
                autoKeyAttribute = attr;
                continue;
            }
            switch (attr.getDataKind()) {
                case NUMERIC: {
                    try {
                        if (entityAttribute != null && !CommonUtils.isEmpty((Collection)DBUtils.getAttributeReferrers((DBRProgressMonitor)monitor, (DBSEntityAttribute)entityAttribute, (boolean)true))) {
                            titleAttrs.add(attr);
                            break;
                        }
                    }
                    catch (DBException e) {
                        log.debug((Object)"Error checking attribute references", (Throwable)e);
                    }
                    valueAttrs.add(attr);
                    break;
                }
                case STRING: {
                    valueAttrs.add(attr);
                    titleAttrs.add(attr);
                    break;
                }
                case DATETIME: 
                case OBJECT: 
                case ROWID: {
                    titleAttrs.add(attr);
                }
            }
        }
        if (titleAttrs.isEmpty() && valueAttrs.size() > 1) {
            titleAttrs.add((DBDAttributeBinding)valueAttrs.remove(0));
        }
        if (valueAttrs.isEmpty() && autoKeyAttribute != null) {
            valueAttrs.add(autoKeyAttribute);
        }
        if (titleAttrs.isEmpty() || valueAttrs.isEmpty()) {
            return null;
        }
        DBDAttributeBinding uniqueTitleAttr = null;
        DBDAttributeBinding indexedTitleAttr = null;
        if (titleAttrs.size() > 1) {
            for (DBDAttributeBinding titleAttr2 : titleAttrs) {
                DBSEntityAttribute entityAttribute = titleAttr2.getEntityAttribute();
                if (entityAttribute == null) continue;
                try {
                    DBSTableIndex index = DBUtils.findAttributeIndex((DBRProgressMonitor)monitor, (DBSEntityAttribute)entityAttribute);
                    if (index != null) {
                        if (index.isUnique()) {
                            uniqueTitleAttr = titleAttr2;
                            continue;
                        }
                        indexedTitleAttr = titleAttr2;
                        continue;
                    }
                    DBSEntityConstraint constraint = DBUtils.getConstraint((DBRProgressMonitor)monitor, (DBSEntity)entityAttribute.getParentObject(), (DBSAttributeBase)entityAttribute);
                    if (constraint == null) continue;
                    if (constraint.getConstraintType().isUnique()) {
                        uniqueTitleAttr = titleAttr2;
                        continue;
                    }
                    indexedTitleAttr = titleAttr2;
                }
                catch (DBException e) {
                    log.debug((Object)e);
                }
            }
        }
        titleAttr2 = uniqueTitleAttr != null ? uniqueTitleAttr : (indexedTitleAttr != null ? indexedTitleAttr : (DBDAttributeBinding)titleAttrs.get(0));
        DBDAttributeBinding valueAttr = (DBDAttributeBinding)valueAttrs.get(0);
        ChartMeasurement measurement = new ChartMeasurement();
        measurement.setTitle(this.getController().getDataContainer().getName());
        measurement.setTitleX(titleAttr2.getName());
        measurement.setTitleY(valueAttr.getName());
        measurement.setGroupAttributes(Collections.singletonList(titleAttr2));
        measurement.setValueAttribute(valueAttr);
        measurement.loadDataFromModel(monitor, this.getController());
        return measurement;
    }

    public ChartMeasurement createEmptyMeasurement() {
        ChartMeasurement measurement = new ChartMeasurement();
        measurement.setTitle(this.getController().getDataContainer().getName());
        return measurement;
    }

    private CategoryDataset createCategoryDataSet() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (ChartMeasurement measurement : this.measurements) {
            List valueList;
            LinkedHashMap<Comparable, List> valueMap = new LinkedHashMap<Comparable, List>();
            for (ChartValue chartValue : measurement.getValues()) {
                valueList = valueMap.computeIfAbsent((Comparable)((Object)chartValue.getTitle()), k -> new ArrayList());
                valueList.add(chartValue.getValue());
                if (measurement.getMaxSampleCount() > 0 && valueMap.size() >= measurement.getMaxSampleCount()) break;
            }
            for (Map.Entry entry : valueMap.entrySet()) {
                valueList = (List)entry.getValue();
                Number value = valueList.size() > 1 ? (Number)measurement.getSampleFunction().execute(valueList) : (Number)((Number)valueList.get(0));
                dataset.addValue(value, (Comparable)((Object)measurement.getTitleY()), (Comparable)entry.getKey());
            }
        }
        return dataset;
    }

    private String getUniqueContainerName() {
        return DBUtils.getObjectFullId((DBSObject)this.getController().getDataContainer());
    }

    private boolean loadMeasurementsInfo() {
        String containerName = this.getUniqueContainerName();
        List<ChartMeasurement> mCached = measurementCache.get(containerName);
        if (mCached == null) {
            return false;
        }
        this.measurements.clear();
        for (ChartMeasurement m : mCached) {
            ChartMeasurement mRestored = new ChartMeasurement(m);
            mRestored.loadDataFromModel((DBRProgressMonitor)new VoidProgressMonitor(), this.getController());
            this.measurements.add(mRestored);
        }
        return true;
    }

    private void saveMeasurementsInfo() {
        String containerName = this.getUniqueContainerName();
        List<ChartMeasurement> measurements = this.getMeasurements();
        if (!measurements.isEmpty()) {
            measurementCache.put(containerName, measurements);
        }
    }
}

