/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.model;

import com.dbeaver.ee.chart.model.ChartSampleFunction;
import com.dbeaver.ee.chart.model.ChartType;
import com.dbeaver.ee.chart.model.ChartValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class ChartMeasurement {
    public static final int DEFAULT_MAX_SAMPLE_COUNT = 50;
    private static final Log log = Log.getLog(ChartMeasurement.class);
    private String title;
    private String titleX;
    private String titleY;
    private boolean useDictionaries;
    private List<DBDAttributeBinding> groupAttributes;
    private DBDAttributeBinding valueAttribute;
    private List<ChartValue> values = new ArrayList<ChartValue>();
    private int maxRowCount = 0;
    private int maxSampleCount = 50;
    private ChartSampleFunction sampleFunction = ChartSampleFunction.SUM;
    private ChartType chartType = ChartType.BAR;
    private String valueRegexString = null;
    private Pattern valueRegex = null;

    public ChartMeasurement() {
        this.groupAttributes = new ArrayList<DBDAttributeBinding>();
        this.valueAttribute = null;
    }

    public ChartMeasurement(ChartMeasurement measurement) {
        this.title = measurement.title;
        this.titleX = measurement.titleX;
        this.titleY = measurement.titleY;
        this.useDictionaries = measurement.useDictionaries;
        this.maxRowCount = measurement.maxRowCount;
        this.maxSampleCount = measurement.maxSampleCount;
        this.sampleFunction = measurement.sampleFunction;
        this.chartType = measurement.chartType;
        this.groupAttributes = new ArrayList<DBDAttributeBinding>(measurement.groupAttributes);
        this.valueAttribute = measurement.valueAttribute;
        this.valueRegex = measurement.valueRegex;
        this.valueRegexString = measurement.valueRegexString;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleX() {
        return this.titleX;
    }

    public void setTitleX(String titleX) {
        this.titleX = titleX;
    }

    public String getTitleY() {
        return this.titleY;
    }

    public void setTitleY(String titleY) {
        this.titleY = titleY;
    }

    public boolean isUseDictionaries() {
        return this.useDictionaries;
    }

    public void setUseDictionaries(boolean useDictionaries) {
        this.useDictionaries = useDictionaries;
    }

    public List<DBDAttributeBinding> getGroupAttributes() {
        return this.groupAttributes;
    }

    public void setGroupAttributes(List<DBDAttributeBinding> groupAttributes) {
        this.groupAttributes = groupAttributes;
    }

    public DBDAttributeBinding getValueAttribute() {
        return this.valueAttribute;
    }

    public void setValueAttribute(DBDAttributeBinding valueAttribute) {
        this.valueAttribute = valueAttribute;
    }

    public List<ChartValue> getValues() {
        return this.values;
    }

    public void setValues(List<ChartValue> values) {
        this.values = values;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public void setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
    }

    public int getMaxSampleCount() {
        return this.maxSampleCount;
    }

    public void setMaxSampleCount(int maxSampleCount) {
        this.maxSampleCount = maxSampleCount;
    }

    public ChartSampleFunction getSampleFunction() {
        return this.sampleFunction;
    }

    public void setSampleFunction(ChartSampleFunction sampleFunction) {
        this.sampleFunction = sampleFunction;
    }

    @NotNull
    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(@NotNull ChartType chartType) {
        this.chartType = chartType;
    }

    public void setValueRegex(String patternString) {
        this.valueRegex = patternString == null ? null : Pattern.compile(patternString);
        this.valueRegexString = patternString;
    }

    public String getValueRegex() {
        return this.valueRegexString;
    }

    public void loadDataFromModel(DBRProgressMonitor monitor, IResultSetController controller) {
        ResultSetModel model = controller.getModel();
        int rowCount = model.getRowCount();
        this.values = new ArrayList<ChartValue>();
        IdentityHashMap<DBDAttributeBinding, AttrDictInfo> enumMap = new IdentityHashMap<DBDAttributeBinding, AttrDictInfo>();
        if (this.useDictionaries) {
            for (DBDAttributeBinding dBDAttributeBinding : this.groupAttributes) {
                try {
                    List attrRefs;
                    DBSEntityConstraint referencedConstraint;
                    DBSEntityReferrer enumerableConstraint = DBStructUtils.getEnumerableConstraint((DBRProgressMonitor)monitor, (DBDAttributeBinding)dBDAttributeBinding);
                    if (enumerableConstraint == null || (referencedConstraint = ((DBSEntityAssociation)enumerableConstraint).getReferencedConstraint()) == null || CommonUtils.isEmpty((Collection)(attrRefs = enumerableConstraint.getAttributeReferences(monitor)))) continue;
                    AttrDictInfo dictInfo = new AttrDictInfo();
                    dictInfo.dictionary = (DBSDictionary)referencedConstraint.getParentObject();
                    DBSEntityAttribute refAttr = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)((DBSEntityAssociation)enumerableConstraint), (DBSEntityAttribute)dBDAttributeBinding.getEntityAttribute(), (boolean)false);
                    if (refAttr != null) {
                        dictInfo.refAttr = refAttr;
                        enumMap.put(dBDAttributeBinding, dictInfo);
                        continue;
                    }
                    log.debug((Object)("Can't get ref attribute for title attribute " + dBDAttributeBinding.getFullyQualifiedName(DBPEvaluationContext.UI)));
                }
                catch (DBException e) {
                    log.debug((Object)"Error reading reference columns", (Throwable)e);
                }
            }
            if (!enumMap.isEmpty()) {
                block7: for (Map.Entry entry : enumMap.entrySet()) {
                    int i = 0;
                    while (i < rowCount) {
                        ResultSetRow row = model.getRow(i);
                        Iterator keyValue = model.getCellValue((DBDAttributeBinding)entry.getKey(), row);
                        Set<Object> keyValues = ((AttrDictInfo)entry.getValue()).keyValues;
                        keyValues.add(keyValue);
                        if (this.maxRowCount > 0 && keyValues.size() >= this.maxRowCount) continue block7;
                        ++i;
                    }
                }
                for (Map.Entry entry : enumMap.entrySet()) {
                    if (((AttrDictInfo)entry.getValue()).keyValues.isEmpty()) continue;
                    try {
                        List keyEnumeration = ((AttrDictInfo)entry.getValue()).dictionary.getDictionaryValues(monitor, ((AttrDictInfo)entry.getValue()).refAttr, new ArrayList<Object>(((AttrDictInfo)entry.getValue()).keyValues), null, true, false);
                        for (DBDLabelValuePair labelPair : keyEnumeration) {
                            ((AttrDictInfo)entry.getValue()).keyLabels.put(CommonUtils.toString((Object)labelPair.getValue()), labelPair.getLabel());
                        }
                    }
                    catch (DBException e) {
                        log.debug((Object)"Error reading dictionary labels", (Throwable)e);
                    }
                }
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int i = 0;
        while (i < rowCount) {
            ResultSetRow row = model.getRow(i);
            StringBuilder titleStr = new StringBuilder();
            for (DBDAttributeBinding titleAttr : this.groupAttributes) {
                String title;
                Object rowTitle = model.getCellValue(titleAttr, row);
                AttrDictInfo dictInfo = (AttrDictInfo)enumMap.get(titleAttr);
                if (dictInfo != null) {
                    title = dictInfo.keyLabels.get(CommonUtils.toString((Object)rowTitle));
                    if (title != null) {
                        titleStr.append(title);
                        continue;
                    }
                    titleStr.append(rowTitle);
                    continue;
                }
                title = titleAttr.getValueHandler().getValueDisplayString((DBSTypedObject)titleAttr.getAttribute(), rowTitle, DBDDisplayFormat.UI);
                titleStr.append(title);
            }
            Object rowValue = model.getCellValue(this.valueAttribute, row);
            if (rowValue instanceof Number) {
                ChartValue value = new ChartValue(titleStr.toString(), (Number)rowValue);
                this.values.add(value);
            } else if (rowValue instanceof CharSequence) {
                Number rawValue;
                if (this.valueRegex == null) {
                    rawValue = ChartMeasurement.parseNumber(rowValue.toString());
                    if (rawValue == null) {
                        log.error((Object)("Failed to parse value " + rowValue));
                    }
                } else {
                    CharSequence string = (CharSequence)rowValue;
                    Matcher m = this.valueRegex.matcher(string);
                    if (m.find()) {
                        String valueString;
                        try {
                            valueString = m.group("value");
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            valueString = string.subSequence(m.start(), m.end()).toString();
                        }
                        rawValue = ChartMeasurement.parseNumber(valueString);
                    } else {
                        rawValue = null;
                        arrayList.add(rowValue);
                    }
                }
                if (rawValue != null) {
                    ChartValue value = new ChartValue(titleStr.toString(), rawValue);
                    this.values.add(value);
                }
            }
            ++i;
        }
        if (!arrayList.isEmpty()) {
            StringJoiner errorBuilder = new StringJoiner("\n");
            int i2 = 0;
            while (i2 < arrayList.size()) {
                if (i2 > 2) {
                    errorBuilder.add(String.format("And %s similar errors", arrayList.size() - i2 + 1));
                    break;
                }
                errorBuilder.add(String.format("Failed to parse '%s' value with regex: %s", arrayList.get(i2), this.valueRegex));
                ++i2;
            }
            UIUtils.showMessageBox((Shell)UIUtils.getActiveShell(), (String)"Failed to parse values with regex", (String)errorBuilder.toString(), (int)1);
        }
    }

    static Number parseNumber(String part) {
        Number rawValue;
        try {
            rawValue = Long.parseLong(part);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                rawValue = Double.parseDouble(part);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    rawValue = new BigInteger(part);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        rawValue = new BigDecimal(part);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        rawValue = null;
                    }
                }
            }
        }
        return rawValue;
    }

    static class AttrDictInfo {
        DBSDictionary dictionary;
        Set<Object> keyValues = new LinkedHashSet<Object>();
        Map<String, String> keyLabels = new HashMap<String, String>();
        public DBSEntityAttribute refAttr;

        AttrDictInfo() {
        }
    }
}

