/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class TeradataUser
implements DBAUser {
    private final TeradataDatasource datasource;
    private String name;
    private String creatorName;
    private String ownerName;
    private String protectionType;
    private String timeZoneString;
    private String defaultMapName;
    private boolean isDBA;
    private Date createdTimestamp;
    private String description;

    public TeradataUser(@NotNull TeradataDatasource datasource, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.datasource = datasource;
        this.name = name;
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.ownerName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OwnerName");
        this.protectionType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ProtectionType");
        this.timeZoneString = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TimeZoneString");
        this.defaultMapName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DefaultMapName");
        this.isDBA = "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DBA"));
        this.createdTimestamp = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CommentString");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.datasource;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, order=3)
    public String getOwnerName() {
        return this.ownerName;
    }

    @Property(viewable=true, order=4)
    public String getProtectionType() {
        return "F".equals(this.protectionType) ? "Fallback" : "None";
    }

    @Property(viewable=true, order=5)
    public String getTimeZoneString() {
        return this.timeZoneString;
    }

    @Property(viewable=true, order=6)
    public String getDefaultMapName() {
        return this.defaultMapName;
    }

    @Property(viewable=true, order=7)
    public boolean isDBA() {
        return this.isDBA;
    }

    @Property(viewable=true, order=8)
    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isPersisted() {
        return true;
    }
}

