/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class TeradataRole
implements DBARole {
    private final TeradataDatasource datasource;
    private String name;
    private String creatorName;
    private Date createdTimestamp;
    private String description;

    TeradataRole(@NotNull TeradataDatasource datasource, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.datasource = datasource;
        this.name = name;
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CommentString");
        this.createdTimestamp = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.datasource;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, order=3)
    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isPersisted() {
        return true;
    }
}

