/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class TeradataProfile
implements DBSObject {
    private final TeradataDatasource datasource;
    private String name;
    private String creatorName;
    private String defaultDB;
    private long expirePassword;
    private long passwordMinChar;
    private String defaultMapName;
    private Date createdTimestamp;
    private String description;

    public TeradataProfile(TeradataDatasource datasource, String name, @NotNull JDBCResultSet resultSet) {
        this.datasource = datasource;
        this.name = name;
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.defaultDB = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DefaultDB");
        this.expirePassword = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"ExpirePassword");
        this.passwordMinChar = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"PasswordMinChar");
        this.defaultMapName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DefaultMapName");
        this.createdTimestamp = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CommentString");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.datasource;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, order=3)
    public String getDefaultDB() {
        return this.defaultDB;
    }

    @Property(viewable=true, order=4)
    public long getExpirePassword() {
        return this.expirePassword;
    }

    @Property(viewable=true, order=5)
    public long getPasswordMinChar() {
        return this.passwordMinChar;
    }

    @Property(viewable=true, order=6)
    public String getDefaultMapName() {
        return this.defaultMapName;
    }

    @Property(viewable=true, order=7)
    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isPersisted() {
        return true;
    }
}

