/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatabase;
import com.dbeaver.db.teradata.model.TeradataDatasource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.teradata.model.TeradataMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class TeradataMetaModelExt
extends TeradataMetaModel {
    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new TeradataDatasource(monitor, container, (GenericMetaModel)this);
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog genericCatalog) throws DBException {
        boolean showDatabasesHierarchically = false;
        if (dataSource instanceof TeradataDatasource) {
            showDatabasesHierarchically = ((TeradataDatasource)dataSource).showDatabasesHierarchically();
        }
        String statement = "SELECT * FROM DBC.DatabasesV ORDER BY DatabaseName";
        boolean catalogsRead = false;
        ArrayList<TeradataDatabase> resultList = new ArrayList<TeradataDatabase>();
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(statement);){
                    while (dbResult != null && dbResult.next()) {
                        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DatabaseName");
                        if (CommonUtils.isEmpty((String)name)) continue;
                        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DBKind");
                        boolean isUser = false;
                        if ("U".equalsIgnoreCase(type)) {
                            isUser = true;
                            if (CommonUtils.getBoolean((String)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("hide-users@"), (boolean)false)) continue;
                        }
                        TeradataDatabase database = new TeradataDatabase(dataSource, name, isUser, dbResult);
                        resultList.add(database);
                        catalogsRead = true;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (dataSource.discoverErrorType((Throwable)e) == DBPErrorAssistant.ErrorType.CONNECTION_LOST) {
                throw new DBException((Throwable)e, (DBPDataSource)dataSource);
            }
            catalogsRead = false;
        }
        if (!catalogsRead) {
            return super.loadSchemas(session, dataSource, null);
        }
        if (showDatabasesHierarchically) {
            for (TeradataDatabase database : resultList) {
                String databaseName = database.getName();
                String ownerName = database.getOwnerName();
                if ("DBC".equalsIgnoreCase(databaseName) || CommonUtils.isEmpty((String)ownerName) || databaseName.equals(ownerName) || "DBC".equalsIgnoreCase(ownerName)) {
                    ((TeradataDatasource)dataSource).addDatabaseToFirstLevel(database);
                    continue;
                }
                boolean found = false;
                for (TeradataDatabase catalog : resultList) {
                    if (!catalog.getName().equals(ownerName)) continue;
                    catalog.addChildDatabase(database);
                    database.setParentDatabase(catalog);
                    found = true;
                    break;
                }
                if (found || !database.isUser() || !database.getOwnerName().equalsIgnoreCase(database.getCreatorName())) continue;
                ((TeradataDatasource)dataSource).addDatabaseToFirstLevel(database);
            }
        }
        return new ArrayList<GenericSchema>(resultList);
    }
}

