/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatabase;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class TeradataMacro
implements DBSObject,
DBPScriptObject,
DBPQualifiedObject {
    private final TeradataDatabase database;
    private String name;
    private final String creatorName;
    private final Date createTime;
    private final Date lastAltered;
    private String description;
    private final String definition;

    public TeradataMacro(@NotNull TeradataDatabase database, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.database = database;
        this.name = name;
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
        this.lastAltered = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LastAlterTimeStamp");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CommentString");
        this.definition = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RequestText");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.database;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, order=3)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=4)
    public Date getLastAltered() {
        return this.lastAltered;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=30)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        return this.definition;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.database, this});
    }
}

