/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataMacro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class TeradataDatabase
extends GenericSchema
implements DBPImageProvider {
    private boolean isUser;
    private TeradataDatabase parentDatabase;
    private String name;
    private String ownerName;
    private String creatorName;
    private long permSpace;
    private long tempSpace;
    private Date createdTimestamp;
    private Date lastAltered;
    private String description;
    private final List<TeradataDatabase> childDatabases;
    private final MacroCache macroCache = new MacroCache();

    TeradataDatabase(@NotNull GenericDataSource dataSource, @NotNull String catalogName, boolean isUser, @NotNull JDBCResultSet resultSet) {
        super(dataSource, null, catalogName);
        this.name = catalogName;
        this.isUser = isUser;
        this.childDatabases = new ArrayList<TeradataDatabase>();
        this.ownerName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OwnerName");
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.permSpace = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"PermSpace");
        this.tempSpace = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"TempSpace");
        this.createdTimestamp = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
        this.lastAltered = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LastAlterTimeStamp");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CommentString");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getOwnerName() {
        return this.ownerName;
    }

    @Property(viewable=true, order=3)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, order=4)
    public long getPermSpace() {
        return this.permSpace;
    }

    @Property(viewable=true, order=5)
    public long getTempSpace() {
        return this.tempSpace;
    }

    @Property(viewable=true, order=6)
    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Property(viewable=true, order=7)
    public Date getLastAltered() {
        return this.lastAltered;
    }

    boolean isUser() {
        return this.isUser;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public MacroCache getMacroCache() {
        return this.macroCache;
    }

    @Association
    public Collection<TeradataMacro> getMacros(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.macroCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public TeradataMacro getMacro(@NotNull DBRProgressMonitor monitor, @NotNull String macroName) throws DBException {
        return (TeradataMacro)this.macroCache.getObject(monitor, (DBSObject)this, macroName);
    }

    void setParentDatabase(TeradataDatabase parentDatabase) {
        this.parentDatabase = parentDatabase;
    }

    public DBSObject getParentObject() {
        return this.parentDatabase != null ? this.parentDatabase : this.getDataSource();
    }

    void addChildDatabase(@NotNull TeradataDatabase database) {
        this.childDatabases.add(database);
    }

    @Association
    public List<TeradataDatabase> getCatalogList() {
        if ("DBC".equals(this.getName())) {
            return null;
        }
        GenericDataSource dataSource = this.getDataSource();
        if (dataSource instanceof TeradataDatasource && !((TeradataDatasource)dataSource).showDatabasesHierarchically()) {
            return null;
        }
        return this.childDatabases;
    }

    @Nullable
    public DBPImage getObjectImage() {
        if (this.isUser) {
            return DBIcon.TREE_USER;
        }
        return DBIcon.TREE_DATABASE;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.childDatabases.clear();
        this.macroCache.clearCache();
        return super.refreshObject(monitor);
    }

    public class MacroCache
    extends JDBCObjectLookupCache<TeradataDatabase, TeradataMacro> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull TeradataDatabase teradataDatabase, @Nullable TeradataMacro object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT * FROM dbc.tablesV WHERE tablekind = 'M'\nAND DataBaseName = ?" + (object != null || objectName != null ? " AND TableName = ?" : "");
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            statement.setString(1, teradataDatabase.getName());
            if (object != null || objectName != null) {
                statement.setString(2, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected TeradataMacro fetchObject(@NotNull JDBCSession session, @NotNull TeradataDatabase teradataDatabase, @NotNull JDBCResultSet resultSet) {
            String macroName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TableName");
            if (CommonUtils.isNotEmpty((String)macroName)) {
                return new TeradataMacro(teradataDatabase, macroName, resultSet);
            }
            return null;
        }
    }
}

