/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.cert.model;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Date;
import org.jkiss.code.NotNull;

public class CertDescriptor {
    private final boolean isValid;
    private final String alias;
    private final X509Certificate certificate;

    public CertDescriptor(@NotNull String certName, @NotNull X509Certificate certificate, boolean isValid) {
        this.isValid = isValid;
        this.alias = certName;
        this.certificate = certificate;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public String getAlias() {
        return this.alias;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public int getKeySize() {
        return CertDescriptor.getKeyLength(this.certificate.getPublicKey());
    }

    @NotNull
    public String getType() {
        return this.certificate.getSigAlgName();
    }

    @NotNull
    public Date getExpiryDate() {
        return this.certificate.getNotAfter();
    }

    @NotNull
    public Date getLastModifiedDate() {
        return this.certificate.getNotBefore();
    }

    public static int getKeyLength(@NotNull PublicKey pk) {
        int len = -1;
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapub = (RSAPublicKey)pk;
            len = rsapub.getModulus().bitLength();
        } else if (pk instanceof ECPublicKey) {
            ECPublicKey ecpriv = (ECPublicKey)pk;
            ECParameterSpec spec = ecpriv.getParams();
            len = spec != null ? spec.getOrder().bitLength() : 0;
        } else if (pk instanceof DSAPublicKey) {
            DSAPublicKey dsapub = (DSAPublicKey)pk;
            len = dsapub.getParams() != null ? dsapub.getParams().getP().bitLength() : dsapub.getY().bitLength();
        }
        return len;
    }
}

