/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.ui.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import org.netezza.Driver;
import org.netezza.datasource.NzDatasource;
import org.netezza.ui.Main;
import org.netezza.ui.UIConstants;
import org.netezza.ui.gui.Dialogs;

public class DataSourcePanel
extends JPanel
implements ActionListener,
UIConstants,
MouseListener {
    private JLabel dsnLabel;
    private JButton add;
    private JButton remove;
    private JButton edit;
    private JButton exit;
    private JButton help;
    private JScrollPane tablePane;
    private JTable table;
    private TableModel model;
    private JTableHeader header;

    public DataSourcePanel() {
        this.init();
    }

    public void init() {
        this.setLayout(null);
        this.dsnLabel = new JLabel("List of Data Sources");
        this.model = new TableModel();
        this.table = new JTable(this.model);
        this.header = this.table.getTableHeader();
        this.header.setResizingAllowed(true);
        this.tablePane = new JScrollPane(this.table);
        this.add = this.createButton("Add", 65, "Displays a dialog box to add a new data source.");
        this.remove = this.createButton("Remove", 82, "Displays a dialog box to remove the selected data source.");
        this.edit = this.createButton("Edit", 69, "Displays a dialog box to modify the selected data source.");
        this.exit = this.createButton("Exit", 88, "Closes the window.");
        this.help = this.createButton("Help", 72, "Displays Help dialog.");
        this.addListeners();
        this.setBounds();
        this.addComponents();
    }

    private void addListeners() {
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.edit.addActionListener(this);
        this.exit.addActionListener(this);
        this.help.addActionListener(this);
        this.table.addMouseListener(this);
    }

    private void addComponents() {
        this.add(this.dsnLabel);
        this.add(this.tablePane);
        this.add(this.add);
        this.add(this.edit);
        this.add(this.remove);
        this.add(this.exit);
        this.add(this.help);
    }

    private void setBounds() {
        this.dsnLabel.setBounds(20, 5, 225, 20);
        this.tablePane.setBounds(20, 30, 300, 150);
        this.add.setBounds(340, 30, 80, 20);
        this.edit.setBounds(340, 60, 80, 20);
        this.remove.setBounds(340, 90, 80, 20);
        this.help.setBounds(340, 120, 80, 20);
        this.exit.setBounds(340, 150, 80, 20);
        this.table.getColumn("Data Source").setPreferredWidth(this.tablePane.getWidth() * 30 / 100);
        this.table.getColumn("Description").setPreferredWidth(this.tablePane.getWidth() * 70 / 100);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        NzDatasource source = this.model.getDataSource(this.table.getSelectedRow());
        if (action.equals(this.exit.getActionCommand())) {
            Main.exit();
        } else if (action.equals(this.help.getActionCommand())) {
            this.help();
        } else if (action.equals(this.add.getActionCommand())) {
            this.add();
        } else if (action.equalsIgnoreCase(this.edit.getActionCommand())) {
            this.edit(source);
        } else if (action.equalsIgnoreCase(this.remove.getActionCommand())) {
            this.remove(source);
        }
    }

    private void help() {
        Dialogs.showHelpDialog("Users can add, edit or remove data sources by using this panel. Data sources are stored in the file \"nzjdbc.ini\" which is located in the same directory where driver's jar file is located.\nList of all data sources present in the configuration file is displayed in left pane. \n\nFollowing are the steps to manage Data sources:\nAdd:\n1. Click \"Add\" button. A pop up dialog box will appear.\n2. Enter the properties for the new data source in the popped dialog box. \n3. Click \"Ok\" button to save the data source. \n4. Click \"Cancel\" button to discard the changes. \n\nRemove:\n1. Select data source name to be removed, from the list of data sources.\n2. Click \"Remove\" button to remove the selected data source. \n\n Edit:\n1. Select data source to be modified from the list of data sources. \n2. Click \"Edit\" button or double click on the data source name. A pop up dialog box will appear. \n3. The dialog box shows all the properties for the selected data source. \n4. Modify the properties for the data source. \n5. Click \"Ok\" button to save the changes. \n6. Click \"Cancel\" button to discard the changes.", this);
    }

    private void edit(NzDatasource source) {
        if (source == null) {
            Dialogs.showErrorDialog("Please select a data source to edit.", this);
        } else if (Dialogs.showDatasourceDialog(source) != null) {
            this.model.refresh();
            Dialogs.showSuccessDialog("Data source modified successfully.", this);
        }
    }

    private void add() {
        NzDatasource datasource = Dialogs.showDatasourceDialog();
        if (datasource != null) {
            this.model.datasources.add(datasource);
            this.model.refresh();
            Dialogs.showSuccessDialog("Data source added successfully.", this);
        }
    }

    private void remove(NzDatasource source) {
        if (source == null) {
            Dialogs.showErrorDialog("Please select a data source to remove.", this);
        } else if (Dialogs.showConfirmDialog("Are you sure you want to delete ?", this)) {
            try {
                Driver.removeDataSource(source);
                Driver.save();
                this.model.datasources.remove(source);
                this.model.refresh();
                Dialogs.showSuccessDialog("Data source removed successfully.", this);
            }
            catch (Exception e) {
                Dialogs.showErrorDialog(e.getMessage(), this);
            }
        }
    }

    private JButton createButton(String name, int mnemonic, String tooltip) {
        JButton button = new JButton(name);
        button.setToolTipText(tooltip);
        button.setMnemonic(mnemonic);
        return button;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getSource() == this.table) {
            this.edit(this.model.getDataSource(this.table.getSelectedRow()));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class TableModel
    extends DefaultTableModel {
        private Vector<NzDatasource> datasources;

        public TableModel() {
            this.setColumnIdentifiers(new String[]{"Data Source", "Description"});
            this.datasources = Driver.getDatasources();
            this.refresh();
        }

        public NzDatasource getDataSource(int row) {
            if (row >= 0 && row < this.datasources.size()) {
                return this.datasources.get(row);
            }
            return null;
        }

        public void refresh() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
            int size = this.datasources.size();
            for (int i = 0; i < size; ++i) {
                NzDatasource source = this.datasources.get(i);
                this.addRow(new String[]{source.getName(), source.getDescription()});
            }
        }

        public void removeDatasource(int index) {
            this.datasources.remove(index);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

