/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.ui.cli;

import java.io.BufferedReader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.netezza.Driver;
import org.netezza.datasource.NzDatasource;
import org.netezza.logging.LogLevel;
import org.netezza.logging.LoggerType;
import org.netezza.ui.Main;
import org.netezza.ui.cli.Command;
import org.netezza.util.NzSecurityLevel;

public class ConfigureDsnCommand
extends Command {
    private String dsnName;
    private boolean info;
    private boolean list;
    private byte whatToDo = (byte)-1;
    private final byte EDIT = 1;
    private final byte ADD = (byte)2;
    private final byte DELETE = (byte)3;
    private boolean isNewDsn;
    private static final Map<String, Object> DSN_DEFAULT_VALUES = new HashMap<String, Object>();

    public ConfigureDsnCommand() {
        super("Configure Datasource");
    }

    @Override
    protected void start() {
        int index = this.numberOfParameters();
        String error = null;
        if (index == 0) {
            this.printError("Invalid command");
            this.help();
            Main.exit();
        }
        for (int i = 0; i < index; ++i) {
            String option = this.getOption(i);
            if (option.equals("--dsn") || option.equals("-n")) {
                if (++i != index && (this.dsnName = this.getOption(i)) != null && this.dsnName.trim().length() != 0 && !this.dsnName.startsWith("-")) continue;
                error = "Invalid Datasource name";
                continue;
            }
            if (option.equals("--info") || option.equals("-i")) {
                this.info = true;
                continue;
            }
            if (option.equals("--edit") || option.equals("-e")) {
                if (this.whatToDo > 0) {
                    error = "The optionsadd, delete, editare mutually exclusive.";
                    continue;
                }
                this.whatToDo = 1;
                continue;
            }
            if (option.equals("--delete") || option.equals("-d")) {
                if (this.whatToDo > 0) {
                    error = "The optionsadd, delete, editare mutually exclusive.";
                    continue;
                }
                this.whatToDo = (byte)3;
                continue;
            }
            if (option.equals("--add") || option.equals("-a")) {
                if (this.whatToDo > 0) {
                    error = "The optionsadd, delete, editare mutually exclusive.";
                    continue;
                }
                this.whatToDo = (byte)2;
                continue;
            }
            if (option.equals("--list") || option.equals("-l")) {
                this.list = true;
                continue;
            }
            if (option.equals("--help")) {
                this.help();
                Main.exit();
                continue;
            }
            error = "Invalid option '" + option + " '.";
        }
        if (error != null) {
            this.printError(error);
            Main.exit();
        }
        if (this.list) {
            this.list();
        }
        if (this.info) {
            this.info();
        }
        switch (this.whatToDo) {
            case 2: {
                this.add();
                break;
            }
            case 3: {
                this.delete();
                break;
            }
            case 1: {
                this.edit();
                break;
            }
        }
    }

    private void add() {
        this.printHeader("add");
        NzDatasource dsn = null;
        this.nextLine();
        this.print("List of Data Sources: ");
        this.println(Driver.getDatasourceNames());
        this.nextLine();
        if (this.dsnName != null && this.dsnName.trim().length() > 0 && Driver.isPresent(this.dsnName.trim())) {
            this.printError("Datasource already exists: " + this.dsnName);
            this.dsnName = null;
        }
        while (this.dsnName == null || this.dsnName.trim().length() == 0) {
            this.dsnName = this.getDatasourceName();
            if (this.dsnName == null || this.dsnName.trim().length() <= 0 || !Driver.isPresent(this.dsnName.trim())) continue;
            this.printError("Datasource already exists: " + this.dsnName);
            this.dsnName = null;
        }
        dsn = new NzDatasource(this.dsnName);
        this.isNewDsn = true;
        dsn.setDescription(this.getString("Description", dsn.getDescription()));
        dsn.setBatchSize(this.getBatchSize(dsn.getBatchSize()));
        dsn.setLoginTimeout(this.getLoginTimeout(dsn.getLoginTimeout()));
        dsn.setLogLevel(this.getLogLevel(null).toString());
        if (LogLevel.valueOf(dsn.getLogLevel()) != LogLevel.OFF) {
            dsn.setLoggerType(this.getLoggerType(null).toString());
        }
        if (LogLevel.valueOf(dsn.getLogLevel()) != LogLevel.OFF) {
            dsn.setLogDirPath(this.getString("Logger directory", ""));
        }
        dsn.setUser(this.getString("User", dsn.getUser()));
        dsn.setPassword(this.getPassword("Password", dsn.getPassword()));
        dsn.setDatabase(this.getDatabaseName(dsn.getDatabase()));
        dsn.setHost(this.getHost(dsn.getHost()));
        dsn.setPort(this.getPort(dsn.getPort()));
        dsn.setReadOnly(this.getReadOnly(dsn.isReadOnly()));
        dsn.setAutoCommit(this.getAutoCommit(dsn.isAutoCommit()));
        dsn.setSecurityLevel(this.getSecurityLevel(null).toString());
        dsn.setCaCertificate(this.getString("Certificate file", dsn.getCaCertificate()));
        dsn.setSpecCompliantDBMeta(this.getDatabaseMetadata(dsn.getSpecCompliantDBMeta()));
        dsn.setIgnoreUpdtCount(this.getIgnoreUpdateCount(dsn.getIgnoreUpdtCount()));
        dsn.setCurrentSchema(this.getCurrentSchema(dsn.getCurrentSchema()));
        dsn.setKrbLoginModuleName(this.getKrbLoginModuleName(dsn.getKrbLoginModuleName()));
        dsn.setClientKrbSSODelegation(this.isClientKrbSSODelegated(dsn.isClientKrbSSODelegated()));
        dsn.setClientApplicationName(this.getClientApplicationName(dsn.getClientApplicationName()));
        dsn.setClientUser(this.getClientUser(dsn.getClientUser()));
        dsn.setClientHostName(this.getClientHostName(dsn.getClientHostName()));
        this.nextLine();
        try {
            Driver.addDatasource(dsn);
            Driver.save();
            this.nextLine();
            this.printSuccess("Data source added successfully.");
        }
        catch (SQLException e) {
            this.nextLine();
            Main.exit(e.getMessage());
        }
    }

    private void delete() {
        this.printHeader("delete");
        while ((this.dsnName = this.dsnName != null ? this.dsnName : this.getValue("Data Source")) == null || this.dsnName.trim().length() == 0) {
        }
        String response = null;
        NzDatasource dsn = Driver.getDatasource(this.dsnName);
        this.nextLine();
        if (dsn == null) {
            this.printError("Datasource does not exist.");
            Main.exit();
        }
        if ((response = this.ask("Are you sure you want to delete ?", new String[]{"y", "n"})).equalsIgnoreCase("n")) {
            return;
        }
        try {
            Driver.removeDatasource(this.dsnName);
            Driver.save();
            this.printSuccess("Data source removed successfully.");
        }
        catch (SQLException e) {
            Main.exit(e.getMessage());
        }
    }

    private void edit() {
        NzSecurityLevel secLevel;
        this.printHeader("edit");
        if (Driver.getDatasources().size() == 0) {
            this.printError("No Datasource found");
            return;
        }
        this.print("List of Data Sources: ");
        this.println(Driver.getDatasourceNames());
        NzDatasource dsn = null;
        while (dsn == null) {
            if (this.dsnName == null || this.dsnName.trim().length() == 0) {
                this.dsnName = this.getDatasourceName();
            }
            if ((dsn = Driver.getDatasource(this.dsnName)) != null) continue;
            this.printError("Datasource does not exist.");
            this.nextLine();
            this.dsnName = null;
        }
        this.isNewDsn = false;
        dsn.setDescription(this.getString("Description", dsn.getDescription()));
        dsn.setBatchSize(this.getBatchSize(dsn.getBatchSize()));
        dsn.setLoginTimeout(this.getLoginTimeout(dsn.getLoginTimeout()));
        dsn.setLogLevel(this.getLogLevel(LogLevel.valueOf(dsn.getLogLevel().toUpperCase())).toString());
        if (LogLevel.valueOf(dsn.getLogLevel()) != LogLevel.OFF) {
            dsn.setLoggerType(this.getLoggerType(LoggerType.getLoggerType(dsn.getLoggerType())).toString());
        }
        if (LogLevel.valueOf(dsn.getLogLevel()) != LogLevel.OFF) {
            dsn.setLogDirPath(this.getString("Logger directory", dsn.getLogDirPath()));
        }
        dsn.setUser(this.getString("User", dsn.getUser()));
        dsn.setPassword(this.getPassword("Password", dsn.getPassword()));
        dsn.setDatabase(this.getDatabaseName(dsn.getDatabase()));
        dsn.setHost(this.getHost(dsn.getHost()));
        dsn.setPort(this.getPort(dsn.getPort()));
        dsn.setReadOnly(this.getReadOnly(dsn.isReadOnly()));
        dsn.setAutoCommit(this.getAutoCommit(dsn.isAutoCommit()));
        dsn.setSpecCompliantDBMeta(this.getDatabaseMetadata(dsn.getSpecCompliantDBMeta()));
        dsn.setCurrentSchema(this.getCurrentSchema(dsn.getCurrentSchema()));
        try {
            secLevel = NzSecurityLevel.valueOf(dsn.getSecurityLevel());
        }
        catch (IllegalArgumentException ex) {
            secLevel = null;
        }
        dsn.setSecurityLevel(this.getSecurityLevel(secLevel).toString());
        dsn.setCaCertificate(this.getString("Certificate file", dsn.getCaCertificate()));
        dsn.setIgnoreUpdtCount(this.getIgnoreUpdateCount(dsn.getIgnoreUpdtCount()));
        dsn.setKrbLoginModuleName(this.getKrbLoginModuleName(dsn.getKrbLoginModuleName()));
        dsn.setClientKrbSSODelegation(this.isClientKrbSSODelegated(dsn.isClientKrbSSODelegated()));
        dsn.setClientApplicationName(this.getClientApplicationName(dsn.getClientApplicationName()));
        dsn.setClientUser(this.getClientUser(dsn.getClientUser()));
        dsn.setClientHostName(this.getClientHostName(dsn.getClientHostName()));
        this.nextLine();
        try {
            Driver.save();
            this.nextLine();
            this.printSuccess("Data source modified successfully.");
        }
        catch (SQLException e) {
            Main.exit(e.getMessage());
        }
    }

    private void info() {
        this.printHeader("info");
        this.println("List of Data Sources :");
        this.println(Driver.getDatasourceNames());
        NzDatasource dsn = Driver.getDatasource(this.dsnName);
        if (this.dsnName != null && dsn == null) {
            this.printError("Datasource does not exist.");
        }
        while (dsn == null) {
            this.dsnName = this.getValue("Data Source");
            dsn = Driver.getDatasource(this.dsnName);
            if (dsn != null) continue;
            this.printError("Datasource does not exist.");
        }
        this.nextLine();
        this.printDSN(dsn);
    }

    private void list() {
        this.printHeader("list");
        String[] names = Driver.getDatasourceNames();
        if (names == null || names.length == 0) {
            this.printError("No Datasource found");
        } else {
            System.out.println("Total Number Of Datasources present:" + names.length);
            for (int i = 0; i < names.length; ++i) {
                this.nextLine();
                NzDatasource source = Driver.getDatasource(names[i]);
                this.printDSN(source);
            }
        }
    }

    private String getDatasourceName() {
        String name = null;
        while (name == null || name.trim().length() == 0) {
            name = this.getString("Data Source", "");
        }
        return name;
    }

    private String getDatabaseName(String prev) {
        String name = null;
        while (name == null || name.trim().length() == 0) {
            name = this.getString("Database", prev);
            if (name != null && name.trim().length() != 0) continue;
            this.printError("Database name not specified.");
        }
        return name;
    }

    private String getHost(String prev) {
        String name = null;
        while (name == null || name.trim().length() == 0) {
            name = this.getString("Host", prev);
            if (name != null && name.trim().length() != 0) continue;
            this.printError("Host name not specified");
        }
        return name;
    }

    private String getCurrentSchema(String prev) {
        String name = null;
        name = this.getString("Schema", prev);
        if (name == null || name.trim().length() == 0) {
            name = "";
        }
        return name;
    }

    private String getKrbLoginModuleName(String prev) {
        String name = null;
        name = this.getString("Login module", prev);
        if (name == null || name.trim().length() == 0) {
            name = "";
        }
        return name;
    }

    private int getBatchSize(int previous) {
        int num = -1;
        while (num == -1) {
            try {
                num = this.getInt("Batch size", previous);
                if (num >= 0) continue;
                this.printError("Invalid value for Batch Size.");
            }
            catch (NumberFormatException e) {
                this.printError("Invalid value for Batch Size.");
                num = -1;
            }
        }
        return num;
    }

    private int getLoginTimeout(int previous) {
        int num = -1;
        while (num == -1) {
            try {
                num = this.getInt("Login timeout", previous);
                if (num >= 0) continue;
                this.printError("Invalid value for Login Timeout.");
            }
            catch (NumberFormatException e) {
                this.printError("Invalid value for Login Timeout.");
                num = -1;
            }
        }
        return num;
    }

    private int getPort(int previous) {
        int num = -1;
        while (num == -1) {
            try {
                num = this.getInt("Port", previous);
                if (num >= 0) continue;
                this.printError("Invalid value for Port.");
            }
            catch (NumberFormatException e) {
                this.printError("Invalid value for Port.");
                num = -1;
            }
        }
        return num;
    }

    private LogLevel getLogLevel(LogLevel previous) {
        LogLevel newLevel = null;
        while (newLevel == null) {
            String level = this.getString("Log level", previous == null ? "" : previous.toString());
            try {
                if (level.length() == 0) {
                    if (this.isNewDsn) {
                        newLevel = LogLevel.getDefault();
                        continue;
                    }
                    newLevel = previous;
                    continue;
                }
                newLevel = LogLevel.valueOf(level);
            }
            catch (IllegalArgumentException e) {
                this.nextLine();
                this.printError("Invalid value for Log Level.");
                this.print("Possible Values: ");
                this.print((Object[])LogLevel.values());
                this.nextLine();
            }
        }
        return newLevel;
    }

    private LoggerType getLoggerType(LoggerType previous) {
        LoggerType newType = null;
        while (newType == null) {
            String type = this.getString("Logger type", previous == null ? "" : previous.toString());
            try {
                newType = type.length() == 0 ? (this.isNewDsn ? LoggerType.getDefault() : previous) : LoggerType.valueOf(type);
            }
            catch (IllegalArgumentException ex) {
                this.nextLine();
                this.printError("Invalid value for Logger Type.");
                this.print("Possible Values: ");
                this.print((Object[])LoggerType.values());
                this.nextLine();
            }
        }
        return newType;
    }

    private boolean getReadOnly(boolean previous) {
        boolean defReadOnly = (Boolean)DSN_DEFAULT_VALUES.get("Read only");
        Boolean num = null;
        while (num == null) {
            String bool = this.getValue("Read only[" + defReadOnly + "]" + (this.isNewDsn ? "" : "(" + previous + ")"));
            if (bool.length() == 0) {
                if (this.isNewDsn) {
                    num = defReadOnly;
                    continue;
                }
                num = previous;
                continue;
            }
            if (bool.equalsIgnoreCase(".")) {
                num = defReadOnly;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.TRUE.toString())) {
                num = Boolean.TRUE;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.FALSE.toString())) {
                num = Boolean.FALSE;
                continue;
            }
            this.printError("Invalid value for Read Only.");
        }
        return num;
    }

    private boolean getAutoCommit(boolean previous) {
        boolean defAutoCommit = (Boolean)DSN_DEFAULT_VALUES.get("Autocommit");
        Boolean num = null;
        while (num == null) {
            String bool = this.getValue("Autocommit[" + defAutoCommit + "]" + (this.isNewDsn ? "" : "(" + previous + ")"));
            if (bool.length() == 0) {
                if (this.isNewDsn) {
                    num = defAutoCommit;
                    continue;
                }
                num = previous;
                continue;
            }
            if (bool.equalsIgnoreCase(".")) {
                num = defAutoCommit;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.TRUE.toString())) {
                num = Boolean.TRUE;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.FALSE.toString())) {
                num = Boolean.FALSE;
                continue;
            }
            this.printError("Invalid value for Auto Commit.");
        }
        return num;
    }

    private boolean getIgnoreUpdateCount(boolean previous) {
        boolean defIgnoreUpdateCount = (Boolean)DSN_DEFAULT_VALUES.get("Ignore update count");
        Boolean num = null;
        while (num == null) {
            String bool = this.getValue("Ignore update count[" + defIgnoreUpdateCount + "]" + (this.isNewDsn ? "" : "(" + previous + ")"));
            if (bool.length() == 0) {
                if (this.isNewDsn) {
                    num = defIgnoreUpdateCount;
                    continue;
                }
                num = previous;
                continue;
            }
            if (bool.equalsIgnoreCase(".")) {
                num = defIgnoreUpdateCount;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.TRUE.toString())) {
                num = Boolean.TRUE;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.FALSE.toString())) {
                num = Boolean.FALSE;
                continue;
            }
            this.printError("Invalid value for ignore update count.");
        }
        return num;
    }

    private boolean isClientKrbSSODelegated(boolean previous) {
        boolean defClientKrbSSODelegation = (Boolean)DSN_DEFAULT_VALUES.get("Kerberos SSO delegation");
        Boolean num = null;
        while (num == null) {
            String bool = this.getValue("Kerberos SSO delegation[" + defClientKrbSSODelegation + "]" + (this.isNewDsn ? "" : "(" + previous + ")"));
            if (bool.length() == 0) {
                if (this.isNewDsn) {
                    num = defClientKrbSSODelegation;
                    continue;
                }
                num = previous;
                continue;
            }
            if (bool.equalsIgnoreCase(".")) {
                num = defClientKrbSSODelegation;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.TRUE.toString())) {
                num = Boolean.TRUE;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.FALSE.toString())) {
                num = Boolean.FALSE;
                continue;
            }
            this.printError("Invalid kerberos delegation SSO value provided.");
        }
        return num;
    }

    private boolean getDatabaseMetadata(boolean previous) {
        boolean defDatabaseMetadata = (Boolean)DSN_DEFAULT_VALUES.get("Database metadata");
        Boolean num = null;
        while (num == null) {
            String bool = this.getValue("Database metadata[" + defDatabaseMetadata + "]" + (this.isNewDsn ? "" : "(" + previous + ")"));
            if (bool.length() == 0) {
                if (this.isNewDsn) {
                    num = defDatabaseMetadata;
                    continue;
                }
                num = previous;
                continue;
            }
            if (bool.equalsIgnoreCase(".")) {
                num = defDatabaseMetadata;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.TRUE.toString())) {
                num = Boolean.TRUE;
                continue;
            }
            if (bool.equalsIgnoreCase(Boolean.FALSE.toString())) {
                num = Boolean.FALSE;
                continue;
            }
            this.printError("Invalid value for database metadata.");
        }
        return num;
    }

    private NzSecurityLevel getSecurityLevel(NzSecurityLevel previous) {
        NzSecurityLevel newLevel = null;
        while (newLevel == null) {
            String level = this.getString("Security Level", (previous == null ? "" : previous.toString()).toString());
            try {
                if (level.length() == 0) {
                    if (this.isNewDsn) {
                        newLevel = NzSecurityLevel.getDefault();
                        continue;
                    }
                    newLevel = previous;
                    continue;
                }
                newLevel = NzSecurityLevel.valueOf(level);
            }
            catch (IllegalArgumentException e) {
                this.nextLine();
                this.printError("Invalid value for security level.");
                this.print("Possible Values: ");
                this.print((Object[])NzSecurityLevel.values());
                this.nextLine();
            }
        }
        return newLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPassword(String propId, String previous) {
        String hiddenString = "****";
        BufferedReader bufferedReader = this.commandLineReader;
        synchronized (bufferedReader) {
            Command.PasswordThread thread = new Command.PasswordThread();
            thread.start();
            String value = this.getString(propId, hiddenString);
            thread.stop = true;
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return value.equals(hiddenString) ? previous : value;
        }
    }

    private String getClientApplicationName(String prev) {
        String name = null;
        name = this.getString("Application name", prev);
        if (name == null || name.trim().length() == 0) {
            name = "";
        }
        return name;
    }

    private String getClientUser(String prev) {
        String name = null;
        name = this.getString("Client user", prev);
        if (name == null || name.trim().length() == 0) {
            name = "";
        }
        return name;
    }

    private String getClientHostName(String prev) {
        String name = null;
        name = this.getString("Client host name", prev);
        if (name == null || name.trim().length() == 0) {
            name = "";
        }
        return name;
    }

    protected String getString(String propId, String previous) {
        previous = previous == null ? "" : previous;
        Object obj = DSN_DEFAULT_VALUES.get(propId);
        String defaultVal = obj == null ? "" : obj.toString();
        String value = this.getValue(propId + (defaultVal == null || defaultVal.trim().length() == 0 ? "" : "[" + defaultVal + "]") + (previous == null || previous.trim().length() == 0 ? "" : "(" + previous + ")")).trim();
        if (value.length() == 0) {
            value = this.isNewDsn ? defaultVal : previous;
        }
        return value.equals(".") ? defaultVal : value;
    }

    protected int getInt(String propId, int previous) {
        String number = this.getString(propId, this.isNewDsn ? "" : "" + previous);
        return Integer.parseInt(number);
    }

    @Override
    public void help() {
        System.out.println("DESCRIPTION:\n\tAdds, edits or removes specified datasource from the configuration file.\n\nUSAGE: \n\t[-c | --conf] [option] [value] \n\nOPTIONS: \n\t--dsn, -n \n\t\tName of the data source (Mandatory)\n\n\t--add, -a \n\t\tAdd datasource to the file\n\n\t--edit, -e \n\t\tEdit the given datasource\n\n\t--delete, -d \n\t\tDelete the given datasource\n\n\t--info, -i \n\t\tShow details for the given datasource\n\n\t--list, -l \n\t\tList all the datasources\n\n\t--help \n\t\tPrint this help\n\n\t\n\tNotes:\n\t1. The options -add, -edit and -delete are mutually exclusive. \n\t2. The sequence of execution will be -list, -info, (-add |-edit |-delete) \n\t3. Some properties have values concatenated to them in parenthesis e.g.host[defaulthost](localhost).\n\t4. Edit: --edit or -e \n\t\t   Press 'ENTER' key to assign previous value shown in () OR \n\t\t   Press '.' and 'ENTER' to assign default value shown in [] OR \n\t\t   Enter the new values.\n\t5. Add: --add or -a\n\t\t   Press 'ENTER' or press '.' and 'ENTER' key to assign default value shown in [] \n");
    }

    private void printDSN(NzDatasource dsn) {
        if (dsn == null) {
            this.printError("Datasource does not exist.");
        } else {
            this.println("[" + dsn.getName() + "]");
            this.println("Description=" + dsn.getDescription());
            this.println("Batch size=" + dsn.getBatchSize());
            this.println("Login timeout=" + dsn.getLoginTimeout());
            this.println("Log level=" + dsn.getLogLevel());
            this.println("Logger type=" + dsn.getLoggerType());
            this.println("Logger directory=" + dsn.getLogDirPath());
            this.println("User=" + dsn.getUser());
            this.println("Password=" + dsn.getPassword());
            this.println("Database=" + dsn.getDatabase());
            this.println("Host=" + dsn.getHost());
            this.println("Port=" + dsn.getPort());
            this.println("Schema=" + dsn.getCurrentSchema());
            this.println("Read only=" + dsn.isReadOnly());
            this.println("Autocommit=" + dsn.isAutoCommit());
            this.println("Database metadata=" + dsn.getSpecCompliantDBMeta());
            this.println("Ignore update count=" + dsn.getIgnoreUpdtCount());
            this.println("Login module=" + dsn.getKrbLoginModuleName());
            this.println("Kerberos SSO delegation=" + dsn.isClientKrbSSODelegated());
            this.println("Application name=" + dsn.getClientApplicationName());
            this.println("Client user=" + dsn.getClientUser());
            this.println("Client host name=" + dsn.getClientHostName());
        }
    }

    static {
        DSN_DEFAULT_VALUES.put("Batch size", 256);
        DSN_DEFAULT_VALUES.put("Login timeout", 0);
        DSN_DEFAULT_VALUES.put("Log level", NzDatasource.DefaultValues.DEFAULT_LOG_LEVEL);
        DSN_DEFAULT_VALUES.put("Logger type", (Object)NzDatasource.DefaultValues.DEFAULT_LOGGER_TYPE);
        DSN_DEFAULT_VALUES.put("Port", 5480);
        DSN_DEFAULT_VALUES.put("Read only", false);
        DSN_DEFAULT_VALUES.put("Autocommit", true);
        DSN_DEFAULT_VALUES.put("Security Level", (Object)NzDatasource.DefaultValues.DEFAULT_SECURITY_LEVEL);
        DSN_DEFAULT_VALUES.put("Logger directory", NzDatasource.DefaultValues.DEFAULT_LOG_DIR_PATH);
        DSN_DEFAULT_VALUES.put("Database metadata", false);
        DSN_DEFAULT_VALUES.put("Ignore update count", false);
        DSN_DEFAULT_VALUES.put("Schema", "");
        DSN_DEFAULT_VALUES.put("Login module", "EntryModuleName");
        DSN_DEFAULT_VALUES.put("Kerberos SSO delegation", false);
        DSN_DEFAULT_VALUES.put("Application name", "");
        DSN_DEFAULT_VALUES.put("Client user", "");
        DSN_DEFAULT_VALUES.put("Client host name", "");
    }
}

