/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.netezza.core.NzConstants;
import org.netezza.error.NzFeatureNotSupportedException;
import org.netezza.error.NzMethodNotImplementedException;
import org.netezza.error.NzSQLException;
import org.netezza.externaltable.Loader;
import org.netezza.externaltable.NzLoad;
import org.netezza.internal.NzQuery;
import org.netezza.internal.NzSimpleQuery;
import org.netezza.sql.NzConnection;
import org.netezza.sql.NzResultSet;
import org.netezza.util.QueryLinkedList;

public class NzStatement
implements Statement,
NzConstants {
    protected NzConnection connection;
    protected int updateCount;
    protected NzResultSet set;
    protected NzQuery query;
    private SQLWarning warning = null;
    private int maxRows;
    private int queryTimeout;
    private boolean escapeProcessing = true;
    private final QueryLinkedList batch;
    private final Loader loader;
    private boolean isClosed;

    public NzStatement(NzConnection connection) {
        this.connection = connection;
        this.updateCount = -1;
        this.batch = new QueryLinkedList();
        this.loader = new NzLoad(connection);
        this.isClosed = false;
    }

    public void addWarning(String msg) {
        String method = "addWarning";
        this.connection.LOGGER.entry(this.getClass(), method, msg);
        if (this.warning != null) {
            this.warning.setNextWarning(new SQLWarning(msg));
        } else {
            this.warning = new SQLWarning(msg);
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String method = "addBatch";
        this.connection.LOGGER.entry(this.getClass(), method, sql);
        this.batch.append(new NzSimpleQuery(sql).parse());
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        String method = "executeBatch";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        int[] counts = new int[this.batch.size()];
        this.connection.LOGGER.debug(this.getClass(), method, "BATCH SIZE: " + counts.length);
        int index = 0;
        while ((this.query = this.batch.next()) != null) {
            counts[index++] = this._executeUpdate();
        }
        this.query = null;
        this.connection.LOGGER.exit(this.getClass(), method, counts);
        return counts;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.connection.LOGGER.entry(this.getClass(), "clearBatch");
        this.batch.clear();
        this.connection.LOGGER.exit(this.getClass(), "clearBatch");
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        this.connection.LOGGER.entry(this.getClass(), "cancel");
        this.connection.cancel();
        this.connection.LOGGER.exit(this.getClass(), "cancel");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.connection.LOGGER.entry(this.getClass(), "clearWarnings");
        this.warning = null;
        this.connection.LOGGER.exit(this.getClass(), "clearWarnings");
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (this.connection == null) {
            return;
        }
        String method = "close";
        this.connection.LOGGER.entry(this.getClass(), method);
        this.connection.LOGGER.info(this.getClass(), method, "Clearing the socket....");
        while (this.getMoreResults() || this.getUpdateCount() != -1) {
        }
        if (this.set != null) {
            this.set.close();
        }
        this.connection.LOGGER.exit(this.getClass(), method);
        this.set = null;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        String method = "execute";
        this.connection.LOGGER.entry(this.getClass(), method, sql);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.query = new NzSimpleQuery(sql);
        this.query.setEscapeProcessing(this.escapeProcessing);
        boolean value = this._execute();
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new NzMethodNotImplementedException("NzStatement", "execute(String,int)");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new NzMethodNotImplementedException("NzStatement", "execute(String,int[])");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new NzMethodNotImplementedException("NzStatement", "execute(String,String[])");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        String method = "executeQuery";
        this.connection.LOGGER.entry(this.getClass(), method, sql);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.query = new NzSimpleQuery(sql);
        this.query.setEscapeProcessing(this.escapeProcessing);
        if (this._execute()) {
            this.connection.LOGGER.exit(this.getClass(), method, this.set);
            return this.set;
        }
        NzSQLException etothrow = new NzSQLException("netezza.bad.query.result", "HY000", 11401, new Object[0]);
        this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
        throw etothrow;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        String method = "executeUpdate";
        this.connection.LOGGER.entry(this.getClass(), method, sql);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.query = new NzSimpleQuery(sql);
        this.query.setEscapeProcessing(this.escapeProcessing);
        int number = this._executeUpdate();
        this.connection.LOGGER.exit(this.getClass(), method, number);
        return number;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new NzMethodNotImplementedException("NzStatement", "executeUpdate(String,int)");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new NzMethodNotImplementedException("NzStatement", "executeUpdate(String,int[])");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new NzMethodNotImplementedException("NzStatement", "executeUpdate(String,String[])");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.connection.getDatasource().getBatchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new NzMethodNotImplementedException("NzStatement", "getGeneratedKeys()");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 32768;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        String method = "getMoreResults";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.set != null) {
            this.set.close();
        }
        this.updateCount = -1;
        if (this.set == null) {
            this.connection.LOGGER.exit(this.getClass(), method, false);
            return false;
        }
        if (this.query.getQueryType() != NzQuery.QueryType.BATCH) {
            this.connection.LOGGER.exit(this.getClass(), method, false);
            this.set = null;
            return false;
        }
        if (this.connection.STATE == 1) {
            this.connection.LOGGER.exit(this.getClass(), method, false);
            this.set = null;
            return false;
        }
        if (this.connection.STATE == 3) {
            this.set.close();
        }
        this.set = this.connection.getNextResult(this);
        boolean value = this.set != null;
        this.connection.LOGGER.exit(this.getClass(), method, value);
        return value;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new NzMethodNotImplementedException("NzStatement", "getMoreResults(int)");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.set;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.set == null ? 1007 : this.set.getConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.set == null ? 1003 : this.set.getType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warning;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        String method = "setCursorName";
        this.connection.LOGGER.entry(this.getClass(), method);
        this.connection.LOGGER.info(this.getClass(), method, "The cursor name is not stored since the database does not support positioned updates/deletes");
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                NzSQLException etothrow = new NzSQLException("netezza.res.invalid.fetch.direction", "HY000", 11427, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), "setFetchDirection", etothrow);
                throw etothrow;
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            NzSQLException etothrow = new NzSQLException("netezza.invalid.fetch.size", "HY000", 11424, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "setFetchSize", etothrow);
            throw etothrow;
        }
        if (this.getMaxRows() > 0 && rows > this.getMaxRows()) {
            NzSQLException etothrow = new NzSQLException("netezza.invalid.fetch.size", "HY000", 11425, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "setFetchSize", etothrow);
            throw etothrow;
        }
        this.connection.getDatasource().setBatchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            NzSQLException e = new NzSQLException("netezza.max.field.size.neg", "HY000", 11405, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "setMaxFieldSize", e);
            throw e;
        }
        this.addWarning("An attempt to setMaxFieldSize() failed - compile time default in force.");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            NzSQLException etothrow = new NzSQLException("netezza.max.rows.neg", "HY000", 11404, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "setMaxRows", etothrow);
            throw etothrow;
        }
        this.maxRows = max;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            NzSQLException etothrow = new NzSQLException("netezza.query.timeout.neg", "HY000", 11402, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "setMaxRows", etothrow);
            throw etothrow;
        }
        this.queryTimeout = seconds;
    }

    protected boolean _execute() throws SQLException {
        if (this.query == null) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.nullquery", "HY009", 11450, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "_execute", etothrow);
            throw etothrow;
        }
        this.query = this.query.parse();
        this.set = this.connection.execute(this, this.query);
        return this.set != null;
    }

    protected int _executeUpdate() throws SQLException {
        if (this._execute()) {
            if (this.set != null) {
                this.set.close();
            }
            NzSQLException etothrow = new NzSQLException("netezza.bad.query.result", "HY000", 11401, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "_executeUpdate", etothrow);
            throw etothrow;
        }
        this.connection.LOGGER.exit(this.getClass(), "_executeUpdate", this.updateCount);
        return this.updateCount;
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    public void setResponse(String message) throws SQLException {
        String method = "setResponse";
        this.connection.LOGGER.entry(this.getClass(), method, message);
        if (message == null) {
            return;
        }
        message = message.trim();
        try {
            if (message.startsWith("INSERT") || message.startsWith("UPDATE") || message.startsWith("DELETE") || message.startsWith("MOVE")) {
                this.updateCount = Integer.parseInt(message.substring(1 + message.lastIndexOf(32)));
            }
            if (message.startsWith("INSERT")) {
                long insert_oid = Long.parseLong(message.substring(1 + message.indexOf(32), message.lastIndexOf(32)));
            }
        }
        catch (NumberFormatException nfe) {
            if (this.connection.getDatasource().getIgnoreUpdtCount()) {
                this.connection.LOGGER.debug(this.getClass(), method, "Update count is beyond integer max range. Setting it to Integer.MIN_VALUE.");
                this.updateCount = Integer.MIN_VALUE;
            }
            NzSQLException etothrow = new NzSQLException("netezza.update.count.exceed.int.range", "HY000", 1012, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "setResponse", etothrow);
            throw etothrow;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    private void checkClosed() throws SQLException {
        if (this.connection == null) {
            throw new NzSQLException("netezza.stmt.closed", "HY000", 11400, new Object[0]);
        }
    }

    public Loader getLoader() {
        return this.loader;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("closeOnCompletion");
        this.connection.LOGGER.fatal(this.getClass(), "closeOnCompletion", etothrow);
        throw etothrow;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.isClosed) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "isCloseOnCompletion", etothrow);
            throw etothrow;
        }
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.isClosed) {
            NzSQLException etothrow = new NzSQLException("netezza.stmt.closed", "HY000", 1100, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), "isPoolable", etothrow);
            throw etothrow;
        }
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setPoolable");
        this.connection.LOGGER.fatal(this.getClass(), "setPoolable", etothrow);
        throw etothrow;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("isWrapperFor");
        this.connection.LOGGER.fatal(this.getClass(), "isWrapperFor", etothrow);
        throw etothrow;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("unwrap");
        this.connection.LOGGER.fatal(this.getClass(), "unwrap", etothrow);
        throw etothrow;
    }
}

