/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.datasource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.netezza.datasource.NzConnectionPool;
import org.netezza.datasource.NzConnectionPoolDatasource;
import org.netezza.datasource.NzDatasource;
import org.netezza.datasource.NzDatasourceException;
import org.netezza.logging.LoggerType;
import org.netezza.util.NzSecurityLevel;

public class NzDatasourceFactory
implements ObjectFactory {
    private HashMap<String, NzDatasource> simpleDatasources = new HashMap();
    private boolean isLoaded;
    private String name;

    public void load(String file) throws NzDatasourceException {
        if (this.isLoaded) {
            throw new NzDatasourceException("Factory is already loaded.");
        }
        if (file == null || file.trim().length() == 0) {
            throw new NzDatasourceException("Bad File Name");
        }
        this.name = file;
        int index = -1;
        String line = null;
        String dataSourceName = null;
        StringBuffer comments = null;
        BufferedReader bufferedReader = null;
        FileReader reader = null;
        NzDatasource source = null;
        try {
            reader = new FileReader(this.name);
            if (reader != null) {
                bufferedReader = new BufferedReader(reader);
                if (bufferedReader != null) {
                    while (bufferedReader.ready()) {
                        index = -1;
                        line = null;
                        line = bufferedReader.readLine().trim();
                        if (line == null || line.trim().length() == 0) continue;
                        if (line.startsWith(";")) {
                            if (comments == null) {
                                comments = new StringBuffer(line.substring(1));
                                continue;
                            }
                            comments.append(line.substring(1));
                            continue;
                        }
                        if (line.startsWith("[") && line.endsWith("]")) {
                            if (source != null) {
                                this.simpleDatasources.put(source.getName(), source);
                            }
                            dataSourceName = line.substring(1, line.length() - 1);
                            source = new NzDatasource(dataSourceName);
                            continue;
                        }
                        index = line.indexOf("=");
                        if (index <= 0 || source == null || source == null) continue;
                        this.setDatasourceProperty(source, line.substring(0, index).trim(), line.substring(index + 1).trim());
                    }
                    if (source != null) {
                        this.simpleDatasources.put(source.getName(), source);
                    }
                }
                this.isLoaded = true;
            }
        }
        catch (Exception e) {
            throw new NzDatasourceException(e.getMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void store() throws NzDatasourceException {
        File file = new File(this.name);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileWriter writer = new FileWriter(file);
            Collection<NzDatasource> collection = this.simpleDatasources.values();
            for (NzDatasource datasource : collection) {
                writer.write(this.toString(datasource, false) + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new NzDatasourceException(e.getMessage());
        }
    }

    public void setDatasourceProperty(NzDatasource source, String key, String value) throws NzDatasourceException {
        if (key.equalsIgnoreCase("description")) {
            source.setDescription(value);
        } else if (key.equalsIgnoreCase("batchSize")) {
            source.setBatchSize(this.getInt(value));
        } else if (key.equalsIgnoreCase("loginTimeout")) {
            source.setLoginTimeout(this.getInt(value));
        } else if (key.equalsIgnoreCase("logLevel")) {
            source.setLogLevel(value);
        } else if (key.equalsIgnoreCase("logDirPath")) {
            source.setLogDirPath(value);
        } else if (key.equalsIgnoreCase("loggerType")) {
            source.setLoggerType(LoggerType.getLoggerType(value).toString());
        } else if (key.equalsIgnoreCase("user")) {
            source.setUser(value);
        } else if (key.equalsIgnoreCase("password")) {
            source.setPassword(value);
        } else if (key.equalsIgnoreCase("database")) {
            source.setDatabase(value);
        } else if (key.equalsIgnoreCase("host")) {
            source.setHost(value);
        } else if (key.equalsIgnoreCase("port")) {
            source.setPort(this.getInt(value));
        } else if (key.equalsIgnoreCase("readonly")) {
            source.setReadOnly(this.getBool(value));
        } else if (key.equalsIgnoreCase("autocommit")) {
            source.setAutoCommit(this.getBool(value));
        } else if (key.equalsIgnoreCase("securityLevel")) {
            NzSecurityLevel level = NzSecurityLevel.getSecurityLevel(value);
            source.setSecurityLevel((level == null ? NzSecurityLevel.getDefault() : level).toString());
        } else if (key.equalsIgnoreCase("caCertFile")) {
            source.setCaCertificate(value);
        } else if (key.equalsIgnoreCase("DatabaseMetaData")) {
            source.setSpecCompliantDBMeta(this.getBool(value));
        } else if (key.equalsIgnoreCase("ignoreUpdateCount")) {
            source.setIgnoreUpdtCount(this.getBool(value));
        } else if (key.equalsIgnoreCase("schema")) {
            source.setCurrentSchema(value);
        } else if (key.equalsIgnoreCase("krbLoginModule")) {
            source.setKrbLoginModuleName(value);
        } else if (key.equalsIgnoreCase("krbSSODelegation")) {
            source.setClientKrbSSODelegation(this.getBool(value));
        } else if (key.equalsIgnoreCase("applicationName")) {
            source.setClientApplicationName(value);
        } else if (key.equalsIgnoreCase("clientUser")) {
            source.setClientUser(value);
        } else if (key.equalsIgnoreCase("clientHostName")) {
            source.setClientHostName(value);
        }
    }

    public NzDatasource removeDataSource(NzDatasource source) {
        return this.simpleDatasources.remove(source.getName());
    }

    public NzDatasource removeDatasource(String name) throws NzDatasourceException {
        NzDatasource source = this.getDataSource(name);
        if (source == null) {
            throw new NzDatasourceException("Datasource does not exist.");
        }
        return this.simpleDatasources.remove(source);
    }

    public NzDatasource getDataSource(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        return this.simpleDatasources.get(name);
    }

    public void addDatasource(NzDatasource source) throws NzDatasourceException {
        if (this.isPresent(source.getName())) {
            throw new NzDatasourceException("Datasource already exists.");
        }
        this.simpleDatasources.put(source.getName(), source);
    }

    public boolean isPresent(String name) {
        return this.simpleDatasources.containsKey(name);
    }

    public String toString(NzDatasource source, Boolean forLogging) {
        String datasourceToString = "[" + source.getName() + "] \n" + "description" + "=" + source.getDescription() + "\n" + "user" + "=" + source.getUser() + "\n";
        datasourceToString = forLogging != false ? datasourceToString + "password=****\n" : datasourceToString + "password=" + source.getPassword() + "\n";
        datasourceToString = datasourceToString + "protocol=" + source.getProtocol() + "\n" + "database" + "=" + source.getDatabase() + "\n" + "host" + "=" + source.getHost() + "\n" + "port" + "=" + source.getPort() + "\n" + "schema" + "=" + source.getCurrentSchema() + "\n" + "batchSize" + "=" + source.getBatchSize() + "\n" + "loginTimeout" + "=" + source.getLoginTimeout() + "\n" + "logLevel" + "=" + source.getLogLevel() + "\n" + "loggerType" + "=" + source.getLoggerType().toString() + "\n" + "logDirPath" + "=" + source.getLogDirPath() + "\n" + "readonly" + "=" + source.isReadOnly() + "\n" + "autocommit" + "=" + source.isAutoCommit() + "\n" + "securityLevel" + "=" + source.getSecurityLevel() + "\n" + "caCertFile" + "=" + source.getCaCertificate() + "\n" + "DatabaseMetaData" + "=" + source.getSpecCompliantDBMeta() + "\n" + "ignoreUpdateCount" + "=" + source.getIgnoreUpdtCount() + "\n" + "krbLoginModule" + "=" + source.getKrbLoginModuleName() + "\n" + "krbSSODelegation" + "=" + source.isClientKrbSSODelegated() + "\n" + "applicationName" + "=" + source.getClientApplicationName() + "\n" + "clientUser" + "=" + source.getClientUser() + "\n" + "clientHostName" + "=" + source.getClientHostName() + "\n";
        return datasourceToString;
    }

    public Vector<NzDatasource> getDatasources() {
        Vector<NzDatasource> vector = new Vector<NzDatasource>();
        if (this.simpleDatasources != null) {
            Collection<NzDatasource> datasources = this.simpleDatasources.values();
            vector.addAll(datasources);
        }
        return vector;
    }

    public String[] getDatasourceNames() {
        String[] names = new String[this.simpleDatasources.size()];
        Set<String> nameSet = this.simpleDatasources.keySet();
        int i = 0;
        for (String name : nameSet) {
            names[i++] = name;
        }
        return names;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            Reference reference = (Reference)obj;
            String cName = reference.getClassName();
            if (cName.equals(NzDatasource.class.getName())) {
                return this.loadDatasource(reference);
            }
            if (cName.equals(NzConnectionPoolDatasource.class.getName())) {
                return this.loadConnectionPoolDatasource(reference);
            }
            if (cName.equals(NzConnectionPool.class.getName())) {
                return this.loadConnectionPool(reference);
            }
            return null;
        }
        return null;
    }

    private NzDatasource loadDatasource(Reference reference) throws NzDatasourceException {
        NzDatasource datasource = new NzDatasource();
        this.load(reference, datasource);
        return datasource;
    }

    private NzDatasource loadConnectionPoolDatasource(Reference reference) throws NzDatasourceException {
        NzConnectionPoolDatasource datasource = new NzConnectionPoolDatasource();
        this.load(reference, datasource);
        return datasource;
    }

    private NzDatasource loadConnectionPool(Reference reference) throws NzDatasourceException {
        String _maxConnections;
        NzConnectionPool datasource = new NzConnectionPool();
        this.load(reference, datasource);
        String _initialConnections = this.getProperty(reference, "initialConnections");
        if (_initialConnections != null && _initialConnections.trim().length() > 0) {
            datasource.setInitialConnections(this.getInt(_initialConnections));
        }
        if ((_maxConnections = this.getProperty(reference, "maxConnections")) != null && _maxConnections.trim().length() > 0) {
            datasource.setMaxConnections(this.getInt(_maxConnections));
        }
        return datasource;
    }

    private void load(Reference reference, NzDatasource datasource) throws NzDatasourceException {
        String _clientHostName;
        String _clientUser;
        String _applicationName;
        String _krbSSODelegation;
        String _krbLoginModule;
        String _currSchema;
        String _ignoreUpdtCount;
        String _caCert;
        String _sLevel;
        String _dbMetadata;
        String _aCommit;
        String _rOnly;
        String _port;
        String _host;
        String _database;
        String _password;
        String _user;
        String _lType;
        String _lDirPath;
        String _lLevel;
        String _lTimeout;
        String _bSize;
        String _desc = this.getProperty(reference, "description");
        if (_desc != null && _desc.trim().length() > 0) {
            datasource.setDescription(_desc);
        }
        if ((_bSize = this.getProperty(reference, "batchsize")) != null && _bSize.trim().length() > 0) {
            datasource.setBatchSize(this.getInt(_bSize));
        }
        if ((_lTimeout = this.getProperty(reference, "logintimeout")) != null && _lTimeout.trim().length() > 0) {
            datasource.setLoginTimeout(this.getInt(_lTimeout));
        }
        if ((_lLevel = this.getProperty(reference, "loglevel")) != null && _lLevel.trim().length() > 0) {
            datasource.setLogLevel(_lLevel);
        }
        if ((_lDirPath = this.getProperty(reference, "logdirpath")) != null && _lDirPath.trim().length() > 0) {
            datasource.setLogDirPath(_lDirPath);
        }
        if ((_lType = this.getProperty(reference, "loggertype")) != null && _lType.trim().length() > 0) {
            datasource.setLoggerType(LoggerType.getLoggerType(_lType).toString());
        }
        if ((_user = this.getProperty(reference, "user")) != null && _user.trim().length() > 0) {
            datasource.setUser(_user);
        }
        if ((_password = this.getProperty(reference, "password")) != null && _password.trim().length() > 0) {
            datasource.setPassword(_password);
        }
        if ((_database = this.getProperty(reference, "database")) != null && _database.trim().length() > 0) {
            datasource.setDatabase(_database);
        }
        if ((_host = this.getProperty(reference, "host")) != null && _host.trim().length() > 0) {
            datasource.setHost(_host);
        }
        if ((_port = this.getProperty(reference, "port")) != null && _port.trim().length() > 0) {
            datasource.setPort(this.getInt(_port));
        }
        if ((_rOnly = this.getProperty(reference, "readonly")) != null && _rOnly.trim().length() > 0) {
            datasource.setReadOnly(this.getBool(_rOnly));
        }
        if ((_aCommit = this.getProperty(reference, "autocommit")) != null && _aCommit.trim().length() > 0) {
            datasource.setAutoCommit(this.getBool(_aCommit));
        }
        if ((_dbMetadata = this.getProperty(reference, "databasemetadata")) != null && _dbMetadata.trim().length() > 0) {
            datasource.setSpecCompliantDBMeta(this.getBool(_dbMetadata));
        }
        if ((_sLevel = this.getProperty(reference, "securitylevel")) != null && _sLevel.trim().length() > 0) {
            datasource.setSecurityLevel(_sLevel);
        }
        if ((_caCert = this.getProperty(reference, "cacertfile")) != null && _caCert.trim().length() > 0) {
            datasource.setCaCertificate(_caCert);
        }
        if ((_ignoreUpdtCount = this.getProperty(reference, "ignoreUpdtCount")) != null && _ignoreUpdtCount.trim().length() > 0) {
            datasource.setIgnoreUpdtCount(this.getBool(_ignoreUpdtCount));
        }
        if ((_currSchema = this.getProperty(reference, "currentSchema")) != null && _currSchema.trim().length() > 0) {
            datasource.setCurrentSchema(_currSchema);
        }
        if ((_krbLoginModule = this.getProperty(reference, "krbLoginModule")) != null && _krbLoginModule.trim().length() > 0) {
            datasource.setKrbLoginModuleName(_krbLoginModule);
        }
        if ((_krbSSODelegation = this.getProperty(reference, "krbSSODelegation")) != null && _krbSSODelegation.trim().length() > 0) {
            datasource.setClientKrbSSODelegation(this.getBool(_krbSSODelegation));
        }
        if ((_applicationName = this.getProperty(reference, "applicationName")) != null && _applicationName.trim().length() > 0) {
            datasource.setClientApplicationName(_applicationName);
        }
        if ((_clientUser = this.getProperty(reference, "clientUser")) != null && _clientUser.trim().length() > 0) {
            datasource.setClientUser(_clientUser);
        }
        if ((_clientHostName = this.getProperty(reference, "clientHostName")) != null && _clientHostName.trim().length() > 0) {
            datasource.setClientHostName(_clientHostName);
        }
    }

    protected String getProperty(Reference ref, String s) {
        RefAddr addr = ref.get(s);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }

    private int getInt(String value) throws NzDatasourceException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new NzDatasourceException("Invalid integer value '" + value + "'.");
        }
    }

    private boolean getBool(String value) throws NzDatasourceException {
        if (value == null) {
            throw new NzDatasourceException("Invalid boolean value '" + value + "'.");
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new NzDatasourceException("Invalid boolean value '" + value + "'.");
    }
}

