/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.gcp;

import com.dbeaver.net.auth.gcp.AuthModelGCP;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AuthModelGCPSpanner
extends AuthModelGCP {
    public static final String ID = "gcp_cloud_iam_spanner";

    @Override
    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelGCPCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        credentials.resolveCredentials(monitor);
        if (credentials != null) {
            if (credentials.getAuthType() == GCPAuthType.SERVICE_ACCOUNT) {
                if (CommonUtils.isNotEmpty((String)credentials.getServiceAccountConfigPath())) {
                    connectProps.put("credentials", credentials.getServiceAccountConfigPath());
                }
                if (CommonUtils.isNotEmpty((String)credentials.getServiceAccountConfig())) {
                    connectProps.put("encodedCredentials", credentials.getServiceAccountConfig());
                }
            } else if (credentials.getAuthType() == GCPAuthType.SESSION_CREDENTIALS && CommonUtils.isNotEmpty((String)credentials.getToken())) {
                connectProps.put("oauthToken", credentials.getToken());
            }
        }
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connectProps);
    }
}

