/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.azure;

import com.azure.core.credential.AccessToken;
import com.dbeaver.net.auth.azure.AuthModelAzureAbstract;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import com.dbeaver.net.auth.azure.AuthModelAzureGroupCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AuthModelAzureGroup
extends AuthModelAzureAbstract<AuthModelAzureGroupCredentials> {
    public static final String AZURE_GROUP_PROP = "azureGroup";

    protected void setUserOrGroupPassword(@NotNull DBRProgressMonitor monitor, @NotNull AuthModelAzureGroupCredentials credentials, @NotNull Properties properties) throws DBException {
        AccessToken accessToken = credentials.getAccessToken(monitor, AuthModelAzureCredentials.Resource.DATABASE);
        properties.put("password", accessToken.getToken());
    }

    @Override
    @NotNull
    public AuthModelAzureGroupCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelAzureCredentials credentials = AuthModelAzureGroup.getAzureCredentialsFromContext(configuration);
        if (credentials == null) {
            credentials = super.loadCredentials(dataSource, configuration);
        }
        AuthModelAzureGroupCredentials groupCredentials = new AuthModelAzureGroupCredentials(credentials);
        String groupName = configuration.getAuthProperty(AZURE_GROUP_PROP);
        if (CommonUtils.isNotEmpty((String)groupName)) {
            groupCredentials.setAzureGroupName(groupName);
        }
        return groupCredentials;
    }

    @Override
    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelAzureGroupCredentials credentials) {
        super.saveCredentials(dataSource, configuration, credentials);
        if (credentials.getAzureGroupName() != null) {
            configuration.setAuthProperty(AZURE_GROUP_PROP, credentials.getAzureGroupName());
        }
    }

    @NotNull
    public AuthModelAzureGroupCredentials createCredentials() {
        return new AuthModelAzureGroupCredentials();
    }
}

