/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.azure;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.ClientCertificateCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.resourcemanager.subscription.SubscriptionManager;
import com.azure.resourcemanager.subscription.models.Subscription;
import com.azure.resourcemanager.subscription.models.TenantIdDescription;
import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.model.auth.SMSessionAuthCredentials;
import com.dbeaver.net.auth.azure.AzureAuthType;
import com.dbeaver.net.auth.azure.AzureFederatedTokenCredential;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AuthModelAzureCredentials
extends AuthModelDatabaseNativeCredentials
implements SMSessionAuthCredentials {
    private static final long AUTH_TIMEOUT = 60L;
    @NotNull
    private AzureAuthType authType = AzureAuthType.WEB_APPLICATION;
    private String clientId;
    private String clientSecret;
    private String clientCertificateValue;
    private String clientCertificatePath;
    private String tenantId;
    private transient PublicClientApplication application;
    private transient String subscriptionId;
    private final transient Map<String, AccessToken> resourceTokens = new HashMap<String, AccessToken>();
    private transient String azureUserId;

    public AuthModelAzureCredentials() {
    }

    public AuthModelAzureCredentials(@NotNull AuthModelAzureCredentials other) {
        this.authType = other.getAuthType();
        this.clientId = other.clientId;
        this.clientSecret = other.clientSecret;
        this.clientCertificateValue = other.clientCertificateValue;
        this.clientCertificatePath = other.clientCertificatePath;
        this.application = other.application;
        this.tenantId = other.tenantId;
        this.subscriptionId = other.subscriptionId;
        this.resourceTokens.putAll(other.resourceTokens);
        this.azureUserId = other.azureUserId;
    }

    public boolean isSessionCredentials() {
        return this.authType == AzureAuthType.SESSION_CREDENTIALS;
    }

    @NotNull
    public AzureAuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(@NotNull AzureAuthType authType) {
        this.authType = authType;
    }

    @NotNull
    public <T> T authenticateWithToken(@NotNull DBRProgressMonitor monitor, @NotNull AzureScopes resource, @NotNull BiFunction<TokenCredential, AzureProfile, T> factory) throws DBException {
        TokenCredential credential = this.getAccessCredentials(monitor, resource);
        AzureProfile profile = this.acquireProfile(monitor, credential);
        return factory.apply(credential, profile);
    }

    public void addToken(AzureScopes scopes, AccessToken token) {
        for (String scope : scopes.getScopes()) {
            this.resourceTokens.put(scope, token);
        }
    }

    public void addResourceToken(@NotNull String accessToken, @NotNull Resource resource) {
        this.addToken(resource, new AccessToken(accessToken, OffsetDateTime.MAX));
    }

    @NotNull
    public synchronized AccessToken getAccessToken(@NotNull DBRProgressMonitor monitor, @NotNull AzureScopes scopes) throws DBException {
        this.getAccessCredentials(monitor, scopes);
        AccessToken token = this.getTokenByScopes(scopes);
        if (token == null) {
            throw new DBException("Access token not found for '" + scopes.getScopes() + "'");
        }
        return token;
    }

    @Nullable
    private AccessToken getTokenByScopes(@NotNull AzureScopes scopes) {
        String scope;
        AccessToken accessToken;
        Iterator<String> iterator = scopes.getScopes().iterator();
        if (iterator.hasNext() && (accessToken = this.resourceTokens.get(scope = iterator.next())) != null) {
            return accessToken;
        }
        return null;
    }

    @NotNull
    public synchronized TokenCredential getAccessCredentials(@NotNull DBRProgressMonitor monitor, @NotNull AzureScopes scopes) throws DBException {
        AccessToken token = this.getTokenByScopes(scopes);
        if (token != null && token.getExpiresAt() != null && token.isExpired()) {
            token = null;
        }
        if (token == null) {
            if (this.resolveSessionCredentials(monitor) && (token = this.getTokenByScopes(scopes)) != null) {
                return new AzureFederatedTokenCredential(token);
            }
            if (CommonUtils.isEmpty((String)this.clientId)) {
                throw new DBException("Azure authentication is available in Azure AD session only");
            }
            String tenant = this.tenantId;
            if (CommonUtils.isEmptyTrimmed((String)tenant)) {
                tenant = null;
            }
            Set<String> authScopes = scopes.getScopes();
            if (this.authType == AzureAuthType.DEFAULT) {
                DefaultAzureCredential defaultAzureCredential = new DefaultAzureCredentialBuilder().build();
                return this.acquireTokenFromCredentials(scopes, authScopes, (TokenCredential)defaultAzureCredential);
            }
            if (!CommonUtils.isEmpty((String)this.clientSecret)) {
                ClientSecretCredentialBuilder csBuilder = ((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.clientId)).clientSecret(this.clientSecret);
                if (!CommonUtils.isEmpty((String)tenant)) {
                    csBuilder.tenantId(tenant);
                }
                ClientSecretCredential clientSecretCredential = csBuilder.build();
                return this.acquireTokenFromCredentials(scopes, authScopes, (TokenCredential)clientSecretCredential);
            }
            if (!CommonUtils.isEmpty((String)this.clientCertificateValue) || !CommonUtils.isEmpty((String)this.clientCertificatePath)) {
                ClientCertificateCredentialBuilder ccBuilder = (ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(this.clientId);
                if (!CommonUtils.isEmpty((String)tenant)) {
                    ccBuilder.tenantId(tenant);
                }
                if (!CommonUtils.isEmpty((String)this.clientCertificatePath)) {
                    ccBuilder.pemCertificate(this.clientCertificatePath);
                } else {
                    ccBuilder.pemCertificate((InputStream)new ByteArrayInputStream(this.clientCertificatePath.getBytes(StandardCharsets.UTF_8)));
                }
                ClientCertificateCredential clientCertificateCredential = ccBuilder.build();
                return this.acquireTokenFromCredentials(scopes, authScopes, (TokenCredential)clientCertificateCredential);
            }
            if (this.application == null) {
                PublicClientApplication.Builder pcaBuilder = PublicClientApplication.builder((String)this.clientId);
                try {
                    pcaBuilder.authority(MessageFormat.format("https://login.microsoftonline.com/{0}/oauth2/v2.0/authorize", CommonUtils.toString((Object)tenant, (String)"common")));
                }
                catch (MalformedURLException e) {
                    throw new DBException("Error configuring Entra authority", (Throwable)e);
                }
                this.application = pcaBuilder.build();
            }
            try {
                try {
                    CompletableFuture request;
                    monitor.subTask("Read account info");
                    Set accounts = (Set)this.application.getAccounts().get(60L, TimeUnit.SECONDS);
                    if (accounts.isEmpty()) {
                        InteractiveRequestParameters.InteractiveRequestParametersBuilder irpBuilder = InteractiveRequestParameters.builder((URI)URI.create("http://localhost")).scopes(authScopes);
                        if (!CommonUtils.isEmpty((String)tenant)) {
                            irpBuilder.tenant(tenant);
                        }
                        request = this.application.acquireToken(irpBuilder.build());
                    } else {
                        SilentParameters.SilentParametersBuilder spBuilder = SilentParameters.builder(authScopes, (IAccount)((IAccount)accounts.iterator().next()));
                        if (!CommonUtils.isEmpty((String)tenant)) {
                            spBuilder.tenant(tenant);
                        }
                        request = this.application.acquireTokenSilently(spBuilder.build());
                    }
                    monitor.subTask("Read token from cloud");
                    IAuthenticationResult result = (IAuthenticationResult)request.get(60L, TimeUnit.SECONDS);
                    token = new AccessToken(result.accessToken(), result.expiresOnDate().toInstant().atOffset(OffsetDateTime.now().getOffset()));
                    this.setAzureUserId(result.account().username());
                    this.addToken(scopes, token);
                }
                catch (Exception e) {
                    throw new DBException("Error acquiring token", (Throwable)e);
                }
            }
            finally {
                monitor.worked(1);
            }
        }
        return new AzureFederatedTokenCredential(token);
    }

    private boolean resolveSessionCredentials(DBRProgressMonitor monitor) throws DBException {
        if (this.isSessionCredentials() && this.resourceTokens.isEmpty()) {
            if (!SMAuthUtils.updateSessionCredentialsFromSession((DBRProgressMonitor)monitor, (String)"azure", (String)"Azure", (SMSessionAuthCredentials)this)) {
                throw new DBCException("Azure session credentials are missing");
            }
            return true;
        }
        return false;
    }

    @NotNull
    private TokenCredential acquireTokenFromCredentials(@NotNull AzureScopes scopes, @NotNull Set<String> authScopes, @NotNull TokenCredential clientSecretCredential) {
        TokenRequestContext requestContext = new TokenRequestContext();
        requestContext.setScopes(new ArrayList<String>(authScopes));
        requestContext.setTenantId(this.tenantId);
        AccessToken token = clientSecretCredential.getTokenSync(requestContext);
        this.addToken(scopes, token);
        return clientSecretCredential;
    }

    @Nullable
    public String getResourceToken(@NotNull Resource resource) {
        AccessToken token = this.getTokenByScopes(resource);
        return token == null ? null : token.getToken();
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
        this.application = null;
        this.tenantId = null;
        this.subscriptionId = null;
        this.resourceTokens.clear();
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Nullable
    public String getClientCertificateValue() {
        return this.clientCertificateValue;
    }

    public void setClientCertificateValue(String clientCertificateValue) {
        this.clientCertificateValue = clientCertificateValue;
    }

    @Nullable
    public String getClientCertificatePath() {
        return this.clientCertificatePath;
    }

    public void setClientCertificatePath(String clientCertificatePath) {
        this.clientCertificatePath = clientCertificatePath;
    }

    public String getUserName() {
        return super.getUserName();
    }

    public String getUserPassword() {
        return super.getUserPassword();
    }

    public String getAzureUserId() {
        return this.azureUserId;
    }

    public void setAzureUserId(String azureUserId) {
        this.azureUserId = azureUserId;
    }

    @NotNull
    private synchronized AzureProfile acquireProfile(@NotNull DBRProgressMonitor monitor, @NotNull TokenCredential credential) {
        if (this.tenantId == null || this.subscriptionId == null) {
            SubscriptionManager manager = SubscriptionManager.authenticate((TokenCredential)credential, (AzureProfile)new AzureProfile(AzureEnvironment.AZURE));
            try {
                monitor.beginTask("Acquire Azure profile", 2);
                monitor.subTask("Retrieve information about subscriptions");
                this.subscriptionId = ((Subscription)manager.subscriptions().list().stream().findFirst().orElseThrow(() -> new IllegalStateException("No Azure subscriptions found. Check user permissions."))).subscriptionId();
                monitor.worked(1);
                if (this.tenantId == null) {
                    monitor.subTask("Retrieve information about tenants");
                    this.tenantId = ((TenantIdDescription)manager.tenants().list().stream().findFirst().orElseThrow(() -> new IllegalStateException("No Azure tenants found in account. Check user permissions."))).tenantId();
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }
        return new AzureProfile(this.tenantId, this.subscriptionId, AzureEnvironment.AZURE);
    }

    public static interface AzureScopes {
        public Set<String> getScopes();
    }

    public static enum Resource implements AzureScopes
    {
        MANAGEMENT("https://management.azure.com//.default"),
        DATABASE("https://database.windows.net//.default"),
        GRAPH("https://graph.microsoft.com//.default");

        private final Set<String> scopes;

        private Resource(String ... scopes) {
            this.scopes = Set.of(scopes);
        }

        @Override
        public Set<String> getScopes() {
            return this.scopes;
        }
    }
}

