/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import java.io.IOException;

class UTF8State {
    int current = 0;
    int len;
    char second_surrogate;
    boolean surrogate_pair = false;
    byte[] barr;

    UTF8State(byte[] barr, int len) {
        this.barr = barr;
        this.len = len;
    }

    boolean more() {
        return this.current < this.len || this.surrogate_pair;
    }

    private int nextByte() throws IOException {
        if (this.current < this.len) {
            return this.barr[this.current++] & 0xFF;
        }
        throw new IOException("invalid UTF8");
    }

    private char validate(int n, int c) throws IOException {
        if (c < 2048) {
            if (n != 2) {
                throw new IOException("Invalid UTF8");
            }
        } else if (c < 65536) {
            if (c >= 55296 && c < 57344 || c == 65534 || c == 65535 || n != 3) {
                throw new IOException("Invalid UTF8");
            }
        } else if (c < 0x110000) {
            if (n != 4) {
                throw new IOException("Invalid UTF8");
            }
        } else {
            throw new IOException("Invalid UTF8");
        }
        if (c > 65535) {
            this.surrogate_pair = true;
            this.second_surrogate = (char)(0xDC00 | (c -= 65536) & 0x3FF);
            return (char)(0xD800 | c >> 10 & 0x3FF);
        }
        return (char)c;
    }

    private char nByteChar(int n, int c) throws IOException {
        for (int ii = 1; ii < n; ++ii) {
            int b = this.nextByte();
            if (b < 128 || b > 191) {
                throw new IOException("Invalid UTF8");
            }
            c = c << 6 | b & 0x3F;
        }
        return this.validate(n, c);
    }

    char nextChar() throws IOException {
        if (this.surrogate_pair) {
            this.surrogate_pair = false;
            return this.second_surrogate;
        }
        int b = this.nextByte();
        if (b < 128) {
            return (char)b;
        }
        if (b < 194) {
            throw new IOException("Invalid UTF8");
        }
        if (b < 224) {
            return this.nByteChar(2, b & 0x1F);
        }
        if (b < 240) {
            return this.nByteChar(3, b & 0xF);
        }
        if (b < 245) {
            return this.nByteChar(4, b & 7);
        }
        throw new IOException("Invalid UTF8");
    }
}

