/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.ClobCacheFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;

public class ClobCache {
    int maxentries;
    int pagesize;
    ClobCacheFile file;
    LinkedHashMap<Long, char[]> hash;

    public ClobCache(int pagesize) throws IOException {
        this._init(pagesize, 16);
    }

    public ClobCache(int pagesize, int maxentries) throws IOException {
        this._init(pagesize, maxentries);
    }

    private void _init(int pagesize, int maxentries) throws IOException {
        this.pagesize = pagesize;
        this.maxentries = maxentries;
        this.hash = new LinkedHashMap();
        this.file = new ClobCacheFile(pagesize);
    }

    private char[] createNewPage() {
        char[] page = new char[this.pagesize];
        Arrays.fill(page, ' ');
        return page;
    }

    private void makeRoom() throws IOException {
        if (this.hash.size() == this.maxentries) {
            long pageno = this.hash.keySet().iterator().next();
            char[] data = (char[])this.hash.remove(pageno);
            this.file.write(pageno, data);
        }
    }

    private void cacheResult(long pageno, char[] page) throws IOException {
        this.makeRoom();
        this.hash.put(pageno, page);
    }

    public void close() {
        this.file.close();
        this.file = null;
        this.hash = null;
    }

    public char[] readPage(long pageno) throws IOException {
        char[] result = this.hash.get(pageno);
        if (result != null) {
            this.hash.remove(pageno);
        } else {
            result = this.file.read(pageno);
        }
        this.cacheResult(pageno, result);
        return result;
    }

    public void writePage(long pageno, char[] data) throws IOException {
        if (this.hash.get(pageno) != null) {
            this.hash.remove(pageno);
        }
        this.cacheResult(pageno, data);
    }

    public void truncate(long pageno) throws IOException {
        this.file.truncate(pageno);
        for (long pno : this.hash.keySet()) {
            if (pno < pageno) continue;
            this.hash.remove(pno);
        }
    }

    public boolean exists(long pageno) {
        if (this.hash.containsKey(pageno)) {
            return true;
        }
        return this.file.exists(pageno);
    }
}

