/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

class BlobCacheFile {
    int pagesize;
    long filesize = 0L;
    File tmpfile = null;
    RandomAccessFile rfile = null;

    BlobCacheFile(int pagesize) throws IOException {
        this.pagesize = pagesize;
    }

    void close() {
        try {
            if (this.rfile != null) {
                this.rfile.close();
                this.rfile = null;
            }
            if (this.tmpfile != null && !this.tmpfile.delete()) {
                System.err.println("Failed to delete temporary file: " + this.tmpfile.getName());
                this.tmpfile = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void openFile() throws IOException {
        try {
            this.tmpfile = File.createTempFile("rcch", null);
            this.tmpfile.deleteOnExit();
            this.rfile = new RandomAccessFile(this.tmpfile, "rw");
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
    }

    void write(long pageno, byte[] data) throws IOException {
        long offset = pageno * (long)this.pagesize;
        if (this.rfile == null) {
            this.openFile();
        }
        this.rfile.seek(offset);
        this.rfile.write(data);
        if (this.filesize < (offset += pageno)) {
            this.filesize = offset;
        }
    }

    byte[] read(long pageno) throws IOException {
        long offset = pageno * (long)this.pagesize;
        byte[] barr = new byte[this.pagesize];
        if (offset >= this.filesize) {
            Arrays.fill(barr, 0, this.pagesize, (byte)0);
        } else {
            this.rfile.seek(offset);
            int len = this.rfile.read(barr);
            if (len > 0 && len < this.pagesize) {
                throw new IOException();
            }
        }
        return barr;
    }

    void truncate(long pageno) throws IOException {
        if (this.rfile != null) {
            this.rfile.setLength(pageno * (long)this.pagesize);
        }
    }

    boolean exists(long pageno) {
        long offset = pageno * (long)this.pagesize;
        return pageno < this.filesize;
    }
}

