/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.DateTimeConverter;
import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class RSQLTimestampParam
extends RSQLParam {
    int[] ts;
    Timestamp timestamp;

    public RSQLTimestampParam() {
        super(772, (short)3);
    }

    public RSQLTimestampParam(Timestamp ts) throws SQLException {
        super(772);
        this.timestamp = (Timestamp)ts.clone();
        try {
            this.ts = DateTimeConverter.RTimestampFromTimestamp(Calendar.getInstance(TimeZone.getDefault()), ts);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLTimestampParam(short t, Timestamp ts) throws SQLException {
        super(772, t);
        this.timestamp = (Timestamp)ts.clone();
        try {
            this.ts = DateTimeConverter.RTimestampFromTimestamp(Calendar.getInstance(TimeZone.getDefault()), ts);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLTimestampParam(Timestamp ts, Calendar cal) throws SQLException {
        super(772);
        this.timestamp = (Timestamp)ts.clone();
        try {
            this.ts = DateTimeConverter.RTimestampFromTimestamp(cal, ts);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLTimestampParam(short t, Timestamp ts, Calendar cal) throws SQLException {
        super(772, t);
        this.timestamp = (Timestamp)ts.clone();
        try {
            this.ts = DateTimeConverter.RTimestampFromTimestamp(cal, ts);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public String getString() throws RDMException {
        return this.timestamp.toString();
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromTimestamp(this.ts);
    }

    @Override
    public int getDate() throws RDMException {
        return this.ts[0];
    }

    @Override
    public int getTime() throws RDMException {
        return this.ts[1];
    }

    @Override
    public int[] getTimestamp() throws RDMException {
        return (int[])this.ts.clone();
    }

    @Override
    public void setTimestamp(int[] ts) throws RDMException {
        this.ts = (int[])ts.clone();
    }

    @Override
    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(772);
        rpc.sendInt32(this.ts[0]);
        rpc.sendInt32(this.ts[1]);
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.ts[0] = rpc.getInt32();
        this.ts[1] = rpc.getInt32();
    }
}

