/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.jdbc.RDMJDBCURL;
import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLError;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.sql.RSQLTCPStatement;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMHostInfo;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLWarning;
import java.util.Iterator;
import java.util.LinkedList;

public class RSQLTCP
implements RSQL {
    private long handle = -1L;
    private RPC rpc;
    private SQLWarning warnings;
    private int errorCode;
    private String errorMsgInfo;

    public RSQLTCP(RDMJDBCURL url, RDMHostInfo hostinfo) throws RDMException {
        try {
            this.rpc = new RPC(hostinfo);
        }
        catch (UnknownHostException e) {
            throw new RDMUnexpectedException("ERROR: failed to connect to rsqlserver (" + hostinfo.host + ":" + hostinfo.port + ")");
        }
        catch (IOException e) {
            throw new RDMSQLException(-18004);
        }
        this.warnings = null;
        int ret = this.rdmAllocConn();
        if (ret != 0) {
            if (ret == -21000) {
                throw new RDMSQLException(-15176);
            }
            throw new RDMSQLException(this, "rdmAllocConn");
        }
        ret = this._setOption("defaultopenmode", url.getOpenMode());
        if (ret != 0) {
            this.rdmSqlFree();
            this.handle = -1L;
            throw new RDMSQLException(this, "rdmSqlSetOption()");
        }
        LinkedList<String> dblist = url.getDbList();
        String dbnamelist = dblist.size() > 0 ? this.createDbNameList(dblist) : "";
        ret = this.rdmSqlConnect(dbnamelist);
        if (ret != 0) {
            this.rdmSqlFree();
            this.handle = -1L;
            throw new RDMSQLException(this, "rdmSqlConnect()");
        }
    }

    private String createDbNameList(LinkedList<String> dblist) {
        boolean first = true;
        StringBuilder str = new StringBuilder();
        Iterator iter = dblist.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                str.append(";");
            }
            str.append((String)iter.next());
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmAllocConn() throws RDMException {
        int err;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL AllocConnect");
                this.rpc.sendString("");
                this.rpc.flush();
                err = this.rpc.getInt32();
                if (err == 0) {
                    this.handle = this.rpc.getInt64();
                }
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmSqlFree() throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL FreeConn");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                return this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmSqlConnect(String dbName) throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL ConnectJNI");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendString(dbName);
                this.rpc.flush();
                return this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmSqlDisconnect() throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL Disconnect");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                return this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    protected RPC getRPC() {
        return this.rpc;
    }

    public long getConnHandle() {
        return this.handle;
    }

    @Override
    public void free() {
        if (this.handle != -1L) {
            try {
                this.rdmSqlDisconnect();
                this.rdmSqlFree();
            }
            catch (RDMException rDMException) {
                // empty catch block
            }
            this.handle = -1L;
        }
    }

    @Override
    public RSQLStatement createStatement(boolean cursorScrollable, boolean cursorUpdateable) throws RDMException {
        return new RSQLTCPStatement(this, cursorScrollable, cursorUpdateable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOptions(String options) throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL SetOptions");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendString(options);
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        if (ret != 0) {
            throw new RDMSQLException(this, "rdm_sqlSetOptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _setOption(String keyword, String strValue) throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL SetOption");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendString(keyword);
                this.rpc.sendString(strValue);
                this.rpc.flush();
                return this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    @Override
    public void setOption(String keyword, String strValue) throws RDMException {
        int ret = this._setOption(keyword, strValue);
        if (ret != 0) {
            throw new RDMSQLException(this, "rdmSqlSetOption(" + keyword + ")");
        }
    }

    @Override
    public void setOption(String keyword, boolean bValue) throws RDMException {
        String strValue = bValue ? "true" : "false";
        int ret = this._setOption(keyword, strValue);
        if (ret != 0) {
            throw new RDMSQLException(this, "rdmSqlSetOption(" + keyword + ")");
        }
    }

    @Override
    public void setOption(String keyword, int intValue) throws RDMException {
        String strValue = String.format("%d", intValue);
        int ret = this._setOption(keyword, strValue);
        if (ret != 0) {
            throw new RDMSQLException(this, "rdmSqlSetOption(" + keyword + ")");
        }
    }

    public void setOption(String keyword, double lfValue) throws RDMException {
        String strValue = String.format("%lf", lfValue);
        int ret = this._setOption(keyword, strValue);
        if (ret != 0) {
            throw new RDMSQLException(this, "rdmSqlSetOption(" + keyword + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLockTimeout(int timeout) throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL SetTimeout");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt32(timeout);
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        if (ret != 0) {
            throw new RDMSQLException(this, "rdmSqlSetTimeout()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transStatus() throws RDMException {
        short transStatus;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL TransStatus");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                if (this.rpc.getInt32() != 0) {
                    throw new RDMSQLException(this, "rsqlTransStatus()");
                }
                transStatus = this.rpc.getInt16();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        return transStatus != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL End");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        if (ret != 0 && ret != -10007) {
            throw new RDMSQLException(this, "rdm_sqlEnd()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL EndRollbackEx");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendString("");
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        if (ret != 0 && ret != -10007) {
            throw new RDMSQLException(this, "rdm_sqlEndRollbackEx()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSavepoint(String id) throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL Savepoint");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendString(id);
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        if (ret != 0 && ret != -10007) {
            throw new RDMSQLException(this, "rdm_sqlSavepoint()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackToSavepoint(String id) throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL EndRollbackEx");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendString(id);
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        if (ret != 0 && ret != -10007) {
            throw new RDMSQLException(this, "rdm_sqlEndRollbackEx()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(String id) throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL Release");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendString(id);
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        if (ret != 0 && ret != -10007) {
            throw new RDMSQLException(this, "rdm_sqlRelease()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RSQLError getErrorMsg(int err) throws RDMException {
        String errMsg;
        String SQLState;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetErrorMsg");
                this.rpc.sendInt32(err);
                this.rpc.flush();
                SQLState = this.rpc.getString();
                if (SQLState == null) {
                    return null;
                }
                errMsg = this.rpc.getString();
                if (errMsg == null) {
                    return null;
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return new RSQLError("", SQLState, errMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastError() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        try {
            int ret;
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetLastError");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt64(1024L);
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
            if (ret != 0 && ret != 10012) {
                throw new RDMSQLException(ret);
            }
            this.errorCode = this.rpc.getInt32();
            this.errorMsgInfo = this.rpc.getString();
        }
        catch (IOException e) {
            return -15045;
        }
        return this.errorCode;
    }

    @Override
    public int getErrorCode() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return this.errorCode;
    }

    @Override
    public String getErrorInfoMsg() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return this.errorMsgInfo;
    }

    @Override
    public void clearWarnings() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.warnings = null;
    }

    @Override
    public SQLWarning getWarnings() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return this.warnings;
    }
}

