/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLDesc;
import com.raima.rdm.sql.RSQLError;
import com.raima.rdm.sql.RSQLJNI;
import com.raima.rdm.sql.RSQLJNIDesc;
import com.raima.rdm.sql.RSQLJNIRowArray;
import com.raima.rdm.sql.RSQLJNIRowSet;
import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.sql.RSQLParamDesc;
import com.raima.rdm.sql.RSQLRowArray;
import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMNoMoreDataException;
import java.lang.reflect.Array;
import java.sql.SQLWarning;

public class RSQLJNIStatement
implements RSQLStatement {
    private long handle;
    private SQLWarning warnings;
    private short parm;
    private short next_parm;
    private int type;
    private int numparms;
    private int numcols;
    private long numrows;
    private int maxFieldSize;
    private RSQL rsql;
    private short needKeys;
    private int[] columnIndexes;
    private String[] columnNames;
    private int generatedKeyId;
    private String generatedKeyName;
    private long[] generatedKeys;
    private boolean cursorScrollable;
    private boolean cursorUpdateable;
    private int paramMode;
    private int paramType;
    private int paramLen;
    private boolean paramNullable;
    private String paramName;
    private short cursorStatus;
    private int errorCode;
    private String errorInfoMsg;

    private native int rdmSqlAllocStmt(long var1, boolean var3, boolean var4);

    private native void rdmStmtClose(long var1);

    private native void rdmStmtFree(long var1);

    private native int rdmStmtGetCursorStatus(long var1);

    private native int rdmStmtGetLastError(long var1);

    private native int rdmStmtGetParamDescr(long var1, short var3);

    private native int rdmStmtGetParamName(long var1, short var3);

    private native int rdmStmtGetRowCount(long var1);

    private native int rdmStmtMoreResults(long var1);

    private native int rdmStmtPrepare(long var1, String var3);

    private native int rdmStmtExecDirect(long var1, String var3, short var4);

    private native int rdmStmtExecute(long var1, RSQLParam[] var3, short var4);

    private native int rdmStmtParamData(long var1);

    private native int rdmStmtPutData(long var1, int var3, byte[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSQLJNIStatement(RSQLJNI sql, boolean cursorScrollable, boolean cursorUpdateable) throws RDMException {
        try {
            int ret;
            if (sql == null) {
                throw new RDMSQLException();
            }
            this.rsql = sql;
            this.cursorScrollable = cursorScrollable;
            this.cursorUpdateable = cursorUpdateable;
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmSqlAllocStmt(sql.getConnHandle(), cursorScrollable, cursorUpdateable);
            }
            if (ret != 0) {
                throw new RDMSQLException(sql, "rdmsqlAllocStmt()");
            }
            this.warnings = null;
            this.numparms = 0;
            this.numcols = 0;
            this.numrows = 0L;
            this.generatedKeys = null;
            this.generatedKeyName = null;
            this.maxFieldSize = 0;
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    protected void setStmtHandle(long stmt_handle) {
        this.handle = stmt_handle;
    }

    protected RSQL getRsql() {
        return this.rsql;
    }

    protected void setType(short type) {
        this.type = type;
    }

    protected void setNumParms(short numparms) {
        this.numparms = numparms;
    }

    protected void setNumCols(short numcols) {
        this.numcols = numcols;
    }

    protected void setNumRows(long numrows) {
        this.numrows = numrows;
    }

    private boolean validateColumnIndex(int columnIndex) {
        boolean ret = false;
        if (this.columnIndexes == null) {
            ret = true;
        } else {
            for (int ii : this.columnIndexes) {
                if (ii != columnIndex) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private boolean validateColumnName(String columnName) {
        boolean ret = false;
        if (this.columnNames == null) {
            ret = true;
        } else {
            for (String s : this.columnNames) {
                if (!s.equals(columnName)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    protected void setGeneratedKeys(int columnIndex, String columnName, long[] generatedKeys) {
        if (this.validateColumnIndex(columnIndex) && this.validateColumnName(columnName)) {
            this.generatedKeyId = columnIndex;
            this.generatedKeyName = columnName;
            this.generatedKeys = generatedKeys;
        }
    }

    protected void setNextParam(short next_parm) {
        this.next_parm = next_parm;
    }

    protected long getStmtHandle() {
        return this.handle;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getNumParms() {
        return this.numparms;
    }

    @Override
    public int getNumCols() {
        return this.numcols;
    }

    @Override
    public long getNumRows() {
        return this.numrows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws RDMException {
        block5: {
            try {
                if (this.handle == -1L) break block5;
                RSQL rSQL = this.rsql;
                synchronized (rSQL) {
                    this.rdmStmtClose(this.handle);
                }
            }
            catch (Error e) {
                throw this.handleJNIError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        block5: {
            try {
                if (this.handle == -1L) break block5;
                RSQL rSQL = this.rsql;
                synchronized (rSQL) {
                    this.rdmStmtFree(this.handle);
                }
                this.handle = -1L;
            }
            catch (Error e) {
                this.handleJNIError(e);
            }
        }
    }

    protected void finalize() {
        this.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execDirect(String sql, int autoGeneratedKeys) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            this.generatedKeys = null;
            this.generatedKeyName = null;
            this.initGeneratedKeyInfo(autoGeneratedKeys);
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtExecDirect(this.handle, sql, this.needKeys);
            }
            if (ret == 10012) {
                this.addWarning(new SQLWarning("truncation of a parameter"));
            } else if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtExecDirect(" + sql + ")");
            }
            rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtGetRowCount(this.handle);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtGetRowCount()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execDirect(String sql, int[] columnIndexes) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            this.generatedKeys = null;
            this.generatedKeyName = null;
            this.initGeneratedKeyInfo(columnIndexes);
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtExecDirect(this.handle, sql, this.needKeys);
            }
            if (ret == 10012) {
                this.addWarning(new SQLWarning("truncation of a parameter"));
            } else if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtExecDirect(" + sql + ")");
            }
            rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtGetRowCount(this.handle);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtGetRowCount()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execDirect(String sql, String[] columnNames) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            this.generatedKeys = null;
            this.generatedKeyName = null;
            this.initGeneratedKeyInfo(columnNames);
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtExecDirect(this.handle, sql, this.needKeys);
            }
            if (ret == 10012) {
                this.addWarning(new SQLWarning("truncation of a parameter"));
            } else if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtExecDirect(" + sql + ")");
            }
            rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtGetRowCount(this.handle);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtGetRowCount()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    private void initGeneratedKeyInfo(int autoGeneratedKeys) {
        this.needKeys = autoGeneratedKeys == 1 ? (short)1 : 0;
        this.columnIndexes = null;
        this.columnNames = null;
    }

    private void initGeneratedKeyInfo(int[] columnIndexes) {
        this.needKeys = columnIndexes != null ? (short)1 : 0;
        this.columnIndexes = columnIndexes;
        this.columnNames = null;
    }

    private void initGeneratedKeyInfo(String[] columnNames) {
        this.needKeys = columnNames != null ? (short)1 : 0;
        this.columnIndexes = null;
        this.columnNames = columnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String sql, int autoGeneratedKeys) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            this.generatedKeys = null;
            this.generatedKeyName = null;
            this.initGeneratedKeyInfo(autoGeneratedKeys);
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtPrepare(this.handle, sql);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtPrepare(" + sql + ")");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String sql, int[] columnIndexes) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            this.generatedKeys = null;
            this.generatedKeyName = null;
            this.initGeneratedKeyInfo(columnIndexes);
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtPrepare(this.handle, sql);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtPrepare(" + sql + ")");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String sql, String[] columnNames) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            this.generatedKeys = null;
            this.generatedKeyName = null;
            this.initGeneratedKeyInfo(columnNames);
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtPrepare(this.handle, sql);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtPrepare(" + sql + ")");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putData(int type, byte[] barr) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtPutData(this.handle, type, barr);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtPutData()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RSQLParam[] params) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtExecute(this.handle, params, this.needKeys);
            }
            if (ret == 10012) {
                this.addWarning(new SQLWarning("truncation of a parameter"));
            } else if (ret != 0 && ret != 10008) {
                throw new RDMSQLException(this, "rdmStmtExecute()");
            }
            rSQL = this.rsql;
            synchronized (rSQL) {
                while (ret == 10008) {
                    while ((ret = this.rdmStmtParamData(this.handle)) == 10008) {
                        params[this.next_parm - 1].sendDataAtExec(this);
                    }
                }
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtParamData()");
            }
            rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtGetRowCount(this.handle);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtGetRowCount()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    @Override
    public RSQLRowArray fetchAbsolute(int rowNumber, int fetchSize) throws RDMException {
        RSQLJNIRowArray rowarray = null;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.warnings = null;
        try {
            rowarray = new RSQLJNIRowArray(this, 4, rowNumber, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchFirst(int fetchSize) throws RDMException {
        RSQLJNIRowArray rowarray = null;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.warnings = null;
        try {
            rowarray = new RSQLJNIRowArray(this, 2, fetchSize, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchLast() throws RDMException {
        RSQLJNIRowArray rowarray = null;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.warnings = null;
        try {
            rowarray = new RSQLJNIRowArray(this, 3, 0, 1, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchNext(int fetchSize) throws RDMException {
        RSQLJNIRowArray rowarray = null;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.warnings = null;
        try {
            rowarray = new RSQLJNIRowArray(this, 0, 0, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchPrior(int fetchSize) throws RDMException {
        RSQLJNIRowArray rowarray = null;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.warnings = null;
        try {
            rowarray = new RSQLJNIRowArray(this, 1, 0, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchRelative(int rowNumber, int fetchSize) throws RDMException {
        RSQLJNIRowArray rowarray = null;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.warnings = null;
        try {
            rowarray = new RSQLJNIRowArray(this, 5, rowNumber, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getCursorStatus() throws RDMException {
        int ret;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        RSQL rSQL = this.rsql;
        synchronized (rSQL) {
            ret = this.rdmStmtGetCursorStatus(this.handle);
        }
        if (ret != 0) {
            throw new RDMSQLException(this, "rdmStmtGetCursorStatus()");
        }
        return this.cursorStatus;
    }

    @Override
    public int getNumGeneratedKeys() {
        int numKeys = 0;
        if (this.generatedKeys != null) {
            numKeys = Array.getLength(this.generatedKeys);
        }
        return numKeys;
    }

    @Override
    public RSQLRowSet getGeneratedKey(int row) throws RDMException {
        RSQLJNIRowSet rs = null;
        int numKeys = 0;
        if (this.generatedKeys != null) {
            numKeys = Array.getLength(this.generatedKeys);
        }
        if (row < numKeys) {
            rs = new RSQLJNIRowSet(this, this.generatedKeys[row]);
        }
        return rs;
    }

    @Override
    public String getGeneratedKeyName() {
        return this.generatedKeyName;
    }

    @Override
    public RSQLDesc describeCol(int col) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return new RSQLJNIDesc(this, col);
    }

    public void setParamMode(int mode) {
        this.paramMode = mode;
    }

    public void setParamType(int type) {
        this.paramType = type;
    }

    public void setParamLen(int len) {
        this.paramLen = len;
    }

    public void setParamNullable(boolean nullable) {
        this.paramNullable = nullable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RSQLParamDesc describeParam(int param) throws RDMException {
        int err;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        RSQL rSQL = this.rsql;
        synchronized (rSQL) {
            err = this.rdmStmtGetParamDescr(this.handle, (short)param);
        }
        if (err != 0) {
            throw new RDMSQLException(this, "rdmStmtGetParamDescr()");
        }
        return new RSQLParamDesc(this.paramType, this.paramMode, this.paramLen, this.paramNullable);
    }

    public void setParamName(String name) {
        this.paramName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParamName(int param) throws RDMException {
        int err;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        RSQL rSQL = this.rsql;
        synchronized (rSQL) {
            err = this.rdmStmtGetParamName(this.handle, (short)param);
        }
        if (err != 0) {
            throw new RDMSQLException(this, "rdmStmtGetParamName()");
        }
        return this.paramName;
    }

    @Override
    public String errorInfo() throws RDMException {
        String str = null;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return str;
    }

    @Override
    public String getCursorName() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return null;
    }

    @Override
    public void setCursorName(String name) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws RDMException {
        int ret;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        RSQL rSQL = this.rsql;
        synchronized (rSQL) {
            ret = this.rdmStmtMoreResults(this.handle);
        }
        if (ret != 0 && ret != 10009) {
            throw new RDMSQLException(this, "rdmStmtMoreResults()");
        }
        return ret == 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    protected void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public int seqno() throws RDMException {
        int seq = 0;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return seq;
    }

    @Override
    public RSQLError getErrorMsg(int errno) throws RDMException {
        return this.rsql.getErrorMsg(errno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getErrorInfo() throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQL rSQL = this.rsql;
            synchronized (rSQL) {
                ret = this.rdmStmtGetLastError(this.handle);
            }
            if (ret != 0 && ret != 10012) {
                throw new RDMSQLException(ret);
            }
            return this.errorCode;
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    protected void setCursorStatus(short cursorStatus) {
        this.cursorStatus = cursorStatus;
    }

    protected void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String getErrorInfoMsg() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return this.errorInfoMsg;
    }

    protected void setErrorInfoMsg(String errorInfoMsg) {
        this.errorInfoMsg = errorInfoMsg;
    }

    private RDMException handleJNIError(Error e) {
        e.printStackTrace(System.err);
        return new RDMSQLException();
    }
}

