/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLBinaryColumn;
import com.raima.rdm.sql.RSQLBlobColumn;
import com.raima.rdm.sql.RSQLBoolColumn;
import com.raima.rdm.sql.RSQLByteColumn;
import com.raima.rdm.sql.RSQLClobColumn;
import com.raima.rdm.sql.RSQLColumn;
import com.raima.rdm.sql.RSQLDateColumn;
import com.raima.rdm.sql.RSQLDecimalColumn;
import com.raima.rdm.sql.RSQLDoubleColumn;
import com.raima.rdm.sql.RSQLFloatColumn;
import com.raima.rdm.sql.RSQLGuidColumn;
import com.raima.rdm.sql.RSQLIntColumn;
import com.raima.rdm.sql.RSQLJNIStatement;
import com.raima.rdm.sql.RSQLLongColumn;
import com.raima.rdm.sql.RSQLNClobColumn;
import com.raima.rdm.sql.RSQLNullColumn;
import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.sql.RSQLShortColumn;
import com.raima.rdm.sql.RSQLStringColumn;
import com.raima.rdm.sql.RSQLTimeColumn;
import com.raima.rdm.sql.RSQLTimestampColumn;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMInvalidColumnException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;

public class RSQLJNIRowSet
implements RSQLRowSet {
    int numcols;
    RSQLColumn[] columns;
    RSQLJNIStatement stmt;
    short uno;
    long objId;

    private native int rdmStmtGetData(long var1, short var3, short var4, long var5, byte[] var7);

    public RSQLJNIRowSet(RSQLJNIStatement stmt, int index, short uno, long objId) throws RDMException {
        try {
            if (stmt == null) {
                throw new RDMSQLException();
            }
            this.stmt = stmt;
            this.uno = uno;
            this.objId = objId;
            this.numcols = stmt.getNumCols();
            this.columns = new RSQLColumn[stmt.getNumCols()];
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    public RSQLJNIRowSet(RSQLJNIStatement stmt, long generatedKey) throws RDMException {
        try {
            if (stmt == null) {
                throw new RDMSQLException();
            }
            this.stmt = stmt;
            this.uno = (short)-1;
            this.objId = 0L;
            this.numcols = 1;
            this.columns = new RSQLColumn[this.numcols];
            this.setLong(0, generatedKey);
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getData(int col, byte[] bytes) throws RDMException {
        try {
            RSQL rSQL = this.stmt.getRsql();
            synchronized (rSQL) {
                return this.rdmStmtGetData(this.stmt.getStmtHandle(), (short)col, this.uno, this.objId, bytes);
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    @Override
    public int getNumCols() {
        return this.numcols;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public boolean isNull(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].isNull();
    }

    private void validateCol(int col) throws RDMException {
        if (col < 1 || col > this.numcols) {
            throw new RDMInvalidColumnException();
        }
    }

    @Override
    public InputStream getAsciiStream(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getAsciiStream();
    }

    @Override
    public InputStream getBinaryStream(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getBinaryStream();
    }

    @Override
    public boolean getBoolean(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getBoolean();
    }

    @Override
    public byte getByte(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getByte();
    }

    @Override
    public byte[] getBytes(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getBytes();
    }

    @Override
    public Reader getCharacterStream(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getCharacterStream();
    }

    @Override
    public short getShort(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getShort();
    }

    @Override
    public int getInt(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getInt();
    }

    @Override
    public long getLong(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getLong();
    }

    @Override
    public float getFloat(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getFloat();
    }

    @Override
    public double getDouble(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getBigDecimal();
    }

    @Override
    public Date getDate(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getDate();
    }

    @Override
    public Date getDate(int col, Calendar cal) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getDate(cal);
    }

    @Override
    public Time getTime(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getTime();
    }

    @Override
    public Time getTime(int col, Calendar cal) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getTimestamp();
    }

    @Override
    public Timestamp getTimestamp(int col, Calendar cal) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getTimestamp(cal);
    }

    @Override
    public UUID getUUID(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getUUID();
    }

    @Override
    public String getString(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getString();
    }

    @Override
    public Object getObject(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getObject();
    }

    public void setNull(int col) {
        this.columns[col] = new RSQLNullColumn();
    }

    public void setString(int col, String str, int maxFieldSize) {
        this.columns[col] = new RSQLStringColumn(str, maxFieldSize);
    }

    public void setBytes(int col, byte[] b, int maxFieldSize) {
        this.columns[col] = new RSQLBinaryColumn(b, maxFieldSize);
    }

    public void setBool(int col, boolean b) {
        this.columns[col] = new RSQLBoolColumn(b);
    }

    public void setByte(int col, byte b) {
        this.columns[col] = new RSQLByteColumn(b);
    }

    public void setShort(int col, short s) {
        this.columns[col] = new RSQLShortColumn(s);
    }

    public void setInt(int col, int i) {
        this.columns[col] = new RSQLIntColumn(i);
    }

    public void setLong(int col, long l) {
        this.columns[col] = new RSQLLongColumn(l);
    }

    public void setFloat(int col, float f) {
        this.columns[col] = new RSQLFloatColumn(f);
    }

    public void setDouble(int col, double d) {
        this.columns[col] = new RSQLDoubleColumn(d);
    }

    public void setDate(int col, int i) {
        this.columns[col] = new RSQLDateColumn(i);
    }

    public void setTime(int col, int i) {
        this.columns[col] = new RSQLTimeColumn(i);
    }

    public void setTimestamp(int col, int[] ts) {
        this.columns[col] = new RSQLTimestampColumn(ts);
    }

    public void setDecimal(int col, String str) {
        this.columns[col] = new RSQLDecimalColumn(new BigDecimal(str));
    }

    public void setGuid(int col, String str) {
        this.columns[col] = new RSQLGuidColumn(UUID.fromString(str));
    }

    public void setClob(int col, int maxFieldSize) {
        this.columns[col] = new RSQLClobColumn(this, col + 1, maxFieldSize);
    }

    public void setNClob(int col, int maxFieldSize) {
        this.columns[col] = new RSQLNClobColumn(this, col + 1, maxFieldSize);
    }

    protected void setBlob(int col, int maxFieldSize) {
        this.columns[col] = new RSQLBlobColumn(this, col + 1, maxFieldSize);
    }

    private RDMException handleJNIError(Error e) {
        e.printStackTrace(System.err);
        return new RDMSQLException();
    }
}

