/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLError;
import com.raima.rdm.sql.RSQLErrors;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.RDMException;
import java.sql.SQLException;

public class RDMSQLException
extends RDMException {
    private static final long serialVersionUID = 1L;
    private RSQLError error;
    private String message;
    private int vendorCode;

    public RDMSQLException() {
        this.message = "not connected";
        this.error = RSQLErrors.getNotConnectedError();
    }

    public RDMSQLException(int err) {
        this.error = RSQLErrors.getError(err);
        this.message = this.error.getErrString();
        this.vendorCode = err;
    }

    public RDMSQLException(RSQL rsql, String func) {
        try {
            this.vendorCode = rsql.getLastError();
            String errMsg = rsql.getErrorInfoMsg();
            this.error = RSQLErrors.getError(rsql, this.vendorCode);
            this.message = func + " returned " + this.vendorCode + ": " + errMsg;
        }
        catch (RDMException e) {
            this.message = "not connected";
            this.error = RSQLErrors.getNotConnectedError();
        }
    }

    public RDMSQLException(RSQLStatement rsqlStmt, String func) {
        super("");
        try {
            int err = rsqlStmt.getErrorInfo();
            String errMsg = rsqlStmt.getErrorInfoMsg();
            this.error = RSQLErrors.getError(rsqlStmt, err);
            this.message = func + " returned " + err + ": " + errMsg;
        }
        catch (RDMException e) {
            this.message = "not connected";
            this.error = RSQLErrors.getNotConnectedError();
        }
    }

    @Override
    public SQLException createSQLException() {
        return new SQLException(this.message, this.error.getSQLState(), this.vendorCode);
    }
}

