/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.UTF8;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class NCLOBReader
extends Reader {
    RSQLRowSet rs;
    char[] carr;
    boolean eof;
    int colno;
    int offset;
    int avail;
    int max;
    int charsRead;

    public NCLOBReader(RSQLRowSet rowset, int col, int max) throws RDMException {
        this.rs = rowset;
        this.colno = col;
        this.max = max;
        this.charsRead = 0;
        this.eof = false;
        this.carr = new char[1024];
        this.readNextInternal();
    }

    private void readNextInternal() throws RDMException {
        if (!this.eof) {
            byte[] barr = new byte[1024];
            this.avail = this.rs.getData(this.colno, barr);
            this.offset = 0;
            if (this.avail == 0) {
                this.eof = true;
            } else {
                try {
                    this.carr = UTF8.convertFromUTF8(barr, this.avail).toCharArray();
                    this.avail = this.carr.length;
                    if (this.carr[this.avail - 1] == '\u0000') {
                        --this.avail;
                    }
                }
                catch (IOException e) {
                    throw new RDMUnexpectedException(e.getMessage());
                }
            }
        }
    }

    private void readNext() throws IOException {
        try {
            this.readNextInternal();
        }
        catch (RDMException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.rs != null) {
            this.carr = null;
            this.rs = null;
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        this.validateOpen();
        if (this.offset == this.avail) {
            this.readNext();
        }
        if (this.eof) {
            return -1;
        }
        if (this.max > 0 && this.charsRead == this.max) {
            return -1;
        }
        return this.carr[this.offset++];
    }

    @Override
    public int read(char[] c) throws IOException {
        return this.read(c, 0, c.length);
    }

    @Override
    public int read(char[] c, int off, int len) throws IOException {
        int ii;
        int chars;
        this.validateOpen();
        if (c == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > c.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        for (ii = 0; ii < len; ii += chars) {
            if (this.offset == this.avail) {
                this.readNext();
            }
            if ((chars = Math.min(this.avail - this.offset, len)) == 0 || this.max > 0 && (chars = Math.min(chars, this.max - this.charsRead)) == 0) break;
            for (int jj = 0; jj < chars; ++jj) {
                c[ii + off + jj] = this.carr[this.offset++];
            }
            this.charsRead += chars;
        }
        if (ii == off) {
            return -1;
        }
        return ii - off;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int tmp;
        int count = 0;
        this.validateOpen();
        if (target == null) {
            throw new NullPointerException();
        }
        while ((tmp = this.read()) != -1) {
            target.put((char)tmp);
            ++count;
        }
        return count;
    }

    @Override
    public boolean ready() throws IOException {
        this.validateOpen();
        return true;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        long ii;
        int chars;
        this.validateOpen();
        if (n <= 0L) {
            return 0L;
        }
        for (ii = 0L; ii < n; ii += (long)chars) {
            if (this.offset == this.avail) {
                this.readNext();
            }
            if ((chars = (int)Math.min((long)(this.avail - this.offset), n)) == 0 || this.max > 0 && (chars = Math.min(chars, this.max - this.charsRead)) == 0) break;
            this.offset += chars;
            this.charsRead += chars;
        }
        return ii;
    }

    private void validateOpen() throws IOException {
        if (this.rs == null) {
            throw new IOException("InputStream is closed");
        }
    }
}

