/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.SettingsRow;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMInvalidColumnTypeException;
import com.raima.rdm.util.StringInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

class SettingsResultSet
implements ResultSet,
ResultSetMetaData {
    private boolean closed = false;
    private int row;
    private int fetchsize = 1;
    private SettingsRow[] rows;
    private static final String[] names = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};

    protected SettingsResultSet(SettingsRow[] rows) {
        this.rows = rows;
        this.row = -1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.notSupported();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.validate();
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.notSupported();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.validate(columnName) + 1;
    }

    @Override
    public boolean first() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public Array getArray(int ordinal) throws SQLException {
        this.notSupported(ordinal);
        return null;
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        this.notSupported(columnName);
        return null;
    }

    @Override
    public InputStream getAsciiStream(int ordinal) throws SQLException {
        return this._getAsciiStream(this.validate(ordinal));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this._getAsciiStream(this.validate(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int ordinal) throws SQLException {
        return new BigDecimal(this.getInt(this.validate(ordinal)));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int ordinal, int scale) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return new BigDecimal(this.getInt(this.validate(columnName)));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public InputStream getBinaryStream(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public Blob getBlob(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public boolean getBoolean(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return false;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        this.invalidType(columnName);
        return false;
    }

    @Override
    public byte getByte(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return 0;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        this.invalidType(columnName);
        return 0;
    }

    @Override
    public byte[] getBytes(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public Reader getCharacterStream(int ordinal) throws SQLException {
        return new StringReader(this.getString(ordinal));
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return new StringReader(this.getString(columnName));
    }

    @Override
    public Clob getClob(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.validate();
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public Date getDate(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public Date getDate(int ordinal, Calendar cal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public double getDouble(int ordinal) throws SQLException {
        return this.getInt(ordinal);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getInt(columnName);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.validate();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.validate();
        return this.fetchsize;
    }

    @Override
    public float getFloat(int ordinal) throws SQLException {
        return this.getInt(ordinal);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getInt(columnName);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validate();
        return 2;
    }

    @Override
    public int getInt(int ordinal) throws SQLException {
        return this._getInt(this.validate(ordinal));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this._getInt(this.validate(columnName));
    }

    @Override
    public long getLong(int ordinal) throws SQLException {
        return this.getInt(ordinal);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getInt(columnName);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.validate();
        return this;
    }

    @Override
    public Reader getNCharacterStream(int ordinal) throws SQLException {
        return new StringReader(this.getString(ordinal));
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        return new StringReader(this.getString(columnName));
    }

    @Override
    public NClob getNClob(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public String getNString(int ordinal) throws SQLException {
        return this.getString(ordinal);
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        return this.getString(columnName);
    }

    @Override
    public Object getObject(int ordinal) throws SQLException {
        return this._getObject(this.validate(ordinal));
    }

    @Override
    public <T> T getObject(int ordinal, Class<T> type) throws SQLException {
        this.notSupported();
        return null;
    }

    public Object getObject(int ordinal, Map map) throws SQLException {
        return this._getObject(this.validate(ordinal));
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this._getObject(this.validate(columnName));
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this._getObject(this.validate(columnName));
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public Ref getRef(int ordinal) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        this.validate();
        return this.row + 1;
    }

    @Override
    public RowId getRowId(int ordinal) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public short getShort(int ordinal) throws SQLException {
        return (short)this.getInt(ordinal);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return (short)this.getInt(columnName);
    }

    @Override
    public SQLXML getSQLXML(int ordinal) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.validate();
        return null;
    }

    @Override
    public String getString(int ordinal) throws SQLException {
        return this._getString(this.validate(ordinal));
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this._getString(this.validate(columnName));
    }

    @Override
    public Time getTime(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public Time getTime(int ordinal, Calendar cal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public Timestamp getTimestamp(int ordinal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public Timestamp getTimestamp(int ordinal, Calendar cal) throws SQLException {
        this.invalidType(ordinal);
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.invalidType(columnName);
        return null;
    }

    @Override
    public int getType() throws SQLException {
        this.validate();
        return 1003;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int ordinal) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public URL getURL(int ordinal) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validate();
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        this.notSupported();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.validate();
        return this.row == this.rows.length;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.validate();
        return this.row == -1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.validate();
        return this.row == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.validate();
        return this.row == this.rows.length;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public boolean last() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.notSupported();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.notSupported();
    }

    @Override
    public boolean next() throws SQLException {
        this.validate();
        if (this.row < this.rows.length) {
            ++this.row;
        }
        return this.row < this.rows.length;
    }

    @Override
    public boolean previous() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.validate();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.validateRow();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.validateRow();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.validateRow();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.validate();
        if (direction != 1000) {
            this.notSupported();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.validate();
        this.fetchsize = rows;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLException("not an instance");
        }
        return iface.cast(this);
    }

    @Override
    public void updateArray(int ordinal, Array x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateAsciiStream(int ordinal, InputStream x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateAsciiStream(int ordinal, InputStream x, int length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateAsciiStream(int ordinal, InputStream x, long length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBigDecimal(int ordinal, BigDecimal x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBinaryStream(int ordinal, InputStream x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBinaryStream(int ordinal, InputStream x, int length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBinaryStream(int ordinal, InputStream x, long length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBlob(int ordinal, Blob x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBlob(int ordinal, InputStream x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBlob(int ordinal, InputStream x, long length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBlob(String columnName, InputStream x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBlob(String columnName, InputStream x, long length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBoolean(int ordinal, boolean x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateByte(int ordinal, byte x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateBytes(int ordinal, byte[] x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateCharacterStream(int ordinal, Reader x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateCharacterStream(int ordinal, Reader x, int length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateCharacterStream(int ordinal, Reader x, long length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateClob(int ordinal, Clob x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateClob(int ordinal, Reader x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateClob(int ordinal, Reader x, long length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateClob(String columnName, Reader x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateClob(String columnName, Reader x, long length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateDate(int ordinal, Date x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateDouble(int ordinal, double x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateFloat(int ordinal, float x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateInt(int ordinal, int x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateLong(int ordinal, long x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateNCharacterStream(int ordinal, Reader x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateNCharacterStream(int ordinal, Reader x, long length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateNClob(int ordinal, NClob x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateNClob(int ordinal, Reader x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateNClob(int ordinal, Reader x, long length) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateNClob(String columnName, NClob x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateNClob(String columnName, Reader x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateNClob(String columnName, Reader x, long length) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateNString(int ordinal, String x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateNString(String columnName, String x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateNull(int ordinal) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateObject(int ordinal, Object x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateObject(int ordinal, Object x, int scale) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateRef(int ordinal, Ref x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateRow() throws SQLException {
        this.notSupported();
    }

    @Override
    public void updateRowId(int ordinal, RowId x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateShort(int ordinal, short x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateSQLXML(int ordinal, SQLXML x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateString(int ordinal, String x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateTime(int ordinal, Time x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public void updateTimestamp(int ordinal, Timestamp x) throws SQLException {
        this.notSupported(ordinal);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.notSupported(columnName);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogName(int ordinal) throws SQLException {
        this.validate(ordinal);
        return "";
    }

    @Override
    public String getColumnClassName(int ordinal) throws SQLException {
        return this._getClassName(this.validate(ordinal));
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.validate();
        return 4;
    }

    @Override
    public int getColumnDisplaySize(int ordinal) throws SQLException {
        return this._getPrecision(this.validate(ordinal));
    }

    @Override
    public String getColumnLabel(int ordinal) throws SQLException {
        return names[this.validate(ordinal) - 1];
    }

    @Override
    public String getColumnName(int ordinal) throws SQLException {
        return names[this.validate(ordinal) - 1];
    }

    @Override
    public int getColumnType(int ordinal) throws SQLException {
        return this._getType(this.validate(ordinal));
    }

    @Override
    public String getColumnTypeName(int ordinal) throws SQLException {
        return this._getTypeName(this.validate(ordinal));
    }

    @Override
    public int getPrecision(int ordinal) throws SQLException {
        return this._getPrecision(this.validate(ordinal));
    }

    @Override
    public int getScale(int ordinal) throws SQLException {
        this.validate(ordinal);
        return 0;
    }

    @Override
    public String getSchemaName(int ordinal) throws SQLException {
        this.validate(ordinal);
        return "";
    }

    @Override
    public String getTableName(int ordinal) throws SQLException {
        this.validate(ordinal);
        return "";
    }

    @Override
    public boolean isAutoIncrement(int ordinal) throws SQLException {
        this.validate(ordinal);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int ordinal) throws SQLException {
        this.validate(ordinal);
        return false;
    }

    @Override
    public boolean isCurrency(int ordinal) throws SQLException {
        this.validate(ordinal);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int ordinal) throws SQLException {
        this.validate(ordinal);
        return false;
    }

    @Override
    public int isNullable(int ordinal) throws SQLException {
        this.validate(ordinal);
        return 1;
    }

    @Override
    public boolean isReadOnly(int ordinal) throws SQLException {
        this.validate(ordinal);
        return true;
    }

    @Override
    public boolean isSearchable(int ordinal) throws SQLException {
        this.validate(ordinal);
        return false;
    }

    @Override
    public boolean isSigned(int ordinal) throws SQLException {
        this.validate(ordinal);
        return false;
    }

    @Override
    public boolean isWritable(int ordinal) throws SQLException {
        this.validate(ordinal);
        return false;
    }

    private int _getInt(int ordinal) throws SQLException {
        if (ordinal == 2) {
            return this.rows[this.row].getLength();
        }
        throw new RDMInvalidColumnTypeException().createSQLException();
    }

    private String _getString(int ordinal) {
        if (ordinal == 1) {
            return this.rows[this.row].getName();
        }
        if (ordinal == 2) {
            return Integer.valueOf(this.rows[this.row].getLength()).toString();
        }
        if (ordinal == 3) {
            return this.rows[this.row].getDefault();
        }
        return this.rows[this.row].getDescription();
    }

    private Object _getObject(int ordinal) throws SQLException {
        if (ordinal == 2) {
            return this._getInt(ordinal);
        }
        return this._getString(ordinal);
    }

    public InputStream _getAsciiStream(int ordinal) throws SQLException {
        try {
            return new StringInputStream(this.getString(ordinal));
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    private String _getClassName(int ordinal) {
        if (ordinal == 2) {
            return "Integer";
        }
        return "String";
    }

    private int _getPrecision(int ordinal) {
        if (ordinal == 2) {
            return 10;
        }
        return 255;
    }

    private int _getType(int ordinal) {
        if (ordinal == 2) {
            return 4;
        }
        return 1;
    }

    private String _getTypeName(int ordinal) {
        if (ordinal == 2) {
            return "INTEGER";
        }
        return "CHAR";
    }

    private void validate() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
    }

    private void validateRow() throws SQLException {
        this.validate();
        if (this.row < 0 || this.row >= this.rows.length) {
            throw new SQLException("No current row");
        }
    }

    private int validate(int ordinal) throws SQLException {
        if (ordinal < 1 || ordinal > 4) {
            throw new SQLException("column index out of range");
        }
        return ordinal;
    }

    private int validate(String columnName) throws SQLException {
        for (int ii = 0; ii < names.length; ++ii) {
            if (!columnName.equals(names[ii])) continue;
            return ii;
        }
        throw new SQLException("Column name not found");
    }

    private void notSupported() throws SQLException {
        this.validate();
        throw new SQLException("Operation not supported");
    }

    private void notSupported(int ordinal) throws SQLException {
        this.validate(ordinal);
        throw new SQLException("Operation not supported");
    }

    private void notSupported(String columnName) throws SQLException {
        this.validate(columnName);
        throw new SQLException("Operation not supported");
    }

    private void invalidType(int ordinal) throws SQLException {
        this.validate(ordinal);
        throw new SQLException("Invalid column type");
    }

    private void invalidType(String columnName) throws SQLException {
        this.validate(columnName);
        throw new SQLException("Invalid column type");
    }
}

