/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.sql.RSQLDesc;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.RDMException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Logger;

public class RDMResultSetMetaData
implements ResultSetMetaData {
    int numcols;
    RSQLStatement stmt;
    RSQLDesc[] columns;
    private Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    private static final String className = "RDMResultSet";

    protected RDMResultSetMetaData(RSQLStatement stmt) {
        this.stmt = stmt;
        this.numcols = stmt.getNumCols();
        if (this.numcols == 0 && stmt.getGeneratedKeyName() != null) {
            this.numcols = 1;
        }
        this.columns = new RSQLDesc[this.numcols];
    }

    @Override
    public String getCatalogName(int columnIndex) throws SQLException {
        String str;
        String methodName = "getCatalogName";
        this.logger.entering(className, "getCatalogName", columnIndex);
        try {
            str = this._getDesc("getCatalogName", columnIndex).getCatalog();
        }
        catch (RDMException e) {
            throw this.createSQLException("getCatalogName", e);
        }
        this.logger.exiting(className, "getCatalogName", str);
        return str;
    }

    @Override
    public String getColumnClassName(int columnIndex) throws SQLException {
        String methodName = "getColumnClassName";
        this.logger.entering(className, "getColumnClassName", columnIndex);
        String str = null;
        switch (this._getDesc("getColumnClassName", columnIndex).getType()) {
            case 32769: {
                str = "boolean";
                break;
            }
            case 2: 
            case 32770: {
                str = "bytes";
                break;
            }
            case 258: {
                str = "short";
                break;
            }
            case 514: {
                str = "int";
                break;
            }
            case 770: {
                str = "long";
                break;
            }
            case 515: {
                str = "float";
                break;
            }
            case 771: {
                str = "double";
                break;
            }
            case 5: {
                str = "java.math.BigDecimal";
                break;
            }
            case 9: {
                str = "java.util.UUID";
                break;
            }
            case 8: 
            case 2056: 
            case 4104: {
                str = "java.lang.String";
                break;
            }
            case 6: 
            case 2054: 
            case 4102: {
                str = "byte[]";
                break;
            }
            case 260: {
                str = "java.sql.Date";
                break;
            }
            case 516: {
                str = "java.sql.Time";
                break;
            }
            case 772: {
                str = "java.sql.Timestamp";
                break;
            }
            default: {
                throw this.createSQLException("getColumnClassName", "Invalid data type");
            }
        }
        this.logger.exiting(className, "getColumnClassName", str);
        return str;
    }

    @Override
    public int getColumnCount() throws SQLException {
        String methodName = "getColumnCount";
        this.logger.entering(className, "getColumnCount");
        this.logger.exiting(className, "getColumnCount", this.numcols);
        return this.numcols;
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        String methodName = "getColumnDisplaySize";
        this.logger.entering(className, "getColumnDisplaySize", columnIndex);
        int displaySize = this._getDesc("getColumnDisplaySize", columnIndex).getWidth();
        this.logger.exiting(className, "getColumnDisplaySize", displaySize);
        return displaySize;
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        String methodName = "getColumnLabel";
        this.logger.entering(className, "getColumnLabel", columnIndex);
        String str = this._getDesc("getColumnLabel", columnIndex).getName();
        this.logger.exiting(className, "getColumnLabel", str);
        return str;
    }

    @Override
    public String getColumnName(int columnIndex) throws SQLException {
        String methodName = "getColumnName";
        this.logger.entering(className, "getColumnName", columnIndex);
        String str = this._getDesc("getColumnName", columnIndex).getName();
        this.logger.exiting(className, "getColumnName", str);
        return str;
    }

    private int _getColumnType(String methodName, int type) throws SQLException {
        switch (type) {
            case 8: {
                return 1;
            }
            case 2056: {
                return 12;
            }
            case 4104: {
                return -1;
            }
            case 6: {
                return -2;
            }
            case 2054: {
                return -3;
            }
            case 4102: {
                return -4;
            }
            case 32769: {
                return -7;
            }
            case 32770: {
                return -7;
            }
            case 2: {
                return -6;
            }
            case 258: {
                return 5;
            }
            case 33026: {
                return 5;
            }
            case 514: {
                return 4;
            }
            case 33282: {
                return 4;
            }
            case 7: {
                return -8;
            }
            case 770: {
                return -5;
            }
            case 33538: {
                return -5;
            }
            case 515: {
                return 6;
            }
            case 771: {
                return 8;
            }
            case 5: {
                return 3;
            }
            case 9: {
                return 1111;
            }
            case 260: {
                return 91;
            }
            case 516: {
                return 92;
            }
            case 772: {
                return 93;
            }
        }
        throw this.createSQLException(methodName, "Unsupported type: " + type);
    }

    @Override
    public int getColumnType(int columnIndex) throws SQLException {
        String methodName = "getColumnType";
        this.logger.entering(className, "getColumnType", columnIndex);
        int sqlType = this._getDesc("getColumnType", columnIndex).getType();
        int type = this._getColumnType("getColumnType", sqlType);
        this.logger.exiting(className, "getColumnType", type);
        return type;
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws SQLException {
        String methodName = "getColumnTypeName";
        this.logger.entering(className, "getColumnTypeName", columnIndex);
        String str = null;
        switch (this._getDesc("getColumnTypeName", columnIndex).getType()) {
            case 8: {
                str = "CHAR";
                break;
            }
            case 2056: {
                str = "VARCHAR";
                break;
            }
            case 6: {
                str = "BINARY";
                break;
            }
            case 2054: {
                str = "VARBINARY";
                break;
            }
            case 32769: {
                str = "BIT";
                break;
            }
            case 32770: {
                str = "BIT";
                break;
            }
            case 2: {
                str = "TINYINT";
                break;
            }
            case 258: {
                str = "SMALLINT";
                break;
            }
            case 33026: {
                str = "USMALLINT";
                break;
            }
            case 514: {
                str = "INTEGER";
                break;
            }
            case 33282: {
                str = "UINTEGER";
                break;
            }
            case 770: {
                str = "BIGINT";
                break;
            }
            case 33538: {
                str = "BIGINT";
                break;
            }
            case 515: {
                str = "FLOAT";
                break;
            }
            case 771: {
                str = "DOUBLE";
                break;
            }
            case 5: {
                str = "DECIMAL";
                break;
            }
            case 260: {
                str = "DATE";
                break;
            }
            case 516: {
                str = "TIME";
                break;
            }
            case 772: {
                str = "TIMESTAMP";
                break;
            }
            case 9: {
                str = "GUID";
                break;
            }
            case 7: {
                str = "ROWID";
                break;
            }
            case 4104: {
                str = "LONG VARCHAR";
                break;
            }
            case 4102: {
                str = "LONG VARBINARY";
                break;
            }
            default: {
                throw this.createSQLException("getColumnTypeName", "Unsupported type");
            }
        }
        this.logger.exiting(className, "getColumnTypeName", str);
        return str;
    }

    @Override
    public int getPrecision(int columnIndex) throws SQLException {
        String methodName = "getPrecision";
        this.logger.entering(className, "getPrecision", columnIndex);
        short prec = this._getDesc("getPrecision", columnIndex).getPrecision();
        this.logger.exiting(className, "getPrecision", prec);
        return prec;
    }

    @Override
    public int getScale(int columnIndex) throws SQLException {
        String methodName = "getScale";
        this.logger.entering(className, "getScale", columnIndex);
        short scale = this._getDesc("getScale", columnIndex).getScale();
        this.logger.exiting(className, "getScale", scale);
        return scale;
    }

    @Override
    public String getSchemaName(int columnIndex) throws SQLException {
        String str;
        String methodName = "getSchemaName";
        this.logger.entering(className, "getSchemaName", columnIndex);
        try {
            str = this._getDesc("getSchemaName", columnIndex).getDbase();
        }
        catch (RDMException e) {
            throw this.createSQLException("getSchemaName", e);
        }
        this.logger.exiting(className, "getSchemaName", str);
        return str;
    }

    @Override
    public String getTableName(int columnIndex) throws SQLException {
        String str;
        String methodName = "getTableName";
        this.logger.entering(className, "getTableName", columnIndex);
        try {
            str = this._getDesc("getTableName", columnIndex).getTable();
        }
        catch (RDMException e) {
            throw this.createSQLException("getTableName", e);
        }
        this.logger.exiting(className, "getTableName", str);
        return str;
    }

    @Override
    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        String methodName = "isAutoIncrement";
        this.logger.entering(className, "isAutoIncrement", columnIndex);
        boolean flag = false;
        int type = this._getDesc("isAutoIncrement", columnIndex).getType();
        if (type == 7) {
            flag = true;
        }
        this.logger.exiting(className, "isAutoIncrement", flag);
        return flag;
    }

    @Override
    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        String methodName = "isCaseSensitive";
        this.logger.entering(className, "isCaseSensitive", columnIndex);
        boolean flag = false;
        int type = this._getDesc("isCaseSensitive", columnIndex).getType();
        if (type == 8 || type == 2056 || type == 4104) {
            flag = true;
        }
        this.logger.exiting(className, "isCaseSensitive", flag);
        return flag;
    }

    @Override
    public boolean isCurrency(int columnIndex) throws SQLException {
        String methodName = "isCurrency";
        this.logger.entering(className, "isCurrency", columnIndex);
        boolean flag = false;
        int type = this._getDesc("isCurrency", columnIndex).getType();
        if (type == 5) {
            flag = true;
        }
        this.logger.exiting(className, "isCurrency", flag);
        return flag;
    }

    @Override
    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        String methodName = "isDefinitelyWritable";
        this.logger.entering(className, "isDefinitelyWritable", columnIndex);
        boolean flag = true;
        this.logger.exiting(className, "isDefinitelyWritable", flag);
        return flag;
    }

    @Override
    public int isNullable(int columnIndex) throws SQLException {
        String methodName = "isNullable";
        this.logger.entering(className, "isNullable", columnIndex);
        int flag = this._getDesc("isNullable", columnIndex).getNullable() ? 1 : 0;
        this.logger.exiting(className, "isNullable", flag);
        return flag;
    }

    @Override
    public boolean isReadOnly(int columnIndex) throws SQLException {
        String methodName = "isReadOnly";
        this.logger.entering(className, "isReadOnly", columnIndex);
        this._getDesc("isReadOnly", columnIndex);
        this.logger.exiting(className, "isReadOnly", false);
        return false;
    }

    @Override
    public boolean isSearchable(int columnIndex) throws SQLException {
        String methodName = "isSearchable";
        this.logger.entering(className, "isSearchable", columnIndex);
        boolean flag = true;
        int type = this._getDesc("isSearchable", columnIndex).getType();
        if (type == 4104 || type == 4102) {
            flag = false;
        }
        this.logger.exiting(className, "isSearchable", flag);
        return flag;
    }

    @Override
    public boolean isSigned(int columnIndex) throws SQLException {
        String methodName = "isSigned";
        this.logger.entering(className, "isSigned", columnIndex);
        boolean flag = false;
        int type = this._getDesc("isSigned", columnIndex).getType();
        if (type == 2 || type == 258 || type == 514 || type == 770 || type == 515 || type == 771 || type == 5) {
            flag = true;
        }
        this.logger.exiting(className, "isSigned", flag);
        return flag;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, "isWrapperFor", iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, "isWrapperFor", result);
        return result;
    }

    @Override
    public boolean isWritable(int columnIndex) throws SQLException {
        String methodName = "isWritable";
        this.logger.entering(className, "isWritable", columnIndex);
        boolean flag = true;
        this.logger.exiting(className, "isWritable", flag);
        return flag;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, "unwrap", iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException("unwrap", "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, "unwrap", result);
        return result;
    }

    private RSQLDesc _getDesc(String methodName, int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.numcols) {
            throw this.createSQLException(methodName, "Invalid column number");
        }
        try {
            if (this.columns[columnIndex - 1] == null) {
                this.columns[columnIndex - 1] = this.stmt.describeCol(columnIndex);
            }
        }
        catch (RDMException e) {
            throw this.createSQLException(methodName, e);
        }
        return this.columns[columnIndex - 1];
    }

    private SQLException createSQLException(String methodName, RDMException e) throws SQLException {
        SQLException sqlex = e.createSQLException();
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private SQLException createSQLException(String methodName, String error) throws SQLException {
        SQLException sqlex = new SQLException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

