/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMLogicalConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class RDMPooledConnection
implements PooledConnection {
    private LinkedList<ConnectionEventListener> connListeners;
    private LinkedList<StatementEventListener> stmtListeners;
    private Connection con;
    private RDMLogicalConnection lcon = null;
    private Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    public static final int CLOSED = 0;
    public static final int ERROR_OCCURRED = 1;
    private static final String className = "RDMPooledConnection";

    public RDMPooledConnection(Connection conn) {
        this.con = conn;
        this.connListeners = new LinkedList();
        this.stmtListeners = new LinkedList();
    }

    @Override
    public Connection getConnection() throws SQLException {
        String methodName = "getConnection";
        this.logger.entering(className, methodName);
        if (this.con == null) {
            this.connNotify(1, new SQLException("invalid connection"));
        } else {
            try {
                if (this.lcon != null) {
                    this.lcon.close();
                    this.lcon = null;
                }
                this.lcon = new RDMLogicalConnection(this, this.con);
            }
            catch (SQLException e) {
                this.connNotify(1, e);
            }
        }
        this.logger.exiting(className, methodName, this.lcon);
        return this.lcon;
    }

    @Override
    public void close() throws SQLException {
        String methodName = "close";
        this.logger.entering(className, methodName);
        this.con.close();
        this.con = null;
        this.connListeners = null;
        this.stmtListeners = null;
        this.logger.exiting(className, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        String methodName = "addConnectionEventListener";
        this.logger.entering(className, methodName, listener);
        if (this.connListeners != null) {
            LinkedList<ConnectionEventListener> linkedList = this.connListeners;
            synchronized (linkedList) {
                this.connListeners.add(listener);
            }
        }
        this.logger.exiting(className, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        String methodName = "removeConnectionEventListener";
        this.logger.entering(className, methodName, listener);
        if (this.connListeners != null) {
            LinkedList<ConnectionEventListener> linkedList = this.connListeners;
            synchronized (linkedList) {
                this.connListeners.remove(listener);
            }
        }
        this.logger.exiting(className, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        String methodName = "addStatementEventListener";
        this.logger.entering(className, methodName, listener);
        if (this.stmtListeners != null) {
            LinkedList<StatementEventListener> linkedList = this.stmtListeners;
            synchronized (linkedList) {
                this.stmtListeners.add(listener);
            }
        }
        this.logger.exiting(className, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        String methodName = "removeStatementEventListener";
        this.logger.entering(className, methodName, listener);
        if (this.stmtListeners != null) {
            LinkedList<StatementEventListener> linkedList = this.stmtListeners;
            synchronized (linkedList) {
                this.stmtListeners.remove(listener);
            }
        }
        this.logger.exiting(className, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connNotify(int type, SQLException e) {
        if (this.connListeners == null) {
            return;
        }
        LinkedList<ConnectionEventListener> linkedList = this.connListeners;
        synchronized (linkedList) {
            ListIterator<ConnectionEventListener> iter = this.connListeners.listIterator(0);
            ConnectionEvent event = new ConnectionEvent(this, e);
            while (iter.hasNext()) {
                ConnectionEventListener listener = iter.next();
                if (type == 0) {
                    listener.connectionClosed(event);
                    continue;
                }
                if (type != 1) continue;
                listener.connectionErrorOccurred(event);
            }
        }
    }
}

