/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMSettings;
import com.raima.rdm.util.JDBCURL;
import com.raima.rdm.util.RDMHostInfo;
import java.sql.DriverPropertyInfo;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class RDMJDBCURL
implements JDBCURL {
    public String url;
    public String driver;
    public LinkedList<RDMHostInfo> hostlist;
    public LinkedList<String> dblist;
    public RDMSettings settings;
    private static final String driverStr = "jdbc:raima:rdm:";

    public RDMJDBCURL() throws Exception {
        this.url = "";
        this.parse("jdbc:raima:rdm://local", null);
    }

    public RDMJDBCURL(String url, Properties props) throws Exception {
        this.url = url;
        this.parse(url, props);
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getCurrentURL() {
        Iterator iter;
        boolean first;
        boolean local = this.hostlist.size() == 0;
        StringBuilder str = new StringBuilder("jdbc:raima:rdm://");
        if (local) {
            str.append("local");
        } else {
            first = true;
            iter = this.hostlist.iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    str.append(",");
                }
                str.append(iter.next());
            }
        }
        if (this.dblist.size() > 0) {
            str.append("/");
            first = true;
            iter = this.dblist.iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    str.append(",");
                }
                str.append((String)iter.next());
            }
        }
        this.settings.addToURL(str, local);
        return str.toString();
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public LinkedList<RDMHostInfo> getHostList() {
        return this.hostlist;
    }

    @Override
    public void setHostList(LinkedList<RDMHostInfo> hostlist) {
        this.hostlist = hostlist;
    }

    @Override
    public LinkedList<String> getDbList() {
        return this.dblist;
    }

    @Override
    public void setDbList(LinkedList<String> dblist) {
        this.dblist = dblist;
    }

    private void parse(String url, Properties props) throws Exception {
        String[] parts = url.split("//", 2);
        this.driver = parts[0];
        this.hostlist = new LinkedList();
        this.dblist = new LinkedList();
        this.settings = new RDMSettings(props);
        if (!this.driver.equals(driverStr)) {
            throw new Exception("Malformed JDBC URL - Unknown JDBC driver: '" + this.driver + "'");
        }
        if (parts.length == 2) {
            if ((parts = parts[1].split("\\?", 2)).length > 1) {
                this.parseProperties(parts[1]);
            }
            parts = parts[0].split("/", 2);
            this.parseHosts(parts[0]);
            if (parts.length > 1) {
                this.parseDbs(parts[1]);
            }
        }
    }

    private void parseProperties(String str) throws Exception {
        Properties props = new Properties(this.settings.getProperties());
        String[] parts = str.split("&", -1);
        for (int ii = 0; ii < parts.length; ++ii) {
            if (parts[ii].length() == 0) {
                throw new Exception("Malformed JDBC URL - Invalid use of '&'");
            }
            String[] pair = parts[ii].split("=");
            if (pair.length != 2) {
                throw new Exception("Malformed JDBC URL - properties must be of the form 'prop=value'");
            }
            props.put(pair[0].trim(), pair[1].trim());
        }
        this.settings.override(props);
    }

    private void parseHosts(String str) throws Exception {
        if (str.equals("local")) {
            return;
        }
        String[] list = str.split(",", -1);
        for (int ii = 0; ii < list.length; ++ii) {
            if (list[ii].length() == 0) {
                throw new Exception("Malformed JDBC URL - Invalid use of ',' in host data");
            }
            String[] hostport = list[ii].split(":", -1);
            if (hostport.length == 1) {
                if (hostport[0].length() == 0) {
                    throw new Exception("Malformed JDBC URL - Invalid use of ':' in host data");
                }
                this.hostlist.addLast(new RDMHostInfo(hostport[0], 21553));
                continue;
            }
            if (hostport.length == 2) {
                if (hostport[0].length() == 0 || hostport[1].length() == 0) {
                    throw new Exception("Malformed JDBC URL - Invalid use of ':' in host data");
                }
                try {
                    int port = Integer.parseInt(hostport[1]);
                    if (port < 0 || port > 65535) {
                        throw new Exception("Malformed JDBC URL - Invalid port number: " + port);
                    }
                    this.hostlist.addLast(new RDMHostInfo(hostport[0], port));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Malformed JDBC URL - Port number not valid: " + e.getMessage());
                }
            }
            throw new Exception("Malformed JDBC URL - Invalid use of ':' in host data");
        }
    }

    private void parseDbs(String str) throws Exception {
        String[] list = str.split(",", -1);
        for (int ii = 0; ii < list.length; ++ii) {
            if (list[ii].length() == 0) {
                throw new Exception("Malformed JDBC URL - Invalid use of ',' in database data");
            }
            this.dblist.addLast(list[ii]);
        }
    }

    @Override
    public void override(Properties props) {
        this.settings.override(props);
    }

    @Override
    public boolean getAutoCommit() {
        return this.settings.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autocommit) {
        this.settings.setAutoCommit(autocommit);
    }

    public void setOptimizeParameters(boolean optParams) {
        this.settings.setOptimizeParameters(optParams);
    }

    public boolean getOptimizeParameters() {
        return this.settings.getOptimizeParameters();
    }

    @Override
    public int getTransIsolation() {
        return this.settings.getTransIsolation();
    }

    @Override
    public void setTransIsolation(int transIsolation) {
        this.settings.setTransIsolation(transIsolation);
    }

    @Override
    public String getOpenMode() {
        return this.settings.getOpenMode();
    }

    @Override
    public void setOpenMode(String openmode) {
        this.settings.setOpenMode(openmode);
    }

    @Override
    public boolean getReadOnlyMode() {
        return this.settings.getReadOnlyMode();
    }

    @Override
    public String getDateFormat() {
        return this.settings.getDateFormat();
    }

    @Override
    public void setDateFormat(String format) {
        this.settings.setDateFormat(format);
    }

    @Override
    public int getLockTimeout() {
        return this.settings.getLockTimeout();
    }

    @Override
    public void setLockTimeout(int timeout) {
        this.settings.setLockTimeout(timeout);
    }

    @Override
    public boolean getROTMode() {
        return this.settings.getROTMode();
    }

    @Override
    public void setROTMode(boolean mode) {
        this.settings.setROTMode(mode);
    }

    @Override
    public String getStorage() {
        return this.settings.getStorage();
    }

    @Override
    public void setStorage(String storage) {
        this.settings.setStorage(storage);
    }

    @Override
    public String getDocroot() {
        return this.settings.getDocroot();
    }

    @Override
    public void setDocroot(String docroot) {
        this.settings.setDocroot(docroot);
    }

    @Override
    public String getTfsType() {
        return this.settings.getTfsType();
    }

    @Override
    public void setTfsType(String tfstype) {
        this.settings.setTfsType(tfstype);
    }

    public int getPrefetchSize() {
        return this.settings.getPrefetchSize();
    }

    public void setPrefetchSize(int prefetchSize) {
        this.settings.setPrefetchSize(prefetchSize);
    }

    public int getCacheSize() {
        return this.settings.getCacheSize();
    }

    public void setCacheSize(int cacheSize) {
        this.settings.setCacheSize(cacheSize);
    }

    @Override
    public String getAppName() {
        return this.settings.getAppName();
    }

    @Override
    public void setAppName(String appname) {
        this.settings.setAppName(appname);
    }

    @Override
    public Properties getProperties() {
        return this.settings.getProperties();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo() {
        if (this.hostlist.size() == 0) {
            return this.settings.getPropertyInfo(true);
        }
        return this.settings.getPropertyInfo(false);
    }

    public static boolean acceptsURL(String url) {
        return url.startsWith(driverStr);
    }
}

