/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.util.ClobHandler;
import java.io.IOException;
import java.io.Writer;

class RDMClobWriter
extends Writer {
    long pos;
    ClobHandler clobhandler;

    RDMClobWriter(ClobHandler clobhandler, long pos) {
        this.clobhandler = clobhandler;
        this.pos = pos;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.clobhandler.write(this.pos, c);
        ++this.pos;
        return this;
    }

    private Writer _append(CharSequence cs, int start, int end) throws IOException {
        this.clobhandler.write(this.pos, cs.subSequence(start, end).toString().toCharArray());
        this.pos += (long)(end - start);
        return this;
    }

    @Override
    public Writer append(CharSequence cs) throws IOException {
        if (cs == null) {
            throw new NullPointerException();
        }
        return this._append(cs, 0, cs.length());
    }

    @Override
    public Writer append(CharSequence cs, int start, int end) throws IOException {
        if (cs == null) {
            throw new NullPointerException();
        }
        if (start < 0 || end < 0 || start > end || end > cs.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this._append(cs, start, end);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    private void _write(char[] cb, int off, int len) throws IOException {
        this.clobhandler.write(this.pos, cb, off, len);
        this.pos += (long)len;
    }

    @Override
    public void write(char[] cb) throws IOException {
        if (cb == null) {
            throw new NullPointerException();
        }
        this._write(cb, 0, cb.length);
    }

    @Override
    public void write(char[] cb, int off, int len) throws IOException {
        if (cb == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > cb.length) {
            throw new IndexOutOfBoundsException();
        }
        this._write(cb, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.clobhandler.write(this.pos, (char)c);
        ++this.pos;
    }

    private void _write(String str, int off, int len) throws IOException {
        this.clobhandler.write(this.pos, str.substring(off, off + len).toCharArray());
    }

    @Override
    public void write(String str) throws IOException {
        if (str == null) {
            throw new NullPointerException();
        }
        this._write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (str == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > str.length()) {
            throw new IndexOutOfBoundsException();
        }
        this._write(str, off, len);
    }
}

