/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.util.BlobHandler;
import java.io.IOException;
import java.io.OutputStream;

class RDMBlobOutputStream
extends OutputStream {
    long pos;
    BlobHandler blobhandler;

    public RDMBlobOutputStream(BlobHandler blobhandler, long pos) {
        this.pos = pos;
        this.blobhandler = blobhandler;
    }

    @Override
    public void close() throws IOException {
        this.blobhandler = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.blobhandler == null) {
            throw new IOException();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b == null ? 0 : b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.blobhandler == null) {
            throw new IOException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.blobhandler.write(this.pos, b, off, len);
        this.pos += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.blobhandler == null) {
            throw new IOException();
        }
        this.blobhandler.write(this.pos, (byte)b);
        ++this.pos;
    }
}

