/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.k8s;

import com.dbeaver.net.k8s.KubeCtrlExecutor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class K8STunnelImpl
implements DBWTunnel {
    private static final Log log = Log.getLog(K8STunnelImpl.class);
    public static final int MAX_FORWARD_ATTEMPT_COUNT = 50;
    private DBWHandlerConfiguration configuration;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private int localPort = -1;
    private Process forwardPortProccess;

    public static String getDefaultRemotePort(@NotNull DBWHandlerConfiguration configuration) {
        String hostPort = "";
        if (configuration.getDataSource() != null && CommonUtils.isEmpty((String)(hostPort = configuration.getDataSource().getConnectionConfiguration().getHostPort()))) {
            hostPort = configuration.getDriver().getDefaultPort();
        }
        return hostPort;
    }

    public void addCloseListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public DBPConnectionConfiguration initializeHandler(DBRProgressMonitor monitor, DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        this.configuration = configuration;
        this.localPort = IOUtils.findFreePort((int)10000, (int)60000);
        monitor.subTask("Initiate port forwarding");
        ArrayList<String> args = new ArrayList<String>();
        args.add("port-forward");
        args.add(configuration.getStringProperty("resource"));
        String remotePort = configuration.getStringProperty("remotePort");
        if (CommonUtils.isEmpty((String)remotePort)) {
            remotePort = K8STunnelImpl.getDefaultRemotePort(configuration);
        }
        args.add(String.valueOf(this.localPort) + ":" + remotePort);
        this.forwardPortProccess = KubeCtrlExecutor.executeCommandAndWait(monitor, configuration, args.toArray(new String[0]));
        int attemptCount = 0;
        while (this.forwardPortProccess.isAlive() && attemptCount < 50) {
            monitor.subTask("Waiting for tunnel establish");
            ++attemptCount;
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (Socket testSocket = new Socket();){
                    InetSocketAddress addr = new InetSocketAddress("127.0.0.1", this.localPort);
                    testSocket.connect(addr);
                    break;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                RuntimeUtils.pause((int)100);
            }
        }
        if (attemptCount >= 50) {
            this.closeTunnel(monitor);
            throw new DBException("Error establishing port forwarding. Max attempt count (50) exceeded.");
        }
        monitor.subTask("Complete configuration");
        if (!this.forwardPortProccess.isAlive()) {
            try {
                RuntimeUtils.getProcessResults((Process)this.forwardPortProccess);
            }
            catch (InterruptedException interruptedException) {
                this.forwardPortProccess = null;
            }
        }
        DBWUtils.updateConfigWithTunnelInfo((DBWHandlerConfiguration)configuration, (DBPConnectionConfiguration)connectionInfo, null, (int)this.localPort);
        return connectionInfo;
    }

    public void closeTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        for (Runnable listener : this.listeners) {
            listener.run();
        }
        this.listeners.clear();
        if (this.forwardPortProccess != null) {
            if (this.forwardPortProccess.isAlive()) {
                this.forwardPortProccess.destroy();
            }
            this.forwardPortProccess = null;
        }
    }

    public Object getImplementation() {
        return this;
    }

    public boolean matchesParameters(String host, int port) {
        if (host.equals(this.configuration.getStringProperty("host"))) {
            int sshPort = this.configuration.getIntProperty("port");
            return sshPort == port;
        }
        return false;
    }

    public DBWTunnel.AuthCredentials getRequiredCredentials(DBWHandlerConfiguration configuration) {
        return this.getRequiredCredentials(configuration, null);
    }

    public DBWTunnel.AuthCredentials getRequiredCredentials(DBWHandlerConfiguration configuration, @Nullable String prefix) {
        return DBWTunnel.AuthCredentials.CREDENTIALS;
    }

    public void invalidateHandler(DBRProgressMonitor monitor, DBPDataSource dataSource) throws DBException, IOException {
    }
}

