/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc.bridge.util;

import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcUtil;
import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public class OdbcInvocationHandler
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(OdbcLibrary.class.getName());
    private final Library library;
    private final Library.Handler handler;

    private OdbcInvocationHandler(@NotNull Library library, @NotNull Library.Handler handler) {
        this.library = library;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        NativeLibrary nativeLibrary = this.handler.getNativeLibrary();
        synchronized (nativeLibrary) {
            if (OdbcUtil.isTracingEnabled() && method.getDeclaringClass() == OdbcLibrary.class) {
                log.info(() -> "[ODBC] " + OdbcInvocationHandler.getMethodInvocationPresentation(method, args));
            }
            return this.handler.invoke((Object)this.library, method, args);
        }
    }

    public static <T extends Library> T wrap(@NotNull T library) {
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException("Unrecognized proxy handler: " + ih);
        }
        Library.Handler oldHandler = (Library.Handler)ih;
        OdbcInvocationHandler newHandler = new OdbcInvocationHandler(library, oldHandler);
        return (T)((Library)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), (InvocationHandler)newHandler));
    }

    @NotNull
    private static String getMethodInvocationPresentation(@NotNull Method method, @NotNull Object[] args) {
        StringBuilder buffer = new StringBuilder(method.getName()).append('(');
        Parameter[] parameters = method.getParameters();
        int i = 0;
        while (i < parameters.length) {
            buffer.append(parameters[i].getName()).append('=').append(CommonUtils.getSingleLineString((String)String.valueOf(args[i])));
            if (i < parameters.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        return buffer.append(')').toString();
    }
}

