/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc.bridge.util;

import com.dbeaver.jdbc.odbc.bridge.OdbcHandle;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.OdbcResource;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class OdbcException
extends SQLException {
    public OdbcException(@NotNull String reason) {
        super(reason, null, 0);
    }

    public OdbcException(@NotNull String reason, @Nullable String state, int vendorCode) {
        super(String.format("[%d][%s]: %s", vendorCode, state, reason), state, vendorCode);
    }

    public static void check(@NotNull OdbcResource<?> resource, int rc) throws SQLException {
        if (rc == 1) {
            resource.addWarning();
        }
        OdbcException.check(rc, resource.getHandle());
    }

    public static void check(int rc, @NotNull OdbcHandle handle) throws SQLException {
        if (OdbcException.succeeded(rc)) {
            return;
        }
        OdbcException exception = OdbcException.diagnose(handle);
        if (exception != null) {
            throw exception;
        }
        switch (rc) {
            case -2: {
                throw new OdbcException("Invalid handle: " + (Object)((Object)handle.getType()), null, 0);
            }
            case 99: {
                throw new OdbcException("Need data", null, 0);
            }
            case 100: {
                throw new OdbcException("No data", null, 0);
            }
        }
        throw new OdbcException("Unknown error", null, 0);
    }

    @Nullable
    public static OdbcException diagnose(@NotNull OdbcHandle handle) {
        if (handle.isClosed()) {
            return null;
        }
        ShortByReference messageLength = new ShortByReference();
        IntByReference nativeError = new IntByReference();
        Memory message = new Memory(512L * (long)Native.WCHAR_SIZE + 1L);
        Memory state = new Memory(5L * (long)Native.WCHAR_SIZE + 1L);
        OdbcException root = null;
        short index = 1;
        while (index <= 1) {
            if (!OdbcException.succeeded(OdbcLibrary.INSTANCE.SQLGetDiagRecW(handle.getType(), handle, index, (Pointer)state, nativeError, (Pointer)message, (short)512, messageLength))) break;
            if (messageLength.getValue() != 0) {
                OdbcException exception = new OdbcException(message.getWideString(0L), state.getWideString(0L), nativeError.getValue());
                if (root == null) {
                    root = exception;
                } else {
                    root.setNextException(exception);
                }
            }
            index = (short)(index + 1);
        }
        return root;
    }

    @NotNull
    public SQLWarning toWarning() {
        return new SQLWarning(this.getMessage(), this.getSQLState(), this.getErrorCode());
    }

    public static boolean succeeded(int rc) {
        return rc == 0 || rc == 1;
    }
}

