/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc;

import com.dbeaver.jdbc.odbc.JdbcOdbcBridgeDriver;
import com.dbeaver.jdbc.odbc.bridge.OdbcHandle;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;

public class JdbcOdbcUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static DataSourceInfo[] listDataSources(@NotNull DataSourceType type) throws SQLException {
        OdbcHandle.Environment handle = JdbcOdbcBridgeDriver.getDriverState().getHandleAndOpenIfRequired();
        ArrayList<DataSourceInfo> result = new ArrayList<DataSourceInfo>();
        short direction = switch (type) {
            case DataSourceType.SYSTEM -> 32;
            case DataSourceType.USER -> 31;
            default -> 2;
        };
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Memory nameBuffer = new Memory(256L * (long)Native.WCHAR_SIZE + 1L);
            try {
                try (Memory descBuffer = new Memory(256L * (long)Native.WCHAR_SIZE + 1L);){
                    short rc;
                    while ((rc = OdbcLibrary.INSTANCE.SQLDataSourcesW(handle, direction, (Pointer)nameBuffer, (short)256, null, (Pointer)descBuffer, (short)256, null)) != 100) {
                        OdbcException.check(rc, handle);
                        String name = nameBuffer.getWideString(0L);
                        String desc = descBuffer.getWideString(0L);
                        result.add(new DataSourceInfo(name, desc));
                        direction = 1;
                    }
                }
                if (nameBuffer == null) return (DataSourceInfo[])result.toArray(DataSourceInfo[]::new);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (nameBuffer == null) throw throwable;
                nameBuffer.close();
                throw throwable;
            }
            nameBuffer.close();
            return (DataSourceInfo[])result.toArray(DataSourceInfo[]::new);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static DriverInfo[] listDrivers() throws SQLException {
        OdbcHandle.Environment handle = JdbcOdbcBridgeDriver.getDriverState().getHandleAndOpenIfRequired();
        ArrayList<DriverInfo> result = new ArrayList<DriverInfo>();
        short direction = 2;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Memory descBuffer = new Memory(256L * (long)Native.WCHAR_SIZE + 1L);
            try {
                try (Memory attrBuffer = new Memory(256L * (long)Native.WCHAR_SIZE + 1L);){
                    short rc;
                    while ((rc = OdbcLibrary.INSTANCE.SQLDriversW(handle, direction, (Pointer)descBuffer, (short)256, null, (Pointer)attrBuffer, (short)256, null)) != 100) {
                        OdbcException.check(rc, handle);
                        String desc = descBuffer.getWideString(0L);
                        HashMap<String, String> attrs = new HashMap<String, String>();
                        int offset = 0;
                        while ((long)offset < attrBuffer.size() - 1L) {
                            String attr = attrBuffer.getWideString((long)offset);
                            if (attr.isEmpty()) break;
                            String[] parts = attr.split("=");
                            if (parts.length == 2) {
                                attrs.put(parts[0], parts[1]);
                            } else {
                                attrs.put(parts[0], null);
                            }
                            offset += attr.length() * Native.WCHAR_SIZE;
                        }
                        result.add(new DriverInfo(desc, Collections.unmodifiableMap(attrs)));
                        direction = 1;
                    }
                }
                if (descBuffer == null) return (DriverInfo[])result.toArray(DriverInfo[]::new);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (descBuffer == null) throw throwable;
                descBuffer.close();
                throw throwable;
            }
            descBuffer.close();
            return (DriverInfo[])result.toArray(DriverInfo[]::new);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static class DataSourceInfo {
        private final String name;
        private final String description;

        public DataSourceInfo(@NotNull String name, @NotNull String description) {
            this.name = name;
            this.description = description;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getDescription() {
            return this.description;
        }
    }

    public static enum DataSourceType {
        SYSTEM,
        USER,
        ALL;

    }

    public static class DriverInfo {
        private final String description;
        private final Map<String, String> attributes;

        public DriverInfo(@NotNull String description, @NotNull Map<String, String> attributes) {
            this.description = description;
            this.attributes = attributes;
        }

        @NotNull
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public Map<String, String> getAttributes() {
            return this.attributes;
        }
    }
}

