/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc;

import com.dbeaver.jdbc.base.AbstractJdbcConnection;
import com.dbeaver.jdbc.base.AbstractJdbcStatement;
import com.dbeaver.jdbc.odbc.JdbcOdbcConnection;
import com.dbeaver.jdbc.odbc.JdbcOdbcResultSet;
import com.dbeaver.jdbc.odbc.JdbcOdbcResultSetMetaData;
import com.dbeaver.jdbc.odbc.bridge.OdbcHandle;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.OdbcResource;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcException;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcUtil;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class JdbcOdbcStatement
extends AbstractJdbcStatement<JdbcOdbcConnection> {
    private final OdbcResource<OdbcHandle.Statement> resource;
    protected JdbcOdbcResultSet resultSet;

    public JdbcOdbcStatement(@NotNull JdbcOdbcConnection connection) throws SQLException {
        super((AbstractJdbcConnection)connection);
        this.resource = new OdbcResource<OdbcHandle.Statement>(connection.getResource(), connection.getHandle().newStatementHandle());
    }

    OdbcResource<OdbcHandle.Statement> getResource() {
        return this.resource;
    }

    OdbcHandle.Statement getHandle() {
        return this.resource.getHandle();
    }

    void ensureOpen() throws SQLException {
        this.resource.ensureOpen();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.execute(sql)) {
            return this.resultSet;
        }
        throw new SQLException("No result set was produced");
    }

    public boolean isClosed() throws SQLException {
        return this.resource.isClosed();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.resource.close();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resource.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resource.clearWarnings();
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.getAttrInt((short)3);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.setAttrInt((short)3, max);
    }

    public int getMaxRows() throws SQLException {
        return (int)Math.min(this.getLargeMaxRows(), Integer.MAX_VALUE);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.setAttrInt((short)2, enable ? 0 : 1);
    }

    public int getQueryTimeout() throws SQLException {
        return this.getAttrInt((short)0);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.setAttrInt((short)0, seconds);
    }

    public void cancel() throws SQLException {
        this.ensureOpen();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLCancelHandle(this.getHandle().getType(), this.getHandle()), this.getHandle());
    }

    public void setCursorName(String name) throws SQLException {
        this.ensureOpen();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLSetCursorNameW(this.getHandle(), Objects.requireNonNull(name, "name must not be null"), (short)-3), this.getHandle());
    }

    public ResultSet getResultSet() throws SQLException {
        this.ensureOpen();
        return this.resultSet;
    }

    public int getUpdateCount() throws SQLException {
        if (this.resultSet == null) {
            return this.getRowCount();
        }
        return -1;
    }

    public long getLargeUpdateCount() throws SQLException {
        return this.getUpdateCount();
    }

    public long[] executeLargeBatch() throws SQLException {
        return IntStream.of(this.executeBatch()).asLongStream().toArray();
    }

    @NotNull
    public JdbcOdbcResultSet createResultSet() throws SQLException {
        return this.createResultSet(null, false);
    }

    @NotNull
    public JdbcOdbcResultSet createResultSet(boolean orphan) throws SQLException {
        return this.createResultSet(null, orphan);
    }

    @NotNull
    public JdbcOdbcResultSet createResultSet(@Nullable JdbcOdbcResultSetMetaData metadata) throws SQLException {
        return this.createResultSet(metadata, false);
    }

    public JdbcOdbcResultSet createResultSet(@Nullable JdbcOdbcResultSetMetaData metadata, boolean orphan) throws SQLException {
        this.ensureOpen();
        if (this.resultSet != null) {
            throw new OdbcException("Result set is not closed");
        }
        this.resultSet = metadata != null ? new JdbcOdbcResultSet(this, metadata, orphan) : new JdbcOdbcResultSet(this, orphan);
        return this.resultSet;
    }

    protected boolean execute(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        short rc;
        this.ensureOpen();
        if (autoGeneratedKeys != 2) {
            throw new SQLException("Unsupported value for autoGeneratedKeys: " + autoGeneratedKeys);
        }
        if (columnNames != null) {
            throw OdbcUtil.notImplemented();
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        if ((rc = OdbcLibrary.INSTANCE.SQLExecDirectW(this.getHandle(), sql, -3)) != 100) {
            OdbcException.check(this.resource, rc);
        }
        if (this.getColumnCount() > 0) {
            this.resultSet = new JdbcOdbcResultSet(this, new JdbcOdbcResultSetMetaData(this, null, columnIndexes));
            return true;
        }
        return false;
    }

    protected int executeUpdate(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        if (this.execute(sql, columnIndexes, columnNames, autoGeneratedKeys)) {
            return this.getUpdateCount();
        }
        throw new SQLException("No update count was produced");
    }

    private int getRowCount() throws SQLException {
        this.ensureOpen();
        IntByReference value = new IntByReference();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLRowCount(this.getHandle(), value), this.getHandle());
        return value.getValue();
    }

    protected int getColumnCount() throws SQLException {
        this.ensureOpen();
        ShortByReference value = new ShortByReference();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLNumResultCols(this.getHandle(), value), this.getHandle());
        return value.getValue();
    }

    int getAttrInt(short attribute) throws SQLException {
        this.ensureOpen();
        IntByReference value = new IntByReference();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLGetStmtAttrW(this.getHandle(), (int)attribute, (ByReference)value, 0, null), this.getHandle());
        return value.getValue();
    }

    void setAttrInt(short attribute, int value) throws SQLException {
        this.ensureOpen();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLSetStmtAttrW(this.getHandle(), attribute, Pointer.createConstant((int)value), 0), this.getHandle());
    }

    void setAttrLong(short attribute, long value) throws SQLException {
        this.ensureOpen();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLSetStmtAttrW(this.getHandle(), attribute, Pointer.createConstant((long)value), 0), this.getHandle());
    }
}

